/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class OxygenSaturation
extends HealthData {
    private static final int DATA_INTERVAL = 1;
    private int percent;
    private int maxValue;
    private int minValue;
    private int singleTestValue;

    public OxygenSaturation(int n, byte by, byte[] byArray) {
        OxygenSaturation oxygenSaturation = this;
        super(5, by, byArray, n);
        oxygenSaturation.parseOxygenSaturationData(n, by, byArray);
    }

    private void parseOxygenSaturationData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            block6: for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1) continue;
                switch (i) {
                    default: {
                        continue block6;
                    }
                    case 3: {
                        this.singleTestValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 2: {
                        this.minValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 1: {
                        this.maxValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 0: {
                        this.percent = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                    }
                }
            }
        } else {
            JL_Log.e("OxygenSaturation", "no support version : " + n);
        }
    }

    private int getValueFromData(int n, byte[] byArray) {
        if (byArray != null && n + 1 <= byArray.length) {
            return CHexConver.byteToInt(byArray[n]);
        }
        return 0;
    }

    public int getPercent() {
        return this.percent;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getSingleTestValue() {
        return this.singleTestValue;
    }

    @Override
    public String toString() {
        return "OxygenSaturation{percent=" + this.percent + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", singleTestValue=" + this.singleTestValue + "} " + super.toString();
    }
}

