/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.parameter;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FirmwareUpdateBlockParam
extends BaseParameter {
    private int nextUpdateBlockOffsetAddr;
    private int nextUpdateBlockLen;

    public FirmwareUpdateBlockParam() {
    }

    public FirmwareUpdateBlockParam(int n, int n2) {
        this.setNextUpdateBlockOffsetAddr(n).setNextUpdateBlockLen(n2);
    }

    public int getNextUpdateBlockOffsetAddr() {
        return this.nextUpdateBlockOffsetAddr;
    }

    public FirmwareUpdateBlockParam setNextUpdateBlockOffsetAddr(int n) {
        this.nextUpdateBlockOffsetAddr = n;
        return this;
    }

    public int getNextUpdateBlockLen() {
        return this.nextUpdateBlockLen;
    }

    public FirmwareUpdateBlockParam setNextUpdateBlockLen(int n) {
        this.nextUpdateBlockLen = n;
        return this;
    }

    @Override
    public byte[] getParamData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(CHexConver.intToBigBytes(this.nextUpdateBlockOffsetAddr));
        byteBuffer.put(CHexConver.int2byte2(this.nextUpdateBlockLen));
        return byteBuffer.array();
    }

    @Override
    public String toString() {
        return "FirmwareUpdateBlockParam{nextUpdateBlockOffsetAddr=" + this.nextUpdateBlockOffsetAddr + ", nextUpdateBlockLen=" + this.nextUpdateBlockLen + '}';
    }
}

