/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.tool;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.watch.ReceiveHealthDataCmd;
import com.jieli.jl_rcsp.model.command.watch.RequestHealthDataCmd;
import com.jieli.jl_rcsp.model.command.watch.SensorLogCmd;
import com.jieli.jl_rcsp.model.command.watch.SportsInfoStatusSyncCmd;
import com.jieli.jl_rcsp.model.device.health.AirPressure;
import com.jieli.jl_rcsp.model.device.health.Altitude;
import com.jieli.jl_rcsp.model.device.health.ExerciseRecoveryTime;
import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.model.device.health.HeartRate;
import com.jieli.jl_rcsp.model.device.health.MaxOxygenUptake;
import com.jieli.jl_rcsp.model.device.health.OxygenSaturation;
import com.jieli.jl_rcsp.model.device.health.PressureDetection;
import com.jieli.jl_rcsp.model.device.health.SportsInfo;
import com.jieli.jl_rcsp.model.device.health.SportsSteps;
import com.jieli.jl_rcsp.model.device.health.TrainingLoad;
import com.jieli.jl_rcsp.tool.callback.RcspEventListenerManager;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HealthDataParseHelper {
    private static final String d = "HealthDataParseHelper";
    private final RcspEventListenerManager a;
    private final RcspOpImpl b;
    private RecombineHealthDataBuffer c;

    public HealthDataParseHelper(RcspOpImpl rcspOpImpl, RcspEventListenerManager rcspEventListenerManager) {
        this.a = rcspEventListenerManager;
        this.b = rcspOpImpl;
    }

    private void a(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        if (n != 0) {
            JL_Log.w(d, "no implement parse version = " + n + " health data");
        } else {
            int n2;
            int n3 = 0;
            while ((n2 = n3 + 4) <= byArray.length) {
                int n4 = CHexConver.bytesToInt(byArray[n3], byArray[n3 + 1]);
                int n5 = n3;
                n3 = byArray[n3 + 2];
                byte by = byArray[n5 + 3];
                int n6 = n4 - 2;
                if (n6 <= 0) {
                    JL_Log.w(d, "handleHealthData : -------- missing health sensor data --------");
                    n3 = n2;
                    continue;
                }
                int n7 = n2 + n6;
                if (n7 > byArray.length) {
                    JL_Log.w(d, "handleHealthData : -------- health sensor data length error --------");
                    break;
                }
                byte[] byArray2 = new byte[n6];
                System.arraycopy(byArray, n2, byArray2, 0, n6);
                RcspEventListenerManager rcspEventListenerManager = this.a;
                if (rcspEventListenerManager != null) {
                    rcspEventListenerManager.onHealthDataChange(bluetoothDevice, this.a(n, n3, by, byArray2));
                }
                n3 = n7;
            }
        }
    }

    private HealthData a(int n, int n2, byte by, byte[] byArray) {
        switch (n2) {
            default: {
                HealthData healthData;
                Object object = healthData;
                healthData = new HealthData(n2, by, byArray, n);
                break;
            }
            case 8: {
                ExerciseRecoveryTime exerciseRecoveryTime;
                Object object = exerciseRecoveryTime;
                exerciseRecoveryTime = new ExerciseRecoveryTime(n, by, byArray);
                break;
            }
            case 7: {
                MaxOxygenUptake maxOxygenUptake;
                Object object = maxOxygenUptake;
                maxOxygenUptake = new MaxOxygenUptake(n, by, byArray);
                break;
            }
            case 6: {
                TrainingLoad trainingLoad;
                Object object = trainingLoad;
                trainingLoad = new TrainingLoad(n, by, byArray);
                break;
            }
            case 5: {
                OxygenSaturation oxygenSaturation;
                Object object = oxygenSaturation;
                oxygenSaturation = new OxygenSaturation(n, by, byArray);
                break;
            }
            case 4: {
                PressureDetection pressureDetection;
                Object object = pressureDetection;
                pressureDetection = new PressureDetection(n, by, byArray);
                break;
            }
            case 3: {
                SportsSteps sportsSteps;
                Object object = sportsSteps;
                sportsSteps = new SportsSteps(n, by, byArray);
                break;
            }
            case 2: {
                Altitude altitude;
                Object object = altitude;
                altitude = new Altitude(n, by, byArray);
                break;
            }
            case 1: {
                AirPressure airPressure;
                Object object = airPressure;
                airPressure = new AirPressure(n, by, byArray);
                break;
            }
            case 0: {
                HeartRate heartRate;
                Object object = heartRate;
                heartRate = new HeartRate(n, by, byArray);
            }
        }
        return object;
    }

    private void a(BluetoothDevice bluetoothDevice, SportsInfoStatusSyncCmd object) {
        SportsInfoStatusSyncCmd.Param param = (SportsInfoStatusSyncCmd.Param)((CommandBase)object).getParam();
        SportsInfo sportsInfo = ((HealthDataParseHelper)object2).b.getDeviceInfo(bluetoothDevice).getSportsInfo();
        if (sportsInfo == null) {
            SportsInfo sportsInfo2;
            sportsInfo = sportsInfo2;
            sportsInfo2 = new SportsInfo();
            ((HealthDataParseHelper)object2).b.getDeviceInfo(bluetoothDevice).setSportsInfo(sportsInfo);
        }
        switch (param.getOp()) {
            default: {
                break;
            }
            case 5: {
                boolean bl = sportsInfo.getState() != 3;
                sportsInfo.setState(3);
                Object object2 = ((HealthDataParseHelper)object2).a;
                if (object2 == null || !bl) break;
                ((RcspEventListenerManager)object2).onSportsState(bluetoothDevice, sportsInfo.getState());
                break;
            }
            case 4: {
                boolean bl = sportsInfo.getState() != 2;
                sportsInfo.setState(2);
                Object object2 = ((HealthDataParseHelper)object2).a;
                if (object2 == null || !bl) break;
                ((RcspEventListenerManager)object2).onSportsState(bluetoothDevice, sportsInfo.getState());
                break;
            }
            case 3: {
                object = (SportsInfoStatusSyncCmd.FirmwareStopSportsParam)((CommandBase)object).getParam();
                if (object == null) {
                    return;
                }
                boolean bl = sportsInfo.getState() != 0;
                sportsInfo.setState(0).setEndTime(((SportsInfoStatusSyncCmd.FirmwareStopSportsParam)object).stopTime).setRecoveryTime(((SportsInfoStatusSyncCmd.FirmwareStopSportsParam)object).restoreTime).setRecordFileId(((SportsInfoStatusSyncCmd.FirmwareStopSportsParam)object).fileId).setRecordFileSize(((SportsInfoStatusSyncCmd.FirmwareStopSportsParam)object).fileSize).setExerciseIntensityState(super.a(((SportsInfoStatusSyncCmd.FirmwareStopSportsParam)object).strengthIntervalTimer));
                object = ((HealthDataParseHelper)object2).a;
                if (object == null) break;
                if (bl) {
                    ((RcspEventListenerManager)object).onSportsState(bluetoothDevice, sportsInfo.getState());
                }
                ((HealthDataParseHelper)object2).a.onSportInfoChange(bluetoothDevice, sportsInfo);
                break;
            }
            case 2: {
                object = (SportsInfoStatusSyncCmd.AppStopSportsResponse)((CommandBase)object).getResponse();
                if (object == null) {
                    return;
                }
                boolean bl = sportsInfo.getState() != 0;
                sportsInfo.setState(0).setEndTime(((SportsInfoStatusSyncCmd.AppStopSportsResponse)object).stopTime).setRecoveryTime(((SportsInfoStatusSyncCmd.AppStopSportsResponse)object).restoreTime).setRecordFileId(((SportsInfoStatusSyncCmd.AppStopSportsResponse)object).fileId).setRecordFileSize(((SportsInfoStatusSyncCmd.AppStopSportsResponse)object).fileSize).setExerciseIntensityState(super.a(((SportsInfoStatusSyncCmd.AppStopSportsResponse)object).strengthIntervalTimer));
                object = ((HealthDataParseHelper)object2).a;
                if (object == null) break;
                if (bl) {
                    ((RcspEventListenerManager)object).onSportsState(bluetoothDevice, sportsInfo.getState());
                }
                ((HealthDataParseHelper)object2).a.onSportInfoChange(bluetoothDevice, sportsInfo);
                break;
            }
            case 1: {
                object = (SportsInfoStatusSyncCmd.StartSportsParam)((CommandBase)object).getParam();
                if (object == null) {
                    return;
                }
                sportsInfo.setMode(((SportsInfoStatusSyncCmd.StartSportsParam)object).type).setState(1);
                Object object2 = ((HealthDataParseHelper)object2).a;
                if (object2 == null) break;
                ((RcspEventListenerManager)object2).onSportsState(bluetoothDevice, sportsInfo.getState());
                break;
            }
            case 0: {
                object = (SportsInfoStatusSyncCmd.ReadSportsInfoResponse)((CommandBase)object).getResponse();
                if (object == null) {
                    return;
                }
                sportsInfo.setId(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).id).setMode(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).type).setState(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).status).setNeedAppGPS(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).hasGps).setHeartRateMode(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).heartRateMode).setReadRealTimeDataInterval(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)object).readReadDataInterval);
                Object object2 = ((HealthDataParseHelper)object2).a;
                if (object2 == null) break;
                ((RcspEventListenerManager)object2).onSportInfoChange(bluetoothDevice, sportsInfo);
            }
        }
    }

    private int[] a(byte[] byArray) {
        if (byArray != null && byArray.length >= 20) {
            int n;
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            int n2 = 0;
            while ((n = n2 + 4) <= byArray.length) {
                arrayList2.add(CHexConver.bytesToInt(byArray, n2, 4));
                n2 = n;
            }
            int n3 = arrayList2.size();
            int[] nArray = new int[n3];
            for (n = 0; n < n3; ++n) {
                nArray[n] = (Integer)arrayList2.get(n);
            }
            return nArray;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveCmdFromDevice(BluetoothDevice bluetoothDevice, CommandBase object) {
        if (object == null || ((CommandBase)object).getStatus() != 0) return;
        int n = ((CommandBase)object).getId();
        if (n != 160) {
            if (n != 166) {
                if (n != 162) {
                    if (n != 163) return;
                    SensorLogCmd sensorLogCmd = (SensorLogCmd)object;
                    int n2 = ((SensorLogCmd.Param)sensorLogCmd.getParam()).type;
                    object = ((SensorLogCmd.Param)sensorLogCmd.getParam()).data;
                    ((HealthDataParseHelper)object2).a.onSensorLogDataChange(bluetoothDevice, n2, (byte[])object);
                    return;
                } else {
                    ReceiveHealthDataCmd.Param param = (ReceiveHealthDataCmd.Param)((CommandBase)(object = (ReceiveHealthDataCmd)object)).getParam();
                    byte by = param == null ? (byte)0 : param.version;
                    if (((HealthDataParseHelper)object2).c == null) {
                        RecombineHealthDataBuffer recombineHealthDataBuffer;
                        RecombineHealthDataBuffer recombineHealthDataBuffer2 = recombineHealthDataBuffer;
                        recombineHealthDataBuffer = new RecombineHealthDataBuffer(null);
                        ((HealthDataParseHelper)object2).c = recombineHealthDataBuffer2;
                    }
                    byte[] byArray = ((HealthDataParseHelper)object2).c.pushAndReturnResult(bluetoothDevice.getAddress(), (ReceiveHealthDataCmd)object);
                    object = byArray;
                    if (byArray == null || ((Object)object).length == 0) return;
                    super.a(bluetoothDevice, by, (byte[])object);
                }
                return;
            } else {
                ((HealthDataParseHelper)object2).a(bluetoothDevice, (SportsInfoStatusSyncCmd)object);
            }
            return;
        } else {
            RequestHealthDataCmd requestHealthDataCmd = (RequestHealthDataCmd)object;
            object = (RequestHealthDataCmd.Response)requestHealthDataCmd.getResponse();
            RequestHealthDataCmd.Param param = (RequestHealthDataCmd.Param)requestHealthDataCmd.getParam();
            byte by = param == null ? (byte)0 : param.version;
            if (object == null || ((RequestHealthDataCmd.Response)object).ret != 0 || ((RequestHealthDataCmd.Response)object).flag == 0) return;
            HealthDataParseHelper healthDataParseHelper = object2;
            Object object2 = ((RequestHealthDataCmd.Response)object).data;
            healthDataParseHelper.a(bluetoothDevice, by, (byte[])object2);
        }
    }

    public static class RecombineHealthDataBuffer {
        private final Map<String, List<ReceiveHealthDataCmd.Param>> a;

        private RecombineHealthDataBuffer() {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            v1.a = hashMap2;
        }

        public /* synthetic */ RecombineHealthDataBuffer(1 var1_1) {
            this();
        }

        public byte[] pushAndReturnResult(String string, ReceiveHealthDataCmd iterator) {
            iterator = (ReceiveHealthDataCmd.Param)((CommandBase)((Object)iterator)).getParam();
            ArrayList arrayList = this.a.get(string);
            if (arrayList == null) {
                ArrayList arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList();
                this.a.put(string, arrayList);
            } else if (((ReceiveHealthDataCmd.Param)((Object)iterator)).packageId == 0) {
                arrayList.clear();
            }
            arrayList.add(iterator);
            byte by = ((ReceiveHealthDataCmd.Param)((Object)iterator)).packageCount;
            if (((ReceiveHealthDataCmd.Param)((Object)iterator)).packageId + 1 == by) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(by * 512);
                int n = -1;
                for (ReceiveHealthDataCmd.Param param : arrayList) {
                    byteBuffer.put(param.data);
                    byte by2 = param.packageId;
                    if (by2 != n + 1) {
                        arrayList.clear();
                        JL_Log.w(RecombineHealthDataBuffer.class.getSimpleName(), "----------\u6570\u636e\u5f02\u5e38:packageId\u4e0d\u8fde\u7eed-----------");
                        return null;
                    }
                    n = by2;
                }
                byte[] byArray = new byte[byteBuffer.position()];
                byteBuffer.flip();
                byteBuffer.get(byArray);
                arrayList.clear();
                return byArray;
            }
            return null;
        }
    }
}

