/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.tool.callback;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;

public abstract class BaseCallbackManager<T> {
    private final ArrayList<T> a = new ArrayList();
    private final Handler b = new Handler(Looper.getMainLooper());

    public void registerCallback(T t) {
        if (t != null && !this.a.contains(t)) {
            this.a.add(t);
            return;
        }
    }

    public void unregisterCallback(T t) {
        if (t != null && !this.a.isEmpty()) {
            this.a.remove(t);
            return;
        }
    }

    public void release() {
        BaseCallbackManager baseCallbackManager = this;
        baseCallbackManager.a.clear();
        baseCallbackManager.b.removeCallbacksAndMessages(null);
    }

    public void callbackEvent(CallbackImpl<T> callbackImpl) {
        CallbackRunnable callbackRunnable;
        if (callbackImpl == null) {
            return;
        }
        CallbackRunnable callbackRunnable2 = callbackRunnable;
        callbackRunnable = new CallbackRunnable(callbackImpl);
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.b.post((Runnable)callbackRunnable2);
        } else {
            callbackRunnable2.run();
        }
    }

    public class CallbackRunnable
    implements Runnable {
        private final CallbackImpl<T> a;

        public CallbackRunnable(CallbackImpl<T> callbackImpl) {
            this.a = callbackImpl;
        }

        @Override
        public void run() {
            if (!BaseCallbackManager.this.a.isEmpty() && this.a != null) {
                for (Object e : new ArrayList(BaseCallbackManager.this.a)) {
                    this.a.onPost(e);
                }
            }
        }
    }

    public static interface CallbackImpl<T> {
        public void onPost(T var1);
    }
}

