/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.dfu.image;

import com.realsil.sdk.dfu.image.BaseBinInputStream;
import com.realsil.sdk.dfu.image.SubFileInfo;
import com.realsil.sdk.dfu.model.BinInfo;
import com.realsil.sdk.dfu.model.OtaDeviceInfo;
import java.util.List;

public class ImageValidateManager {
    public static final int ERR_NA = 0;
    public static final int ERR_PACK_LOSS = 16;
    public static final int ERR_PACK_LOSS_EMPTY = 17;
    public static final int ERR_PACK_DUPLICATE_BANK = 18;
    public static final int ERR_PACK_LOSS_OTA_HEADER = 19;
    public static final int ERR_PACK_LOSS_ROM_PATCH = 20;
    public static final int ERR_PACK_LOSS_APP_IMAGE = 21;
    public static final int ERR_PACK_LOW_VERSION = 22;
    public static final int ERR_PACK_NT = 32;
    public static final int ERR_PACK_NT_OTA_HEADER = 33;
    public static final int ERR_PACK_NT_BANK_SWITCH = 34;
    public static final int ERR_SINGLE_NT = 48;

    public static int check(OtaDeviceInfo object, BinInfo binInfo) {
        if (object != null && binInfo != null) {
            int n = ((OtaDeviceInfo)object).icType;
            if (n <= 3) {
                return 0;
            }
            if (n != 5 && n != 9) {
                if (n != 4 && n != 6 && n != 7 && n != 8) {
                    return 0;
                }
                return 0;
            }
            if (binInfo.isPackFile) {
                boolean bl = false;
                n = 0;
                List<SubFileInfo> list = binInfo.subFileInfos;
                if (list != null && list.size() > 0) {
                    for (SubFileInfo subFileInfo : list) {
                        if (subFileInfo.binId != 2048) continue;
                        if (subFileInfo.bitNumber < 16) {
                            bl |= true;
                            continue;
                        }
                        n |= 1;
                    }
                    int n2 = ((OtaDeviceInfo)object).updateBankIndicator;
                    if (n2 == 2) {
                        if ((n & 1) == 1) {
                            return 0;
                        }
                        if (bl & true) {
                            return 18;
                        }
                        return 34;
                    }
                    if (n2 == 1) {
                        if (bl & true) {
                            return 0;
                        }
                        if ((n & 1) == 1) {
                            return 18;
                        }
                        return 34;
                    }
                    if (!(bl & true) && (n & 1) != 1) {
                        return 0;
                    }
                    return 33;
                }
                return 17;
            }
            if (((OtaDeviceInfo)object).updateBankIndicator != 0) {
                return 48;
            }
            object = binInfo.mBinInputStreams;
            if (object != null && object.size() > 0) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (((BaseBinInputStream)object.next()).getBinId() != 2048) continue;
                    return 33;
                }
            }
            return 0;
        }
        return 0;
    }
}

