/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.dfu.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.realsil.sdk.core.bluetooth.BluetoothHelper;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.core.utility.DataConverter;
import com.realsil.sdk.dfu.model.CharacteristicInfo;
import com.realsil.sdk.dfu.model.ImageVersionInfo;
import com.realsil.sdk.dfu.utils.DfuUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class OtaDeviceInfo
implements Parcelable {
    public static final int AES_MODE_16_FIRST = 0;
    public static final int AES_MODE_16_N = 1;
    public static final int UPDATE_ONE_BY_ONE = 0;
    public static final int UPDATE_MULTI_AT_A_TIME = 1;
    public static final int BUD_ROLE_SECONDARY = 0;
    public static final int BUD_ROLE_PRIMARY = 1;
    public static final int RWS_FLAG_PREPARED = 0;
    public static final int RWS_FLAG_HANDOVER_PROCESSING = 1;
    public static final int RWS_MODE_SINGLE = 0;
    public static final int RWS_MODE_ENGAGE_IDLE = 1;
    public static final int UPDATE_INDICATOR_STANDALONE = 0;
    public static final int UPDATE_INDICATOR_BANK_0 = 1;
    public static final int UPDATE_INDICATOR_BANK_1 = 2;
    public static final int MECHANISM_ONE_BY_ONE = 1;
    public static final int MECHANISM_ALL_IN_ONE = 2;
    public static final int MECHANISM_ALL_IN_ONE_WITH_BUFFER = 3;
    public static final int MECHANISM_DEFAULT = 1;
    public static final int BANK_INDICATOR_0 = 0;
    public static final int BANK_INDICATOR_1 = 1;
    public static final int BANK_INDICATOR_F = 15;
    public static final Parcelable.Creator<OtaDeviceInfo> CREATOR = new Parcelable.Creator<OtaDeviceInfo>(){

        public OtaDeviceInfo createFromParcel(Parcel parcel) {
            return new OtaDeviceInfo(parcel);
        }

        public OtaDeviceInfo[] newArray(int n) {
            return new OtaDeviceInfo[n];
        }
    };
    public int protocolType;
    public boolean e;
    public int f;
    public int g;
    public int h;
    public int i;
    public boolean j;
    public int k;
    public int icType;
    public int otaVersion;
    public int secureVersion;
    public int appFreeBank;
    public int patchFreeBank;
    public int mode;
    public boolean l;
    public boolean m;
    public int n;
    public boolean o;
    public int p;
    public boolean q;
    public int r;
    public int s;
    public int t;
    public byte[] u;
    public int maxBufferchecksize;
    public int otaTempBufferSize;
    public byte[] v;
    public int w;
    public int x;
    public int y;
    public int appData0;
    public int appData1;
    public int appData2;
    public int appData3;
    public int imageVersionIndicator;
    public int updateBankIndicator;
    public int z;
    public boolean bankEnabled;
    public byte[] imageVersionValues;
    public List<ImageVersionInfo> A;
    public byte[] imageSectionSizeValues;
    public List<CharacteristicInfo> B;
    public int C;

    public OtaDeviceInfo() {
        this.icType = 3;
        this.otaVersion = 0;
        this.appFreeBank = 0;
        this.patchFreeBank = 0;
        this.mode = 2;
        this.n = 1;
        this.p = 0;
        this.r = 1;
        this.s = 0;
        this.t = 0;
        this.maxBufferchecksize = 256;
        this.otaTempBufferSize = 0;
        this.imageVersionIndicator = 0;
        this.updateBankIndicator = 0;
        this.z = 1;
    }

    public OtaDeviceInfo(int n) {
        this(0, n);
    }

    public OtaDeviceInfo(int n, int n2) {
        OtaDeviceInfo otaDeviceInfo = this;
        otaDeviceInfo.icType = 3;
        otaDeviceInfo.otaVersion = 0;
        otaDeviceInfo.appFreeBank = 0;
        otaDeviceInfo.patchFreeBank = 0;
        otaDeviceInfo.mode = 2;
        otaDeviceInfo.n = 1;
        otaDeviceInfo.p = 0;
        otaDeviceInfo.r = 1;
        otaDeviceInfo.s = 0;
        otaDeviceInfo.t = 0;
        otaDeviceInfo.maxBufferchecksize = 256;
        otaDeviceInfo.otaTempBufferSize = 0;
        otaDeviceInfo.imageVersionIndicator = 0;
        otaDeviceInfo.updateBankIndicator = 0;
        otaDeviceInfo.z = 1;
        otaDeviceInfo.protocolType = n;
        otaDeviceInfo.setMode(n2);
        otaDeviceInfo.setImageVersionValues(null);
    }

    public OtaDeviceInfo(Parcel parcel) {
        this.icType = 3;
        this.otaVersion = 0;
        this.appFreeBank = 0;
        this.patchFreeBank = 0;
        this.mode = 2;
        this.n = 1;
        this.p = 0;
        this.r = 1;
        this.s = 0;
        this.t = 0;
        this.maxBufferchecksize = 256;
        this.otaTempBufferSize = 0;
        this.imageVersionIndicator = 0;
        this.updateBankIndicator = 0;
        this.z = 1;
        this.protocolType = parcel.readInt();
        boolean bl = parcel.readByte() != 0;
        this.e = bl;
        this.f = parcel.readInt();
        this.g = parcel.readInt();
        this.h = parcel.readInt();
        this.i = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.j = bl;
        this.k = parcel.readInt();
        this.icType = parcel.readInt();
        this.otaVersion = parcel.readInt();
        this.secureVersion = parcel.readInt();
        this.appFreeBank = parcel.readInt();
        this.patchFreeBank = parcel.readInt();
        this.mode = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.l = bl;
        bl = parcel.readByte() != 0;
        this.m = bl;
        this.n = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.o = bl;
        this.p = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.q = bl;
        this.r = parcel.readInt();
        this.s = parcel.readInt();
        this.t = parcel.readInt();
        this.u = parcel.createByteArray();
        this.maxBufferchecksize = parcel.readInt();
        this.otaTempBufferSize = parcel.readInt();
        this.v = parcel.createByteArray();
        this.w = parcel.readInt();
        this.x = parcel.readInt();
        this.y = parcel.readInt();
        this.appData0 = parcel.readInt();
        this.appData1 = parcel.readInt();
        this.appData2 = parcel.readInt();
        this.appData3 = parcel.readInt();
        this.imageVersionIndicator = parcel.readInt();
        this.updateBankIndicator = parcel.readInt();
        this.z = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.bankEnabled = bl;
        this.imageVersionValues = parcel.createByteArray();
        this.A = parcel.createTypedArrayList(ImageVersionInfo.CREATOR);
        this.imageSectionSizeValues = parcel.createByteArray();
        this.B = parcel.createTypedArrayList(CharacteristicInfo.CREATOR);
        this.C = parcel.readInt();
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.protocolType);
        parcel.writeByte((byte)(this.e ? 1 : 0));
        parcel.writeInt(this.f);
        parcel.writeInt(this.g);
        parcel.writeInt(this.h);
        parcel.writeInt(this.i);
        parcel.writeByte((byte)(this.j ? 1 : 0));
        parcel.writeInt(this.k);
        parcel.writeInt(this.icType);
        parcel.writeInt(this.otaVersion);
        parcel.writeInt(this.secureVersion);
        parcel.writeInt(this.appFreeBank);
        parcel.writeInt(this.patchFreeBank);
        parcel.writeInt(this.mode);
        parcel.writeByte((byte)(this.l ? 1 : 0));
        parcel.writeByte((byte)(this.m ? 1 : 0));
        parcel.writeInt(this.n);
        parcel.writeByte((byte)(this.o ? 1 : 0));
        parcel.writeInt(this.p);
        parcel.writeByte((byte)(this.q ? 1 : 0));
        parcel.writeInt(this.r);
        parcel.writeInt(this.s);
        parcel.writeInt(this.t);
        parcel.writeByteArray(this.u);
        parcel.writeInt(this.maxBufferchecksize);
        parcel.writeInt(this.otaTempBufferSize);
        parcel.writeByteArray(this.v);
        parcel.writeInt(this.w);
        parcel.writeInt(this.x);
        parcel.writeInt(this.y);
        parcel.writeInt(this.appData0);
        parcel.writeInt(this.appData1);
        parcel.writeInt(this.appData2);
        parcel.writeInt(this.appData3);
        parcel.writeInt(this.imageVersionIndicator);
        parcel.writeInt(this.updateBankIndicator);
        parcel.writeInt(this.z);
        parcel.writeByte((byte)(this.bankEnabled ? 1 : 0));
        parcel.writeByteArray(this.imageVersionValues);
        parcel.writeTypedList(this.A);
        parcel.writeByteArray(this.imageSectionSizeValues);
        parcel.writeTypedList(this.B);
        parcel.writeInt(this.C);
    }

    public int describeContents() {
        return 0;
    }

    public void parseX0000(byte[] byArray) {
        this.parseX0000(byArray, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void parseX0000(byte[] var1_1, int var2_3) {
        block60: {
            block64: {
                block61: {
                    block62: {
                        block63: {
                            if (var1_1 == null) {
                                return;
                            }
                            v0 = ByteBuffer.wrap((byte[])var1_1);
                            var1_1 = v0;
                            v0.order(ByteOrder.LITTLE_ENDIAN);
                            var3_4 = v0.remaining();
                            if (var3_4 <= var2_3) {
                                return;
                            }
                            if ((var3_4 -= var2_3) > 1) ** GOTO lbl35
                            v1 = this;
                            v2 = v1;
                            v3 = v1;
                            v4 = var1_1;
                            v5 = var2_3;
                            v6 = this;
                            v7 = this;
                            v7.icType = 3;
                            v7.otaVersion = 0;
                            v8 = var1_1.get(var2_3);
                            v6.appFreeBank = (byte)(v8 & 15);
                            var1_2 = (byte)((v4.get(v5) & 240) >> 4);
                            v2.patchFreeBank = var1_2;
                            if (v3.appFreeBank != 15 || var1_2 != 15) ** GOTO lbl31
                            this.bankEnabled = false;
                            break block63;
lbl31:
                            // 1 sources

                            this.bankEnabled = true;
                        }
                        this.setMode(2);
                        break block60;
lbl35:
                        // 1 sources

                        v9 = var1_1;
                        v10 = var2_3;
                        v11 = this;
                        v12 = var1_1.get(var2_3);
                        v11.icType = v12 & 255;
                        var4_5 = v9.get(v10 + 1) & 15;
                        this.otaVersion = var4_5;
                        if (var4_5 != 0) break block61;
                        if (var3_4 < 3) ** GOTO lbl55
                        var4_5 = var2_3 + 2;
                        v13 = var1_1.get(var4_5);
                        this.appFreeBank = (byte)(v13 & 15);
                        v14 = var1_1.get(var4_5);
                        this.patchFreeBank = (byte)((v14 & 240) >> 4);
lbl55:
                        // 2 sources

                        this.otaTempBufferSize = 0;
                        if (var3_4 < 4) break block62;
                        this.setMode(var1_1.get(var2_3 + 3));
                    }
                    if (var3_4 >= 6) {
                        v15 = var1_1.get(var2_3 + 5);
                        v16 = v15 << 8 | var1_1.get(4);
                        this.maxBufferchecksize = v16;
                    }
                    if (var3_4 < 14) ** GOTO lbl92
                    v17 = var1_1.get(var2_3 + 7);
                    v18 = v17 << 8 | var1_1.get(var2_3 + 6);
                    this.appData0 = v18;
                    v19 = var1_1.get(var2_3 + 9);
                    v20 = v19 << 8 | var1_1.get(var2_3 + 8);
                    this.appData1 = v20;
                    v21 = var1_1.get(var2_3 + 11);
                    v22 = v21 << 8 | var1_1.get(var2_3 + 10);
                    this.appData2 = v22;
                    v23 = var1_1.get(var2_3 + 13);
                    v24 = v23 << 8 | var1_1.get(var2_3 + 12);
                    this.appData3 = v24;
lbl92:
                    // 2 sources

                    v25 = this;
                    v25.b();
                    if (v25.appFreeBank != 15) ** GOTO lbl102
                    if (this.patchFreeBank != 15) ** GOTO lbl102
                    v26 = this;
                    v26.bankEnabled = false;
                    v26.updateBankIndicator = 0;
                    break block60;
lbl102:
                    // 2 sources

                    this.bankEnabled = true;
                    if (this.appFreeBank == 1) ** GOTO lbl109
                    if (this.patchFreeBank == 1) ** GOTO lbl109
                    this.updateBankIndicator = 1;
                    break block60;
lbl109:
                    // 2 sources

                    this.updateBankIndicator = 2;
                }
                if (var4_5 != 1) break block64;
                if (var3_4 >= 3) {
                    v27 = var1_1.get(var2_3 + 2);
                    this.secureVersion = v27 & 255;
                }
                if (var3_4 >= 4) {
                    this.setMode(var1_1.get(var2_3 + 3));
                }
                if (var3_4 >= 5) {
                    v28 = var1_1.getShort(var2_3 + 4);
                    this.maxBufferchecksize = v28 & 65535;
                }
                if (var3_4 >= 7) {
                    v29 = var1_1.get(var2_3 + 6);
                    this.otaTempBufferSize = v29 & 255;
                }
                if (var3_4 < 12) ** GOTO lbl134
                this.imageVersionIndicator = var1_1.getInt(var2_3 + 8);
lbl134:
                // 2 sources

                v30 = this;
                v30.b();
                if (v30.imageVersionIndicator != 0) ** GOTO lbl140
                this.bankEnabled = false;
                break block60;
lbl140:
                // 1 sources

                this.bankEnabled = true;
            }
            if (var4_5 != 2) break block60;
            if (var3_4 >= 3) {
                v31 = var1_1.get(var2_3 + 2);
                this.secureVersion = v31 & 255;
            }
            if (var3_4 >= 4) {
                this.setMode(var1_1.get(var2_3 + 3));
            }
            if (var3_4 >= 5) {
                v32 = var1_1.getShort(var2_3 + 4);
                this.maxBufferchecksize = v32 & 65535;
            }
            if (var3_4 >= 7) {
                this.C = var1_1.getShort(var2_3 + 6);
            }
            if (var3_4 < 8) ** GOTO lbl165
            v33 = var1_1.getShort(var2_3 + 7);
            this.w = v33 & 65535;
lbl165:
            // 2 sources

            v34 = this;
            v34.b();
            if (v34.imageVersionIndicator != 0) ** GOTO lbl171
            try {
                this.bankEnabled = false;
                break block60;
lbl171:
                // 1 sources

                this.bankEnabled = true;
            }
            catch (Exception v35) {
                ZLogger.e((String)v35.toString());
            }
        }
    }

    public void parseX0010(byte[] byArray) {
        this.parseX0010(byArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseX0010(byte[] object, int n) {
        if (object == null) {
            return;
        }
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        int n2 = ((Buffer)object).remaining();
        if (n2 <= n) {
            return;
        }
        n2 -= n;
        try {
            this.icType = ((ByteBuffer)object).get(n) & 0xFF;
            this.otaVersion = (byte)(((ByteBuffer)object).get(n + 1) & 0xF);
            if (n2 >= 3) {
                this.secureVersion = ((ByteBuffer)object).get(n + 2) & 0xFF;
            }
            if (n2 >= 4) {
                this.mode = ((ByteBuffer)object).get(n + 3) & 0xFF;
                boolean bl = (this.mode & 1) != 0;
                this.l = bl;
                bl = (this.mode & 2) >> 1 != 0;
                OtaDeviceInfo otaDeviceInfo = this;
                otaDeviceInfo.m = bl;
                otaDeviceInfo.n = (otaDeviceInfo.mode & 4) >> 2;
                bl = (otaDeviceInfo.mode & 8) >> 3 != 0;
                OtaDeviceInfo otaDeviceInfo2 = this;
                otaDeviceInfo2.o = bl;
                otaDeviceInfo2.p = (otaDeviceInfo2.mode & 0x10) >> 4;
                bl = (otaDeviceInfo2.mode & 0x20) >> 5 != 0;
                OtaDeviceInfo otaDeviceInfo3 = this;
                otaDeviceInfo3.q = bl;
                otaDeviceInfo3.r = (otaDeviceInfo3.mode & 0x40) >> 6;
                otaDeviceInfo3.s = (otaDeviceInfo3.mode & 0x80) >> 7;
            }
            if (n2 >= 5) {
                this.t = ((ByteBuffer)object).get(n + 4) & 0xFF & 1;
            }
            if (n2 >= 7) {
                this.otaTempBufferSize = ((ByteBuffer)object).get(n + 6) & 0xFF;
            }
            if (n2 >= 12) {
                this.imageVersionIndicator = ((ByteBuffer)object).getInt(n + 8);
            }
            this.z = this.p == 1 ? (this.otaTempBufferSize != 0 ? 3 : 2) : 1;
            if (this.imageVersionIndicator == 0) {
                this.bankEnabled = false;
                return;
            }
            this.bankEnabled = true;
            return;
        }
        catch (Exception exception) {
            ZLogger.e((String)exception.toString());
        }
    }

    public void parseX0011(byte[] byArray) {
        this.parseX0011(byArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseX0011(byte[] object, int n) {
        if (object == null) {
            return;
        }
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        int n2 = ((Buffer)object).remaining();
        if (n2 <= n) {
            return;
        }
        n2 -= n;
        try {
            this.icType = ((ByteBuffer)object).get(n) & 0xFF;
            this.otaVersion = (byte)(((ByteBuffer)object).get(n + 1) & 0xF);
            if (n2 >= 3) {
                this.secureVersion = ((ByteBuffer)object).get(n + 2);
            }
            if (n2 >= 4) {
                this.mode = ((ByteBuffer)object).get(n + 3) & 0xFF;
                boolean bl = (this.mode & 1) != 0;
                this.l = bl;
                bl = (this.mode & 2) >> 1 != 0;
                OtaDeviceInfo otaDeviceInfo = this;
                otaDeviceInfo.m = bl;
                otaDeviceInfo.n = (otaDeviceInfo.mode & 4) >> 2;
                bl = (otaDeviceInfo.mode & 8) >> 3 != 0;
                OtaDeviceInfo otaDeviceInfo2 = this;
                otaDeviceInfo2.o = bl;
                otaDeviceInfo2.p = (otaDeviceInfo2.mode & 0x10) >> 4;
                bl = (otaDeviceInfo2.mode & 0x20) >> 5 != 0;
                this.q = bl;
                this.r = (this.mode & 0x40) >> 6;
            }
            if (n2 >= 5) {
                this.t = ((ByteBuffer)object).get(n + 4) & 0xFF & 1;
            }
            if (n2 >= 7) {
                this.otaTempBufferSize = ((ByteBuffer)object).get(n + 6) & 0xFF;
            }
            if (n2 >= 12) {
                this.imageVersionIndicator = ((ByteBuffer)object).getInt(n + 8);
            }
            this.z = this.p == 1 ? (this.otaTempBufferSize != 0 ? 3 : 2) : 1;
            this.bankEnabled = this.imageVersionIndicator != 0;
        }
        catch (Exception exception) {
            ZLogger.e((String)exception.toString());
        }
        ZLogger.v((String)this.toString());
    }

    public void setMode(int n) {
        this.mode = n;
        boolean bl = (n & 1) != 0;
        this.l = bl;
        bl = (n & 2) >> 1 != 0;
        this.m = bl;
        this.n = (n & 4) >> 2;
        bl = (n & 8) >> 3 != 0;
        this.o = bl;
        this.p = (n & 0x10) >> 4;
        n = (n & 0x20) >> 5 != 0 ? 1 : 0;
        this.q = n;
        this.b();
    }

    public void setPnpId(byte[] byArray) {
        if (byArray != null && byArray.length >= 7) {
            this.e = true;
            this.f = byArray[0];
            this.g = byArray[2] << 8 | byArray[1];
            this.h = byArray[4] << 8 | byArray[3];
            this.i = byArray[6] << 8 | byArray[5];
        } else {
            OtaDeviceInfo otaDeviceInfo = this;
            otaDeviceInfo.e = false;
            otaDeviceInfo.f = 0;
            otaDeviceInfo.g = 0;
            otaDeviceInfo.h = 0;
            otaDeviceInfo.i = 0;
        }
    }

    public void setImageVersionValues(byte[] byArray) {
        this.imageVersionValues = byArray;
        this.a();
    }

    public void appendImageVersionBytes(byte[] byArray) {
        byte[] byArray2 = this.imageVersionValues;
        if (this.imageVersionValues != null && byArray2.length > 0) {
            byArray = new byte[byArray2.length + byArray.length];
            int n = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n);
            n = this.imageVersionValues.length;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray, n, n2);
            this.imageVersionValues = byArray;
        } else {
            this.imageVersionValues = byArray;
        }
        this.a();
    }

    public List<ImageVersionInfo> getImageVersionInfos() {
        return this.A;
    }

    public List<ImageVersionInfo> getExistImageVersionInfos() {
        ArrayList<ImageVersionInfo> arrayList;
        ArrayList<ImageVersionInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ImageVersionInfo>();
        List<ImageVersionInfo> object2 = ((OtaDeviceInfo)this).A;
        if (object2 != null && object2.size() > 0) {
            for (ImageVersionInfo imageVersionInfo : ((OtaDeviceInfo)this).A) {
                if (imageVersionInfo.getIndication() == 0) continue;
                arrayList2.add(imageVersionInfo);
            }
        }
        return arrayList2;
    }

    public void setImageSectionSizeValues(byte[] byArray) {
        this.imageSectionSizeValues = byArray;
        this.a();
    }

    public void appendImageSectionSizeBytes(byte[] byArray) {
        byte[] byArray2 = this.imageSectionSizeValues;
        if (this.imageSectionSizeValues != null && byArray2.length > 0) {
            byArray = new byte[byArray2.length + byArray.length];
            int n = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n);
            n = this.imageSectionSizeValues.length;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray, n, n2);
            this.imageSectionSizeValues = byArray;
        } else {
            this.imageSectionSizeValues = byArray;
        }
        this.a();
    }

    public boolean isBufferCheckEnabled() {
        return this.l;
    }

    public boolean isCopyImageEnabled() {
        return this.o;
    }

    public int getUpdateImageFlag() {
        return this.p;
    }

    public boolean isRwsEnabled() {
        return this.q;
    }

    public int getBudRole() {
        return this.r;
    }

    public int getRwsUpdateFlag() {
        return this.s;
    }

    public void setRwsUpdateFlag(int n) {
        this.s = n;
    }

    public int getRwsMode() {
        return this.t;
    }

    public void setRwsMode(int n) {
        this.t = n;
    }

    public byte[] getRwsBdAddr() {
        return this.u;
    }

    public void setRwsBdAddr(byte[] byArray) {
        this.u = byArray;
    }

    public boolean isAesEncryptEnabled() {
        return this.m;
    }

    public int getAesEncryptMode() {
        return this.n;
    }

    public byte[] getDeviceMac() {
        return this.v;
    }

    public void setDeviceMac(byte[] byArray) {
        this.v = byArray;
    }

    public void setAppVersion(int n) {
        this.x = n;
    }

    public void setPatchVersion(int n) {
        this.w = n;
    }

    public int getPatchExtensionVersion() {
        return this.y;
    }

    public void setPatchExtensionVersion(int n) {
        this.y = n;
    }

    public List<CharacteristicInfo> getDebugCharacteristicInfos() {
        return this.B;
    }

    public void appendDebugCharacteristicInfo(int n, byte[] byArray) {
        if (this.B == null) {
            ArrayList<CharacteristicInfo> arrayList;
            ArrayList<CharacteristicInfo> arrayList2 = arrayList;
            arrayList = new ArrayList<CharacteristicInfo>();
            this.B = arrayList2;
        }
        this.B.add(new CharacteristicInfo(n, byArray));
    }

    public int getUpdateMechanism() {
        return this.z;
    }

    public void setUpdateMechanism(int n) {
        this.z = n;
    }

    public boolean isBasSupported() {
        return this.j;
    }

    public int getBatteryLevel() {
        return this.k;
    }

    public void setBatteryLevel(int n) {
        OtaDeviceInfo otaDeviceInfo = this;
        otaDeviceInfo.j = true;
        otaDeviceInfo.k = n;
    }

    public boolean isDisSupported() {
        return this.e;
    }

    public int getVendorIdSource() {
        return this.f;
    }

    public void setVendorIdSource(int n) {
        this.f = n;
    }

    public int getVendorId() {
        return this.g;
    }

    public void setVendorId(int n) {
        this.g = n;
    }

    public int getProductId() {
        return this.h;
    }

    public void setProductId(int n) {
        this.h = n;
    }

    public int getProductVersion() {
        return this.i;
    }

    public void setProductVersion(int n) {
        this.i = n;
    }

    public int getNoTempImageId() {
        return this.C;
    }

    public void setNoTempImageId(int n) {
        this.C = n;
    }

    public int getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(int n) {
        this.protocolType = n;
    }

    public String getIpv() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.icType;
        objectArray2[1] = this.protocolType;
        objectArray[2] = this.otaVersion;
        return String.format("0x%02X-0x%04X-V%02X", objectArray2);
    }

    public int getAppVersion() {
        int n;
        block4: {
            block3: {
                n = 0;
                int n2 = this.protocolType;
                if (n2 == 16 || n2 == 17) break block3;
                n2 = this.otaVersion;
                if (n2 == 0) {
                    return this.x;
                }
                if (n2 < 1) break block4;
                for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                    int n3 = this.icType;
                    if (!(n3 <= 3 ? imageVersionInfo.getBitNumber() == 1 || imageVersionInfo.getBitNumber() == 2 : (n3 != 5 && n3 != 9 ? !(n3 != 4 && n3 != 6 && n3 != 7 && n3 != 8 || imageVersionInfo.getBitNumber() != 5 && imageVersionInfo.getBitNumber() != 21) : imageVersionInfo.getBitNumber() == 5 || imageVersionInfo.getBitNumber() == 21))) continue;
                    return imageVersionInfo.getVersion();
                }
                break block4;
            }
            for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                int n4 = this.icType;
                if (!(n4 <= 3 ? imageVersionInfo.getBitNumber() == 1 || imageVersionInfo.getBitNumber() == 2 : (n4 != 5 && n4 != 9 ? !(n4 != 4 && n4 != 6 && n4 != 7 && n4 != 8 || imageVersionInfo.getBitNumber() != 5 && imageVersionInfo.getBitNumber() != 21) : imageVersionInfo.getBitNumber() == 5 || imageVersionInfo.getBitNumber() == 21))) continue;
                return imageVersionInfo.getVersion();
            }
        }
        return n;
    }

    public int getPatchVersion() {
        int n = 0;
        int n2 = this.protocolType;
        if (n2 != 16 && n2 != 17) {
            n2 = this.otaVersion;
            if (n2 == 0) {
                return this.w;
            }
            if (n2 == 1) {
                for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                    int n3 = this.icType;
                    if (!(n3 <= 3 ? imageVersionInfo.getBitNumber() == 0 || imageVersionInfo.getBitNumber() == 16 : (n3 != 5 && n3 != 9 ? !(n3 != 4 && n3 != 6 && n3 != 7 && n3 != 8 || imageVersionInfo.getBitNumber() != 4 && imageVersionInfo.getBitNumber() != 20) : imageVersionInfo.getBitNumber() == 4 || imageVersionInfo.getBitNumber() == 20))) continue;
                    return imageVersionInfo.getVersion();
                }
            } else if (n2 == 2) {
                return this.w;
            }
        } else {
            for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                int n4 = this.icType;
                if (!(n4 <= 3 ? imageVersionInfo.getBitNumber() == 0 || imageVersionInfo.getBitNumber() == 16 : (n4 != 5 && n4 != 9 ? !(n4 != 4 && n4 != 6 && n4 != 7 && n4 != 8 || imageVersionInfo.getBitNumber() != 4 && imageVersionInfo.getBitNumber() != 20) : imageVersionInfo.getBitNumber() == 4 || imageVersionInfo.getBitNumber() == 20))) continue;
                return imageVersionInfo.getVersion();
            }
        }
        return n;
    }

    public int getAppUiParameterVersion() {
        int n = 0;
        int n2 = this.protocolType;
        if (n2 != 16 && n2 != 17) {
            n2 = this.otaVersion;
            if (n2 == 0) {
                return this.w;
            }
            if (n2 == 1) {
                for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                    int n3 = this.icType;
                    if (!(n3 <= 3 ? imageVersionInfo.getBitNumber() == 0 || imageVersionInfo.getBitNumber() == 16 : (n3 != 5 && n3 != 9 ? !(n3 != 4 && n3 != 6 && n3 != 7 && n3 != 8 || imageVersionInfo.getBitNumber() != 4 && imageVersionInfo.getBitNumber() != 20) : imageVersionInfo.getBitNumber() == 4 || imageVersionInfo.getBitNumber() == 20))) continue;
                    return imageVersionInfo.getVersion();
                }
            } else if (n2 == 2) {
                return this.w;
            }
        } else {
            for (ImageVersionInfo imageVersionInfo : this.getExistImageVersionInfos()) {
                int n4 = this.icType;
                if (!(n4 <= 3 ? imageVersionInfo.getBitNumber() == 0 || imageVersionInfo.getBitNumber() == 16 : (n4 != 5 && n4 != 9 ? !(n4 != 4 && n4 != 6 && n4 != 7 && n4 != 8 || imageVersionInfo.getBitNumber() != 4 && imageVersionInfo.getBitNumber() != 20) : imageVersionInfo.getBitNumber() == 4 || imageVersionInfo.getBitNumber() == 20))) continue;
                return imageVersionInfo.getVersion();
            }
        }
        return n;
    }

    public String toString() {
        Object[] objectArray;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("DeviceInfo:\n");
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = ((OtaDeviceInfo)this).getIpv();
        stringBuilder2.append(String.format("IPV=%s\n", objectArray3));
        boolean bl = ((OtaDeviceInfo)this).e;
        if (bl) {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("PnP_ID:\n");
            Object[] objectArray4 = new Object[2];
            Object[] objectArray5 = objectArray4;
            objectArray5[0] = ((OtaDeviceInfo)this).f;
            objectArray4[1] = ((OtaDeviceInfo)this).g;
            stringBuilder3.append(String.format(Locale.US, "\tvendorIdSource=0x%04X(%d)\n", objectArray5));
            Object[] objectArray6 = new Object[2];
            Object[] bl2 = objectArray6;
            bl2[0] = ((OtaDeviceInfo)this).g;
            objectArray6[1] = ((OtaDeviceInfo)this).g;
            stringBuilder3.append(String.format(Locale.US, "\tvendorId=0x%04X(%d)\n", bl2));
            Object[] objectArray7 = new Object[2];
            Object[] objectArray11 = objectArray7;
            objectArray11[0] = ((OtaDeviceInfo)this).h;
            objectArray7[1] = ((OtaDeviceInfo)this).h;
            stringBuilder3.append(String.format(Locale.US, "\tproductId=0x%04X(%d)\n", objectArray11));
            Object[] objectArray8 = new Object[2];
            Object[] objectArray14 = objectArray8;
            objectArray14[0] = ((OtaDeviceInfo)this).i;
            objectArray8[1] = ((OtaDeviceInfo)this).i;
            stringBuilder3.append(String.format(Locale.US, "\tproductVersion=0x%04X(%d)\n", objectArray14));
        } else {
            Object[] objectArray9 = new Object[1];
            objectArray = objectArray9;
            objectArray9[0] = bl;
            stringBuilder2.append(String.format("DIS=%b\n", objectArray));
        }
        boolean n = ((OtaDeviceInfo)this).j;
        if (n) {
            Object[] objectArray10 = new Object[2];
            Object[] objectArray27 = objectArray10;
            objectArray27[0] = ((OtaDeviceInfo)this).k;
            objectArray10[1] = ((OtaDeviceInfo)this).k;
            stringBuilder2.append(String.format(Locale.US, "batteryLevel=0x%02X(%d)\n", objectArray27));
        } else {
            Object[] objectArray11 = new Object[1];
            objectArray = objectArray11;
            objectArray11[0] = n;
            stringBuilder2.append(String.format("BAS=%b\n", objectArray));
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        Object[] objectArray12 = new Object[1];
        Object[] objectArray37 = objectArray12;
        objectArray12[0] = BluetoothHelper.formatAddressPositive((byte[])((OtaDeviceInfo)this).v);
        stringBuilder4.append(String.format("deviceMac: %s\n", objectArray37));
        Object[] objectArray13 = new Object[1];
        Object[] objectArray41 = objectArray13;
        objectArray13[0] = ((OtaDeviceInfo)this).mode;
        stringBuilder4.append(String.format("mode=0x%02X\n", objectArray41));
        Object[] objectArray14 = new Object[1];
        Object[] object2 = objectArray14;
        objectArray14[0] = ((OtaDeviceInfo)this).l;
        stringBuilder4.append(String.format("\tbufferCheckEnabled=%b\n", object2));
        if (((OtaDeviceInfo)this).l) {
            Object[] objectArray15 = new Object[2];
            Object[] objectArray16 = objectArray15;
            objectArray16[0] = ((OtaDeviceInfo)this).maxBufferchecksize;
            objectArray15[1] = ((OtaDeviceInfo)this).maxBufferchecksize;
            stringBuilder2.append(String.format(Locale.US, "\t\tmaxBufferchecksize=0x%04X(%d)\n", objectArray16));
        }
        StringBuilder stringBuilder5 = stringBuilder2;
        Object[] objectArray17 = new Object[1];
        Object[] objectArray18 = objectArray17;
        objectArray17[0] = ((OtaDeviceInfo)this).m;
        stringBuilder5.append(String.format("\taesEncryptEnabled=%b\n", objectArray18));
        Object[] objectArray19 = new Object[1];
        Object[] objectArray20 = objectArray19;
        objectArray19[0] = ((OtaDeviceInfo)this).n;
        stringBuilder5.append(String.format("\taesEncryptMode=0x%02X\n", objectArray20));
        Object[] objectArray21 = new Object[1];
        Object[] objectArray22 = objectArray21;
        objectArray21[0] = ((OtaDeviceInfo)this).o;
        stringBuilder5.append(String.format("\tcopyImageEnabled=%b\n", objectArray22));
        Object[] objectArray23 = new Object[1];
        Object[] objectArray24 = objectArray23;
        objectArray23[0] = ((OtaDeviceInfo)this).p;
        stringBuilder5.append(String.format("\tupdateImageFlag=0x%02X\n", objectArray24));
        Object[] objectArray25 = new Object[3];
        Object[] objectArray26 = objectArray25;
        objectArray26[0] = ((OtaDeviceInfo)this).q;
        objectArray26[1] = ((OtaDeviceInfo)this).t;
        objectArray25[2] = ((OtaDeviceInfo)this).r;
        stringBuilder5.append(String.format("\trwsEnabled=%b, rwsMode=0x%02X, budRole: 0x%02X\n", objectArray26));
        if (((OtaDeviceInfo)this).q) {
            Object[] objectArray27 = new Object[2];
            Object[] objectArray28 = objectArray27;
            objectArray28[0] = ((OtaDeviceInfo)this).s;
            objectArray27[1] = BluetoothHelper.formatAddressPositive((byte[])((OtaDeviceInfo)this).u);
            stringBuilder2.append(String.format("\t\trwsUpdateFlag:0x%02X, rwsBdAddr: %s\n", objectArray28));
        }
        StringBuilder stringBuilder6 = stringBuilder2;
        Object[] objectArray29 = new Object[2];
        Object[] objectArray30 = objectArray29;
        objectArray30[0] = ((OtaDeviceInfo)this).otaTempBufferSize;
        objectArray29[1] = ((OtaDeviceInfo)this).otaTempBufferSize;
        stringBuilder6.append(String.format(Locale.US, "otaTempBufferSize=0x%02X(%d)\n", objectArray30));
        Object[] objectArray31 = new Object[1];
        Object[] objectArray32 = objectArray31;
        objectArray31[0] = ((OtaDeviceInfo)this).z;
        stringBuilder6.append(String.format("mUpdateMechanism=0x%02X\n", objectArray32));
        if (((OtaDeviceInfo)this).protocolType == 0) {
            int n2 = ((OtaDeviceInfo)this).otaVersion;
            if (n2 == 0) {
                StringBuilder stringBuilder7 = stringBuilder2;
                Object[] objectArray33 = new Object[1];
                Object[] objectArray34 = objectArray33;
                objectArray33[0] = ((OtaDeviceInfo)this).w;
                stringBuilder7.append(String.format(Locale.US, "\tpatchVersion=0x%04X\n", objectArray34));
                Object[] objectArray35 = new Object[1];
                Object[] objectArray36 = objectArray35;
                objectArray35[0] = ((OtaDeviceInfo)this).patchFreeBank;
                stringBuilder7.append(String.format(Locale.US, "\tpatchFreeBank=0x%02X\n", objectArray36));
                Object[] objectArray38 = new Object[1];
                Object[] objectArray39 = objectArray38;
                objectArray38[0] = ((OtaDeviceInfo)this).x;
                stringBuilder7.append(String.format(Locale.US, "\tappVersion=0x%04X\n", objectArray39));
                Object[] objectArray40 = new Object[1];
                Object[] objectArray42 = objectArray40;
                objectArray40[0] = ((OtaDeviceInfo)this).appFreeBank;
                stringBuilder7.append(String.format("\tappFreeBank=0x%02X\n", objectArray42));
                Object[] objectArray43 = new Object[1];
                Object[] objectArray44 = objectArray43;
                objectArray43[0] = ((OtaDeviceInfo)this).y;
                stringBuilder7.append(String.format(Locale.US, "\tpatchExtensionVersion=%d\n", objectArray44));
                if (((OtaDeviceInfo)this).icType > 3) {
                    StringBuilder stringBuilder8 = stringBuilder2;
                    Object[] objectArray45 = new Object[1];
                    Object[] objectArray46 = objectArray45;
                    objectArray45[0] = ((OtaDeviceInfo)this).appData0;
                    stringBuilder8.append(String.format(Locale.US, "\tappData0=%d\n", objectArray46));
                    Object[] objectArray47 = new Object[1];
                    Object[] objectArray48 = objectArray47;
                    objectArray47[0] = ((OtaDeviceInfo)this).appData1;
                    stringBuilder8.append(String.format(Locale.US, "\tappData1=%d\n", objectArray48));
                    Object[] objectArray49 = new Object[1];
                    Object[] objectArray50 = objectArray49;
                    objectArray49[0] = ((OtaDeviceInfo)this).appData2;
                    stringBuilder8.append(String.format(Locale.US, "\tappData2=%d\n", objectArray50));
                    Object[] objectArray51 = new Object[1];
                    Object[] objectArray52 = objectArray51;
                    objectArray51[0] = ((OtaDeviceInfo)this).appData3;
                    stringBuilder8.append(String.format(Locale.US, "\tappData3=%d\n", objectArray52));
                }
            } else if (n2 == 1) {
                StringBuilder stringBuilder9 = stringBuilder2;
                Object[] objectArray53 = new Object[2];
                Object[] objectArray54 = objectArray53;
                objectArray54[0] = ((OtaDeviceInfo)this).secureVersion;
                objectArray53[1] = ((OtaDeviceInfo)this).secureVersion;
                stringBuilder9.append(String.format(Locale.US, "\tsecureVersion=0x%04X(%d)\n", objectArray54));
                Object[] objectArray55 = new Object[1];
                Object[] objectArray56 = objectArray55;
                objectArray55[0] = ((OtaDeviceInfo)this).imageVersionIndicator;
                stringBuilder9.append(String.format(Locale.US, "\timageVersionIndicator=0x%08X\n", objectArray56));
                Object[] objectArray57 = new Object[1];
                Object[] objectArray58 = objectArray57;
                objectArray57[0] = ((OtaDeviceInfo)this).updateBankIndicator;
                stringBuilder9.append(String.format(Locale.US, "\tupdateBankIndicator=0x%02X\n", objectArray58));
            } else if (n2 == 2) {
                StringBuilder stringBuilder10 = stringBuilder2;
                Object[] objectArray59 = new Object[1];
                Object[] objectArray60 = objectArray59;
                objectArray59[0] = ((OtaDeviceInfo)this).C;
                stringBuilder10.append(String.format(Locale.US, "\tnoTempImageId=0x%04X\n", objectArray60));
                Object[] objectArray61 = new Object[1];
                Object[] objectArray62 = objectArray61;
                objectArray61[0] = ((OtaDeviceInfo)this).w;
                stringBuilder10.append(String.format(Locale.US, "\tpatchVersion=0x%04X\n", objectArray62));
            }
        } else {
            StringBuilder stringBuilder11 = stringBuilder2;
            Object[] objectArray63 = new Object[2];
            Object[] objectArray64 = objectArray63;
            objectArray64[0] = ((OtaDeviceInfo)this).secureVersion;
            objectArray63[1] = ((OtaDeviceInfo)this).secureVersion;
            stringBuilder11.append(String.format(Locale.US, "\tsecureVersion=0x%04X(%d)\n", objectArray64));
            Object[] objectArray65 = new Object[1];
            Object[] objectArray66 = objectArray65;
            objectArray65[0] = ((OtaDeviceInfo)this).imageVersionIndicator;
            stringBuilder11.append(String.format(Locale.US, "\timageVersionIndicator=0x%08X\n", objectArray66));
            Object[] objectArray67 = new Object[2];
            Object[] objectArray68 = objectArray67;
            objectArray68[0] = ((OtaDeviceInfo)this).updateBankIndicator;
            objectArray67[1] = ((OtaDeviceInfo)this).updateBankIndicator;
            stringBuilder11.append(String.format(Locale.US, "\tupdateBankIndicator=0x%02X(%d)\n", objectArray68));
        }
        Object[] objectArray69 = new Object[1];
        Object[] objectArray70 = objectArray69;
        objectArray69[0] = ((OtaDeviceInfo)this).bankEnabled;
        stringBuilder2.append(String.format("bankEnabled=%b\n", objectArray70));
        List<CharacteristicInfo> list = ((OtaDeviceInfo)this).B;
        if (list != null && list.size() > 0) {
            for (CharacteristicInfo characteristicInfo : ((OtaDeviceInfo)this).B) {
                Object[] objectArray71 = new Object[2];
                objectArray = objectArray71;
                objectArray[0] = characteristicInfo.key;
                objectArray71[1] = DfuUtils.formatLinkKey(characteristicInfo.value);
                stringBuilder2.append(String.format(Locale.US, "\t0x%04X: (%s)\n", objectArray));
            }
        }
        return stringBuilder2.toString();
    }

    public final void b() {
        int n = this.otaVersion;
        this.z = n == 0 ? (this.p == 1 ? 2 : 1) : (n == 1 ? (this.p == 1 ? (this.otaTempBufferSize != 0 ? 3 : 2) : 1) : (n == 2 ? 1 : (this.p == 1 ? (this.otaTempBufferSize != 0 ? 3 : 2) : 1)));
    }

    public final void a() {
        ArrayList arrayList;
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = this.imageVersionIndicator;
        object[1] = DataConverter.bytes2Hex((byte[])this.imageVersionValues);
        objectArray[2] = DataConverter.bytes2Hex((byte[])this.imageSectionSizeValues);
        ZLogger.v((String)String.format("imageVersionIndicator = 0x%08x, \nimageVersionValues = %s\nimageSectionSizeValues=%s", (Object[])object));
        this.updateBankIndicator = 0;
        object = arrayList;
        arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            ImageVersionInfo imageVersionInfo;
            int n3;
            int n4;
            int n5 = this.imageVersionIndicator >> i * 2 & 3;
            if (n5 == 0) {
                ImageVersionInfo imageVersionInfo2;
                ImageVersionInfo imageVersionInfo3 = imageVersionInfo2;
                ZLogger.v((boolean)false, (String)new ImageVersionInfo(i, n5, 0, 0).toString());
                object.add(imageVersionInfo3);
                continue;
            }
            if (n5 == 1) {
                if (this.updateBankIndicator == 0) {
                    this.updateBankIndicator = 2;
                }
            } else if (n5 == 2) {
                this.updateBankIndicator = 1;
            }
            int n6 = 0;
            byte[] byArray = this.imageVersionValues;
            if (this.imageVersionValues != null && (n4 = n + 3) < byArray.length) {
                n6 = byArray[n4] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
                n += 4;
            } else {
                ZLogger.d((boolean)false, (String)("imageVersion loss, offset=" + n));
            }
            int n7 = 0;
            Object object2 = this.imageSectionSizeValues;
            if (this.imageSectionSizeValues != null && (n3 = n2 + 3) < ((byte[])object2).length) {
                n7 = object2[n3] << 24 & 0xFF000000 | object2[n2 + 2] << 16 & 0xFF0000 | object2[n2 + 1] << 8 & 0xFF00 | object2[n2] & 0xFF;
                n2 += 4;
            } else {
                ZLogger.d((boolean)false, (String)("sectionsize loss, offset=" + n2));
            }
            object2 = imageVersionInfo;
            imageVersionInfo = new ImageVersionInfo(i, n5, n6, n7);
            ZLogger.v((boolean)false, (String)imageVersionInfo.toString());
            object.add(object2);
        }
        this.A = object;
        boolean bl = this.updateBankIndicator != 0;
        this.bankEnabled = bl;
    }
}

