/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.dfu.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.dfu.image.BinIndicator;
import com.realsil.sdk.dfu.image.SubFileInfo;
import com.realsil.sdk.dfu.model.BinInfo;
import com.realsil.sdk.dfu.model.DfuProgressInfo;
import com.realsil.sdk.dfu.model.FileTypeInfo;
import com.realsil.sdk.dfu.model.OtaDeviceInfo;
import com.realsil.sdk.dfu.model.OtaModeInfo;
import com.realsil.sdk.dfu.model.Throughput;
import com.realsil.sdk.dfu.o.a;
import com.realsil.sdk.dfu.utils.ConnectParams;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDfuAdapter {
    public static final int STATE_INIT = 256;
    public static final int STATE_INIT_BINDING_SERVICE = 257;
    public static final int STATE_INIT_OK = 258;
    public static final int STATE_PREPARING = 512;
    public static final int STATE_HID_CONNECTING = 513;
    public static final int STATE_HID_PENDING_REMOVE_BOND = 514;
    public static final int STATE_HID_PENDING_CREATE_BOND = 515;
    public static final int STATE_CONNECTING = 516;
    public static final int STATE_PROCESS_PAIRING_REQUEST = 517;
    public static final int STATE_PENDDING_DISCOVERY_SERVICE = 518;
    public static final int STATE_DISCOVERY_SERVICE = 519;
    public static final int STATE_READ_DEVICE_INFO = 520;
    public static final int STATE_READ_PROTOCOL_TYPE = 521;
    public static final int STATE_READ_IMAGE_INFO = 522;
    public static final int STATE_READ_BATTERY_INFO = 523;
    public static final int STATE_PREPARED = 1024;
    public static final int STATE_OTA_PROCESSING = 1025;
    public static final int STATE_OTA_IDLE = 1026;
    public static final int STATE_DISCONNECTING = 2048;
    public static final int STATE_DISCONNECTED = 2049;
    public static final int STATE_CONNECT_FAILED = 2050;
    public static final int STATE_PENDING_ABORT = 4096;
    public static final int STATE_ABORTED = 4097;
    public boolean e = true;
    public Context f;
    public a g = null;
    public ConnectParams h;
    public int i = 2;
    public DfuHelperCallback j;
    public Object k;
    public int l;
    public Handler m;
    public Runnable n;

    public BaseDfuAdapter() {
        Runnable runnable;
        Handler handler;
        Object object;
        Object object2 = object;
        object = new Object();
        this.k = object2;
        this.l = 256;
        object2 = handler;
        handler = new Handler();
        this.m = object2;
        object2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                BaseDfuAdapter.this.b();
            }
        };
        this.n = object2;
    }

    public static List<FileTypeInfo> getSupportedFileContents(BinInfo binInfo) {
        ArrayList<FileTypeInfo> arrayList;
        ArrayList<FileTypeInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<FileTypeInfo>();
        List<SubFileInfo> list = binInfo != null ? binInfo.supportSubFileInfos : null;
        if (list != null && list.size() > 0) {
            for (SubFileInfo subFileInfo : list) {
                int n;
                int n2 = binInfo.icType;
                if (n2 <= 3) {
                    FileTypeInfo fileTypeInfo;
                    FileTypeInfo fileTypeInfo2 = fileTypeInfo;
                    n = subFileInfo.bitNumber;
                    fileTypeInfo = new FileTypeInfo(n, BinIndicator.parseBitNumber(n2, n));
                    arrayList2.add(fileTypeInfo2);
                    continue;
                }
                SubFileInfo subFileInfo2 = subFileInfo;
                n = subFileInfo2.bitNumber;
                arrayList2.add(new FileTypeInfo(n, BinIndicator.parseSubBinId(n2, subFileInfo2.binId)));
            }
        }
        return arrayList2;
    }

    public boolean initialize() {
        return true;
    }

    public boolean connectDevice(ConnectParams connectParams) {
        if (this.g == null) {
            BaseDfuAdapter baseDfuAdapter = this;
            ZLogger.w((boolean)baseDfuAdapter.e, (String)"dfu has not been initialized");
            baseDfuAdapter.initialize();
            return false;
        }
        if (connectParams == null) {
            ZLogger.w((String)"ConnectParams can not be null");
            return false;
        }
        this.h = connectParams;
        this.i = connectParams.getReconnectTimes();
        ZLogger.v((String)("mConnectParams:" + this.h.toString()));
        return true;
    }

    public boolean b() {
        if (this.g == null) {
            BaseDfuAdapter baseDfuAdapter = this;
            ZLogger.w((boolean)baseDfuAdapter.e, (String)"dfu has not been initialized");
            baseDfuAdapter.initialize();
        }
        if (this.h == null) {
            ZLogger.d((String)"mConnectParams == null");
            this.a(2050);
            return false;
        }
        ZLogger.v((String)("retry to connect device, reconnectTimes =" + this.i));
        return true;
    }

    public void disconnect() {
        baseDfuAdapter.h = null;
        baseDfuAdapter.i = 0;
        BaseDfuAdapter baseDfuAdapter = baseDfuAdapter.m;
        if (baseDfuAdapter != null) {
            baseDfuAdapter.removeCallbacks(null);
        }
    }

    public boolean abort() {
        return true;
    }

    public int getState() {
        return this.l;
    }

    public List<OtaModeInfo> getSupportedModes() {
        return new ArrayList<OtaModeInfo>();
    }

    public OtaModeInfo getPriorityWorkMode(int n) {
        if ((this = ((BaseDfuAdapter)this).getSupportedModes()) != null && this.size() > 0) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                OtaModeInfo otaModeInfo = (OtaModeInfo)iterator.next();
                if (otaModeInfo.getWorkmode() != n) continue;
                return otaModeInfo;
            }
            return (OtaModeInfo)this.get(0);
        }
        return new OtaModeInfo(0);
    }

    public OtaModeInfo getPriorityWorkMode() {
        return this.getPriorityWorkMode(16);
    }

    public boolean isPreparing() {
        return (this.l &= 0x200) == 512;
    }

    public boolean isInitalized() {
        return this.l >= 258;
    }

    public void setDfuHelperCallback(DfuHelperCallback dfuHelperCallback) {
        this.j = dfuHelperCallback;
    }

    public void addDfuHelperCallback(DfuHelperCallback dfuHelperCallback) {
        this.j = dfuHelperCallback;
    }

    public void removeDfuHelperCallback(DfuHelperCallback dfuHelperCallback) {
        this.j = null;
    }

    public void a(int n) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BaseDfuAdapter)((Object)dfuHelperCallback)).l;
        objectArray[1] = n;
        ZLogger.v((String)String.format("notifyStateChanged 0x%04X >> 0x%04X", objectArray2));
        ((BaseDfuAdapter)((Object)dfuHelperCallback)).l = n;
        DfuHelperCallback dfuHelperCallback = ((BaseDfuAdapter)((Object)dfuHelperCallback)).j;
        if (dfuHelperCallback != null) {
            dfuHelperCallback.onStateChanged(n);
        } else {
            ZLogger.v((String)"no callback registed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void a() {
        Object object = this.k;
        BaseDfuAdapter baseDfuAdapter = this;
        // MONITORENTER : object
        try {
            baseDfuAdapter.k.notifyAll();
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ZLogger.e((String)exception.toString());
            }
        }
    }

    public boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static abstract class DfuHelperCallback {
        public void onStateChanged(int n) {
        }

        public void onTargetInfoChanged(OtaDeviceInfo otaDeviceInfo) {
        }

        public void onError(int n, int n2) {
        }

        public void onProcessStateChanged(int n, Throughput throughput) {
        }

        public void onProgressChanged(DfuProgressInfo dfuProgressInfo) {
        }
    }

    public static class InnerHandler2
    extends Handler {
        public WeakReference<IInnerHandler> a;

        public InnerHandler2(IInnerHandler iInnerHandler) {
            WeakReference<IInnerHandler> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<IInnerHandler>(iInnerHandler);
            v1.a = object;
        }

        public void handleMessage(Message message) {
            InnerHandler2 innerHandler2 = iInnerHandler;
            super.handleMessage(message);
            IInnerHandler iInnerHandler = (IInnerHandler)innerHandler2.a.get();
            if (iInnerHandler != null) {
                iInnerHandler.handleMessage(message);
            } else {
                ZLogger.d((String)"mWeakReference is null");
            }
        }
    }

    public static class InnerHandler
    extends Handler {
        public IInnerHandler a;

        public InnerHandler(IInnerHandler iInnerHandler) {
            this.a = iInnerHandler;
        }

        public void handleMessage(Message message) {
            InnerHandler innerHandler = iInnerHandler;
            super.handleMessage(message);
            IInnerHandler iInnerHandler = innerHandler.a;
            if (iInnerHandler != null) {
                iInnerHandler.handleMessage(message);
            } else {
                ZLogger.d((String)"mIInnerHandler is null");
            }
        }
    }

    public static interface IInnerHandler {
        public void handleMessage(Message var1);
    }
}

