/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.realsil.sdk.core.RtkConfigure;
import com.realsil.sdk.core.bluetooth.GlobalGatt;
import com.realsil.sdk.core.bluetooth.channel.SppChannelImpl;
import com.realsil.sdk.core.logger.WriteLog;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.core.utility.DependenceManager;
import com.realsil.sdk.core.utility.DialogUtils;
import java.util.Arrays;
import java.util.Locale;

public class RtkCore {
    public static Context a;
    public static boolean DEBUG = false;

    public static synchronized void initialize(Context object, RtkConfigure rtkConfigure) {
        StringBuilder stringBuilder;
        if (a == null) {
            a = object.getApplicationContext();
        }
        if (rtkConfigure == null) {
            rtkConfigure = new RtkConfigure.Builder().build();
        }
        RtkConfigure rtkConfigure2 = rtkConfigure;
        Log.d((String)"Realtek", (String)rtkConfigure2.toString());
        DEBUG = rtkConfigure2.isDebugEnabled();
        ZLogger.GLOBAL_LOG_LEVEL = rtkConfigure2.getGlobalLogLevel();
        ZLogger.initialize(rtkConfigure2.getLogTag(), rtkConfigure.isPrintLog());
        if (WriteLog.getInstance() == null) {
            WriteLog.install((Context)object);
        }
        DialogUtils.initialize(a);
        if (GlobalGatt.getInstance() == null) {
            GlobalGatt.initial(a);
        }
        if (SppChannelImpl.getInstance() == null) {
            SppChannelImpl.initialize();
        }
        DependenceManager.getInstance().register(new DependenceManager.DependenceLib("com.realsil.sdk", "rtk-core", "1.1.7"));
        object = stringBuilder;
        new StringBuilder().append("SDK_INT: " + Build.VERSION.SDK_INT);
        ((StringBuilder)object).append("\nDevice name: " + Build.DEVICE);
        ((StringBuilder)object).append("\nAndroid Version: " + Build.VERSION.RELEASE);
        ((StringBuilder)object).append("\nManufacture: " + Build.MANUFACTURER);
        ((StringBuilder)object).append("\nModel: " + Build.MODEL);
        if (Build.VERSION.SDK_INT >= 21) {
            ((StringBuilder)object).append("\nsupportedABIS: " + Arrays.toString(Build.SUPPORTED_ABIS));
        } else {
            ((StringBuilder)object).append("\ncupABI: " + Build.CPU_ABI);
        }
        ZLogger.d(((StringBuilder)object).toString());
    }

    public static synchronized void init(Context context) {
        RtkCore.initialize(context, new RtkConfigure.Builder().build());
    }

    public static synchronized void init(Context context, boolean bl, boolean bl2) {
        RtkCore.initialize(context, new RtkConfigure.Builder().build());
    }

    public static synchronized void initialize(Context context, boolean bl) {
        RtkCore.initialize(context, new RtkConfigure.Builder().debugEnabled(bl).build());
    }

    public static synchronized void initialize(Context context) {
        RtkCore.initialize(context, new RtkConfigure.Builder().build());
    }

    public static boolean isBluetoothSupported() {
        return GlobalGatt.getInstance().isBluetoothSupported();
    }

    public static String getVersion() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "1.1.7";
        objectArray[1] = 86;
        return String.format(Locale.US, "%s (%d)", objectArray2);
    }
}

