/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.base;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.IBinder;
import android.view.Display;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.realsil.sdk.core.logger.ZLogger;

public abstract class BaseService
extends Service {
    @Keep
    public Context mContext;
    public DisplayManager a;
    @Keep
    public int notificationId = 1230;
    public IBinder b;
    public final DisplayManager.DisplayListener c;

    public BaseService() {
        DisplayManager.DisplayListener displayListener;
        DisplayManager.DisplayListener displayListener2 = displayListener;
        displayListener = new DisplayManager.DisplayListener(this){

            public void onDisplayAdded(int n) {
            }

            public void onDisplayRemoved(int n) {
            }

            public void onDisplayChanged(int n) {
            }
        };
        this.c = displayListener2;
    }

    public String getChannelId() {
        return "rtk_channel_id";
    }

    public String getChannelName() {
        return "rtk_channel_name";
    }

    public void onCreate() {
        DisplayManager displayManager;
        BaseService baseService = object;
        super.onCreate();
        baseService.mContext = baseService;
        object.a = displayManager = (DisplayManager)baseService.getSystemService("display");
        if (displayManager != null) {
            displayManager.registerDisplayListener(object.c, null);
        }
        NotificationManager cfr_ignored_0 = (NotificationManager)object.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            BaseService baseService2 = object;
            Object object = baseService2.getChannelId();
            baseService2.a((String)object, baseService2.getChannelName());
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        return 1;
    }

    public IBinder onBind(Intent intent) {
        ZLogger.v("in onBind()");
        return this.b;
    }

    public void onRebind(Intent intent) {
        ZLogger.v("in onRebind()");
        super.onRebind(intent);
    }

    public boolean onUnbind(Intent intent) {
        ZLogger.w("Last client unbound from service");
        return true;
    }

    public void onDestroy() {
        BaseService baseService = this;
        super.onDestroy();
        DisplayManager displayManager = baseService.a;
        if (displayManager != null) {
            displayManager.unregisterDisplayListener(this.c);
        }
        this.stopForeground(true);
    }

    public boolean isScreenOn() {
        DisplayManager displayManager = displayManager.a;
        if (displayManager == null) {
            return false;
        }
        if ((displayManager = displayManager.getDisplays()) == null) {
            return false;
        }
        for (Display display : displayManager) {
            if (Build.VERSION.SDK_INT < 20 || display.getState() != 2) continue;
            return true;
        }
        return false;
    }

    public boolean isServiceRunningInForeground(Context object) {
        for (ActivityManager.RunningServiceInfo runningServiceInfo : ((ActivityManager)object.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!((Object)((Object)this)).getClass().getName().equals(runningServiceInfo.service.getClassName()) || !runningServiceInfo.foreground) continue;
            return true;
        }
        return false;
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(int n) {
        this.notificationId = n;
    }

    public Notification getNotification(String string, String string2) {
        BaseService baseService = this;
        string = new NotificationCompat.Builder((Context)baseService, baseService.getChannelId()).setContentText((CharSequence)string2).setContentTitle((CharSequence)string).setOngoing(true).setPriority(1).setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 26) {
            string.setChannelId(this.getChannelId());
        }
        return string.build();
    }

    public Notification buildNotification(Context context) {
        BaseService baseService;
        int n = Build.VERSION.SDK_INT;
        if (n >= 16) {
            Notification.Builder builder;
            if (n >= 26) {
                Notification.Builder builder2;
                builder = builder2;
                BaseService baseService2 = baseService;
                baseService = baseService2.getApplicationContext();
                builder2 = new Notification.Builder((Context)baseService, baseService2.getChannelId());
            } else {
                Notification.Builder builder3;
                builder = builder3;
                builder3 = new Notification.Builder(baseService.getApplicationContext());
            }
            Notification.Builder builder4 = builder;
            builder4.setContentText((CharSequence)"GuardService").setWhen(System.currentTimeMillis());
            baseService = builder4.build();
        } else {
            Notification notification;
            baseService = notification;
            notification = new Notification();
        }
        return baseService;
    }

    public void showNotification(String string, String string2, ComponentName componentName) {
        Intent intent;
        BaseService baseService = baseService2;
        BaseService baseService2 = intent;
        new Intent().setComponent(componentName);
        baseService2 = PendingIntent.getActivity((Context)baseService, (int)0, (Intent)baseService2, (int)0);
        baseService.showNotification(string, string2, (PendingIntent)baseService2, -1, -1);
    }

    public void showNotification(String string, String string2, PendingIntent pendingIntent, int n, int n2) {
        int n3 = Build.VERSION.SDK_INT;
        if (n3 >= 16) {
            Notification.Builder builder;
            if (n3 >= 26) {
                Notification.Builder builder2;
                builder = builder2;
                BaseService baseService = this;
                Context context = baseService.getApplicationContext();
                builder2 = new Notification.Builder(context, baseService.getChannelId());
            } else {
                Notification.Builder builder3;
                builder = builder3;
                builder3 = new Notification.Builder(this.getApplicationContext());
            }
            if (pendingIntent != null) {
                builder.setContentIntent(pendingIntent);
            }
            if (n != -1) {
                builder.setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)n));
            }
            if (n2 != -1) {
                builder.setSmallIcon(n2);
            }
            Notification.Builder builder4 = builder;
            builder4.setContentTitle((CharSequence)string).setContentText((CharSequence)string2).setWhen(System.currentTimeMillis());
            string = builder4.build();
        } else {
            Notification notification;
            string = notification;
            notification = new Notification();
        }
        if (string != null) {
            BaseService baseService = this;
            ((Notification)string).flags = 34;
            baseService.startForeground(baseService.getNotificationId(), (Notification)string);
        }
    }

    @RequiresApi(value=26)
    public final String a(String string, String string2) {
        NotificationChannel notificationChannel;
        BaseService baseService = baseService2;
        BaseService baseService2 = notificationChannel;
        new NotificationChannel(string, (CharSequence)string2, 0).setLightColor(-16776961);
        baseService2.setLockscreenVisibility(0);
        string2 = (NotificationManager)baseService.getSystemService("notification");
        if (string2 != null) {
            string2.createNotificationChannel((NotificationChannel)baseService2);
        }
        return string;
    }
}

