/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.realsil.sdk.core.bluetooth.impl.BluetoothDeviceImpl;
import com.realsil.sdk.core.bluetooth.impl.BluetoothGattImpl;
import com.realsil.sdk.core.logger.ZLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BluetoothHelper {
    public static final int BD_ADDR_LEN = 6;
    public static final int BD_UUID_LEN = 16;

    public static void enableBle() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null) {
            bluetoothAdapter.enable();
        }
    }

    public static boolean isBleEnabled() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        return bluetoothAdapter != null && bluetoothAdapter.isEnabled();
    }

    public static boolean isBleSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static String parseDeviceType(int n) {
        return BluetoothDeviceImpl.parseDeviceType(n);
    }

    public static List<String> parseProperty(int n) {
        return BluetoothGattImpl.parseProperty(n);
    }

    public static String parseProperty2(int n) {
        return BluetoothGattImpl.parseProperty2(n);
    }

    public static String getCharPermission(int n) {
        return BluetoothGattImpl.getCharPermission(n);
    }

    public static String getCharPropertie(int n) {
        return BluetoothGattImpl.getCharPropertie(n);
    }

    public static String getDescPermission(int n) {
        return BluetoothGattImpl.getDescPermission(n);
    }

    public static String convertMac(byte[] byArray) {
        if (byArray != null && byArray.length >= 5) {
            String string = (byArray[5] & 0xFF) <= 15 ? "0" + Integer.toHexString(byArray[5] & 0xFF).toUpperCase() + ":" : Integer.toHexString(byArray[5] & 0xFF).toUpperCase() + ":";
            string = (byArray[4] & 0xFF) <= 15 ? string + "0" + Integer.toHexString(byArray[4] & 0xFF).toUpperCase() + ":" : string + Integer.toHexString(byArray[4] & 0xFF).toUpperCase() + ":";
            string = (byArray[3] & 0xFF) <= 15 ? string + "0" + Integer.toHexString(byArray[3] & 0xFF).toUpperCase() + ":" : string + Integer.toHexString(byArray[3] & 0xFF).toUpperCase() + ":";
            string = (byArray[2] & 0xFF) <= 15 ? string + "0" + Integer.toHexString(byArray[2] & 0xFF).toUpperCase() + ":" : string + Integer.toHexString(byArray[2] & 0xFF).toUpperCase() + ":";
            string = (byArray[1] & 0xFF) <= 15 ? string + "0" + Integer.toHexString(byArray[1] & 0xFF).toUpperCase() + ":" : string + Integer.toHexString(byArray[1] & 0xFF).toUpperCase() + ":";
            return (byArray[0] & 0xFF) <= 15 ? string + "0" + Integer.toHexString(byArray[0] & 0xFF).toUpperCase() : string + Integer.toHexString(byArray[0] & 0xFF).toUpperCase();
        }
        return null;
    }

    public static String formatAddressNegatitive(byte[] byArray) {
        if (byArray != null && byArray.length >= 6) {
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = byArray[5];
            objectArray2[1] = byArray[4];
            objectArray2[2] = byArray[3];
            objectArray2[3] = byArray[2];
            objectArray2[4] = byArray[1];
            objectArray[5] = byArray[0];
            return String.format("%02X:%02X:%02X:%02X:%02X:%02X", objectArray2);
        }
        return null;
    }

    public static String formatAddressPositive(byte[] byArray) {
        if (byArray != null && byArray.length >= 6) {
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = byArray[0];
            objectArray2[1] = byArray[1];
            objectArray2[2] = byArray[2];
            objectArray2[3] = byArray[3];
            objectArray2[4] = byArray[4];
            objectArray[5] = byArray[5];
            return String.format("%02X:%02X:%02X:%02X:%02X:%02X", objectArray2);
        }
        return null;
    }

    public static byte[] convertAddress(String string) {
        byte[] byArray = new byte[6];
        if (string != null) {
            byArray[0] = (byte)(Character.digit(string.charAt(15), 16) * 16 + Character.digit(string.charAt(16), 16));
            byArray[1] = (byte)(Character.digit(string.charAt(12), 16) * 16 + Character.digit(string.charAt(13), 16));
            byArray[2] = (byte)(Character.digit(string.charAt(9), 16) * 16 + Character.digit(string.charAt(10), 16));
            byArray[3] = (byte)(Character.digit(string.charAt(6), 16) * 16 + Character.digit(string.charAt(7), 16));
            byArray[4] = (byte)(Character.digit(string.charAt(3), 16) * 16 + Character.digit(string.charAt(4), 16));
            byArray[5] = (byte)(Character.digit(string.charAt(0), 16) * 16 + Character.digit(string.charAt(1), 16));
        } else {
            byte[] byArray2 = byArray;
            byte[] byArray3 = byArray;
            byArray2[0] = 0;
            byArray3[1] = 0;
            byArray2[2] = 0;
            byArray3[3] = 0;
            byArray2[4] = 0;
            byArray3[5] = 0;
        }
        return byArray;
    }

    public static String parseProfile(int n) {
        switch (n) {
            default: {
                return "Unknown";
            }
            case 17: {
                return "PBAP_CLIENT";
            }
            case 16: {
                return "HEADSET_CLIENT";
            }
            case 12: {
                return "AVRCP_CONTROLLER";
            }
            case 11: {
                return "A2DP_SINK";
            }
            case 10: {
                return "SAP";
            }
            case 9: {
                return "MAP";
            }
            case 8: {
                return "GATT_SERVER";
            }
            case 7: {
                return "GATT";
            }
            case 6: {
                return "PBAP";
            }
            case 5: {
                return "PAN";
            }
            case 4: {
                return "HID_HOST";
            }
            case 3: {
                return "HEALTH";
            }
            case 2: {
                return "A2DP";
            }
            case 1: 
        }
        return "HEADSET";
    }

    public static String parseProfileState(int n) {
        switch (n) {
            default: {
                return "UNKNOWN (" + n + ")";
            }
            case 3: {
                return "3-BluetoothProfile.STATE_DISCONNECTING";
            }
            case 2: {
                return "2-BluetoothProfile.STATE_CONNECTED";
            }
            case 1: {
                return "1-BluetoothProfile.STATE_CONNECTING";
            }
            case 0: 
        }
        return "0-BluetoothProfile.STATE_DISCONNECTED";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<BluetoothDevice> getBondedBluetoothDevices() {
        Iterator iterator;
        ArrayList<BluetoothDevice> arrayList;
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        try {
            iterator = BluetoothAdapter.getDefaultAdapter().getBondedDevices().iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (!iterator.hasNext()) return arrayList2;
            BluetoothDevice bluetoothDevice = (BluetoothDevice)iterator.next();
            if (!BluetoothDeviceImpl.isConnected(bluetoothDevice)) continue;
            ZLogger.v("connected:" + bluetoothDevice.getName() + ", addr=" + bluetoothDevice.getAddress());
            arrayList2.add(bluetoothDevice);
        }
        return arrayList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<BluetoothDevice> getConnectedBluetoothDevices() {
        ArrayList<BluetoothDevice> arrayList;
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        Object object = BluetoothAdapter.getDefaultAdapter();
        Method method = BluetoothAdapter.class.getDeclaredMethod("getConnectionState", null);
        BluetoothAdapter bluetoothAdapter = object;
        method.setAccessible(true);
        if ((Integer)method.invoke((Object)bluetoothAdapter, null) != 2) return arrayList2;
        try {
            object = object.getBondedDevices().iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (!object.hasNext()) return arrayList2;
            BluetoothDevice bluetoothDevice = (BluetoothDevice)object.next();
            if (!BluetoothDeviceImpl.isConnected(bluetoothDevice)) continue;
            ZLogger.v("connected:" + bluetoothDevice.getName() + ", addr=" + bluetoothDevice.getAddress());
            arrayList2.add(bluetoothDevice);
        }
        return arrayList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<BluetoothDevice> getConnectedBluetoothDevices(int n) {
        Iterator iterator;
        ArrayList<BluetoothDevice> arrayList;
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter.getProfileConnectionState(n) != 2) return arrayList2;
        try {
            iterator = bluetoothAdapter.getBondedDevices().iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (!iterator.hasNext()) return arrayList2;
            bluetoothAdapter = (BluetoothDevice)iterator.next();
            if (!BluetoothDeviceImpl.isConnected((BluetoothDevice)bluetoothAdapter)) continue;
            ZLogger.v("connected:" + bluetoothAdapter.getName() + ", addr=" + bluetoothAdapter.getAddress());
            arrayList2.add((BluetoothDevice)bluetoothAdapter);
        }
        return arrayList2;
    }

    public static String getBluetoothAddress(Context object, BluetoothAdapter bluetoothAdapter) {
        String string = null;
        if (bluetoothAdapter != null) {
            Class<?> clazz = Class.forName("android.bluetooth.IBluetooth");
            object = bluetoothAdapter.getClass().getDeclaredField("mService");
            ((Field)object).setAccessible(true);
            Method method = clazz.getMethod("getAddress", new Class[0]);
            try {
                method.setAccessible(true);
                string = (String)method.invoke(((Field)object).get(bluetoothAdapter), new Object[0]);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        } else if (object != null) {
            string = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"bluetooth_address");
        }
        return string;
    }
}

