/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.BluetoothHelper;
import com.realsil.sdk.core.bluetooth.BluetoothProfileCallback;
import com.realsil.sdk.core.bluetooth.impl.BluetoothA2dpImpl;
import com.realsil.sdk.core.bluetooth.impl.BluetoothHeadsetImpl;
import com.realsil.sdk.core.bluetooth.impl.BluetoothProfileImpl;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class BluetoothProfileManager {
    public static BluetoothProfileManager n;
    public static final int INDICATOR_FULL = 255;
    public static final int INDICATOR_A2DP = 1;
    public static final int INDICATOR_A2DP_SINK = 2;
    public static final int INDICATOR_HEADSET = 4;
    public static final int INDICATOR_HID = 8;
    public static final int INDICATOR_AVRCP = 16;
    public boolean a = false;
    public Context b;
    public List<BluetoothProfileCallback> c;
    public BluetoothManager d;
    public BluetoothAdapter e;
    public BluetoothHeadset f = null;
    public BluetoothA2dp g = null;
    public BluetoothHealth h;
    public BluetoothProfile i = null;
    public BluetoothProfile j = null;
    public BluetoothProfile k = null;
    public ProfileBroadcastReceiver l = null;
    public BluetoothProfile.ServiceListener m = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
            int n2 = n;
            String string = BluetoothHelper.parseProfile(n2);
            ZLogger.d(string + " profile connected");
            if (n2 != 11) {
                if (n != 12) {
                    switch (n) {
                        default: {
                            break;
                        }
                        case 4: {
                            BluetoothProfileManager.a(BluetoothProfileManager.this, bluetoothProfile);
                            break;
                        }
                        case 3: {
                            BluetoothProfileManager.a(BluetoothProfileManager.this, (BluetoothHealth)bluetoothProfile);
                            break;
                        }
                        case 2: {
                            BluetoothProfileManager.a(BluetoothProfileManager.this, (BluetoothA2dp)bluetoothProfile);
                            break;
                        }
                        case 1: {
                            BluetoothProfileManager.a(BluetoothProfileManager.this, (BluetoothHeadset)bluetoothProfile);
                            break;
                        }
                    }
                } else {
                    BluetoothProfileManager.c(BluetoothProfileManager.this, bluetoothProfile);
                }
            } else {
                BluetoothProfileManager.b(BluetoothProfileManager.this, bluetoothProfile);
            }
        }

        public void onServiceDisconnected(int n) {
            int n2 = n;
            String string = BluetoothHelper.parseProfile(n2);
            ZLogger.d(string + " profile disconnected");
            if (n2 == 1) {
                BluetoothProfileManager.a(BluetoothProfileManager.this, null);
            } else if (n == 2) {
                BluetoothProfileManager.a(BluetoothProfileManager.this, null);
            } else if (n == 3) {
                BluetoothProfileManager.a(BluetoothProfileManager.this, null);
            } else if (n == 4) {
                BluetoothProfileManager.a(BluetoothProfileManager.this, null);
            } else if (n == 11) {
                BluetoothProfileManager.b(BluetoothProfileManager.this, null);
            } else if (n == 12) {
                BluetoothProfileManager.c(BluetoothProfileManager.this, null);
            }
        }
    };

    public BluetoothProfileManager(Context context) {
        this.b = context.getApplicationContext();
        this.a = RtkCore.DEBUG;
        this.a();
    }

    public static BluetoothProfileManager getInstance() {
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial(Context context) {
        if (n != null) return;
        Class<BluetoothProfileManager> clazz = BluetoothProfileManager.class;
        synchronized (BluetoothProfileManager.class) {
            if (n != null) return;
            n = new BluetoothProfileManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static /* synthetic */ BluetoothHeadset a(BluetoothProfileManager bluetoothProfileManager, BluetoothHeadset bluetoothHeadset) {
        bluetoothProfileManager.f = bluetoothHeadset;
        return bluetoothHeadset;
    }

    public static /* synthetic */ BluetoothA2dp a(BluetoothProfileManager bluetoothProfileManager, BluetoothA2dp bluetoothA2dp) {
        bluetoothProfileManager.g = bluetoothA2dp;
        return bluetoothA2dp;
    }

    public static /* synthetic */ BluetoothHealth a(BluetoothProfileManager bluetoothProfileManager, BluetoothHealth bluetoothHealth) {
        bluetoothProfileManager.h = bluetoothHealth;
        return bluetoothHealth;
    }

    public static /* synthetic */ BluetoothProfile a(BluetoothProfileManager bluetoothProfileManager, BluetoothProfile bluetoothProfile) {
        bluetoothProfileManager.i = bluetoothProfile;
        return bluetoothProfile;
    }

    public static /* synthetic */ BluetoothProfile b(BluetoothProfileManager bluetoothProfileManager, BluetoothProfile bluetoothProfile) {
        bluetoothProfileManager.j = bluetoothProfile;
        return bluetoothProfile;
    }

    public static /* synthetic */ BluetoothProfile c(BluetoothProfileManager bluetoothProfileManager, BluetoothProfile bluetoothProfile) {
        bluetoothProfileManager.k = bluetoothProfile;
        return bluetoothProfile;
    }

    public void addManagerCallback(BluetoothProfileCallback bluetoothProfileCallback) {
        if (this.c == null) {
            CopyOnWriteArrayList<BluetoothProfileCallback> copyOnWriteArrayList;
            CopyOnWriteArrayList<BluetoothProfileCallback> copyOnWriteArrayList2 = copyOnWriteArrayList;
            copyOnWriteArrayList = new CopyOnWriteArrayList<BluetoothProfileCallback>();
            this.c = copyOnWriteArrayList2;
        }
        if (!this.c.contains(bluetoothProfileCallback)) {
            this.c.add(bluetoothProfileCallback);
        }
        ZLogger.d("mManagerCallbacks.size=" + this.c.size());
    }

    public void removeManagerCallback(BluetoothProfileCallback bluetoothProfileCallback) {
        List<BluetoothProfileCallback> list = ((BluetoothProfileManager)((Object)list)).c;
        if (list != null) {
            list.remove(bluetoothProfileCallback);
        }
    }

    public void close() {
        BluetoothProfileManager bluetoothProfileManager = this;
        ZLogger.v(bluetoothProfileManager.a, "close()");
        Context context = bluetoothProfileManager.b;
        if (context != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.l);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        }
    }

    public BluetoothProfile getProfile(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 4) {
                    if (n != 11) {
                        if (n != 12) {
                            return null;
                        }
                        return this.k;
                    }
                    return this.j;
                }
                return this.i;
            }
            return this.g;
        }
        return this.f;
    }

    public boolean isProfileSupported(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 4) {
                    if (n != 11) {
                        if (n != 12) {
                            return false;
                        }
                        return this.k != null;
                    }
                    return this.j != null;
                }
                return this.i != null;
            }
            return this.g != null;
        }
        return this.f != null;
    }

    public boolean connectProfile(int n, BluetoothDevice bluetoothDevice) {
        if (n != 4) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothProfileImpl.connectProfile(this.i, "android.bluetooth.BluetoothHidHost", bluetoothDevice);
        }
        return BluetoothProfileImpl.connectProfile(this.i, "android.bluetooth.BluetoothInputDevice", bluetoothDevice);
    }

    public boolean disconnectProfile(int n, BluetoothDevice bluetoothDevice) {
        if (n != 4) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothProfileImpl.disconnect(this.i, "android.bluetooth.BluetoothHidHost", bluetoothDevice);
        }
        return BluetoothProfileImpl.disconnect(this.i, "android.bluetooth.BluetoothInputDevice", bluetoothDevice);
    }

    public boolean connectHid(BluetoothDevice bluetoothDevice) {
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothProfileImpl.connectProfile(this.i, "android.bluetooth.BluetoothHidHost", bluetoothDevice);
        }
        return BluetoothProfileImpl.connectProfile(this.i, "android.bluetooth.BluetoothInputDevice", bluetoothDevice);
    }

    public boolean disConnectHid(BluetoothDevice bluetoothDevice) {
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothProfileImpl.disconnect(this.i, "android.bluetooth.BluetoothHidHost", bluetoothDevice);
        }
        return BluetoothProfileImpl.disconnect(this.i, "android.bluetooth.BluetoothInputDevice", bluetoothDevice);
    }

    public int getConnectionState(int n, BluetoothDevice bluetoothDevice) {
        block6: {
            block12: {
                block11: {
                    BluetoothProfile bluetoothProfile;
                    block10: {
                        BluetoothProfile bluetoothProfile2;
                        block9: {
                            BluetoothA2dp bluetoothA2dp;
                            block8: {
                                block7: {
                                    BluetoothAdapter bluetoothAdapter = this.e;
                                    if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) break block6;
                                    if (n == 1) break block7;
                                    if (n == 2) break block8;
                                    if (n == 4) break block9;
                                    if (n == 11) break block10;
                                    if (n == 12) break block11;
                                    break block12;
                                }
                                BluetoothHeadset bluetoothHeadset = this.f;
                                if (bluetoothHeadset != null) {
                                    return bluetoothHeadset.getConnectionState(bluetoothDevice);
                                }
                                ZLogger.w("HEADSET profile not connected");
                            }
                            if ((bluetoothA2dp = this.g) != null) {
                                return bluetoothA2dp.getConnectionState(bluetoothDevice);
                            }
                            ZLogger.w("A2DP profile not connected");
                        }
                        if ((bluetoothProfile2 = this.i) != null) {
                            if (Build.VERSION.SDK_INT >= 28) {
                                return BluetoothProfileImpl.getConnectionState(bluetoothProfile2, "android.bluetooth.BluetoothHidHost", bluetoothDevice);
                            }
                            return BluetoothProfileImpl.getConnectionState(bluetoothProfile2, "android.bluetooth.BluetoothInputDevice", bluetoothDevice);
                        }
                        ZLogger.w("HID_HOST profile not connected");
                    }
                    if ((bluetoothProfile = this.j) != null) {
                        return BluetoothProfileImpl.getConnectionState(bluetoothProfile, "android.bluetooth.BluetoothA2dpSink", bluetoothDevice);
                    }
                    ZLogger.w("A2DP_SINK profile not connected");
                }
                if ((this = this.k) != null) {
                    return this.getConnectionState(bluetoothDevice);
                }
                ZLogger.w("AVRCP profile not connected");
            }
            return 0;
        }
        ZLogger.w(this.a, "BT not enabled");
        return -1;
    }

    public int getProfileState(BluetoothProfile bluetoothProfile, BluetoothDevice bluetoothDevice) {
        BluetoothProfileManager bluetoothProfileManager = bluetoothProfileManager.e;
        if (bluetoothProfileManager != null && bluetoothProfileManager.isEnabled()) {
            if (bluetoothProfile == null) {
                ZLogger.d("profile is not supported");
                return -1;
            }
            return bluetoothProfile.getConnectionState(bluetoothDevice);
        }
        ZLogger.w("BT not enabled");
        return -1;
    }

    public List<BluetoothDevice> getConnectedDevices(int n) {
        block6: {
            block12: {
                block11: {
                    BluetoothProfile bluetoothProfile;
                    block10: {
                        BluetoothProfile bluetoothProfile2;
                        block9: {
                            BluetoothA2dp bluetoothA2dp;
                            block8: {
                                block7: {
                                    BluetoothAdapter bluetoothAdapter = this.e;
                                    if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) break block6;
                                    if (n == 1) break block7;
                                    if (n == 2) break block8;
                                    if (n == 4) break block9;
                                    if (n == 11) break block10;
                                    if (n == 12) break block11;
                                    break block12;
                                }
                                BluetoothHeadset bluetoothHeadset = this.f;
                                if (bluetoothHeadset != null) {
                                    return bluetoothHeadset.getConnectedDevices();
                                }
                                ZLogger.w("HEADSET profile not connected");
                            }
                            if ((bluetoothA2dp = this.g) != null) {
                                return bluetoothA2dp.getConnectedDevices();
                            }
                            ZLogger.w("A2DP profile not connected");
                        }
                        if ((bluetoothProfile2 = this.i) != null) {
                            if (Build.VERSION.SDK_INT >= 28) {
                                return BluetoothProfileImpl.getConnectedDevices(bluetoothProfile2, "android.bluetooth.BluetoothHidHost");
                            }
                            return BluetoothProfileImpl.getConnectedDevices(bluetoothProfile2, "android.bluetooth.BluetoothInputDevice");
                        }
                        ZLogger.w("HID_HOST profile not connected");
                    }
                    if ((bluetoothProfile = this.j) != null) {
                        return BluetoothProfileImpl.getConnectedDevices(bluetoothProfile, "android.bluetooth.BluetoothA2dpSink");
                    }
                    ZLogger.w("A2DP_SINK profile not connected");
                }
                if ((this = this.k) != null) {
                    return this.getConnectedDevices();
                }
                ZLogger.w("AVRCP profile not connected");
            }
            return null;
        }
        ZLogger.w("BT not enabled");
        return null;
    }

    public boolean getProfileProxy(int n) {
        block9: {
            Object[] objectArray;
            BluetoothProfileManager bluetoothProfileManager;
            BluetoothAdapter bluetoothAdapter;
            try {
                bluetoothAdapter = this.e;
                BluetoothProfileManager bluetoothProfileManager2 = this;
                bluetoothProfileManager = bluetoothProfileManager2;
                objectArray = bluetoothProfileManager2.b;
            }
            catch (Exception exception) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = n;
                objectArray2[1] = exception.toString();
                ZLogger.e(String.format(Locale.US, "getProfileProxy %d exception: %s", objectArray));
                return false;
            }
            if (!bluetoothAdapter.getProfileProxy((Context)objectArray, bluetoothProfileManager.m, n)) break block9;
            boolean bl = this.a;
            Locale locale = Locale.US;
            Object[] objectArray3 = new Object[1];
            int n2 = 0;
            objectArray3[n2] = n;
            ZLogger.d(bl, String.format(locale, "getProfileProxy %d success", objectArray3));
            return true;
        }
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        int n3 = 0;
        objectArray[n3] = n;
        ZLogger.w(String.format(locale, "getProfileProxy %d failed", objectArray));
        return false;
    }

    /*
     * Exception decompiling
     */
    public void closeProfileProxy(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean connectA2dpSource(byte[] byArray) {
        return this.connectA2dpSource(BluetoothHelper.convertMac(byArray));
    }

    public boolean connectA2dpSource(String string) {
        BluetoothProfileManager bluetoothProfileManager = this;
        return bluetoothProfileManager.connectA2dpSource(bluetoothProfileManager.a(string));
    }

    public boolean connectA2dpSource(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("can't find remote device.");
            return false;
        }
        BluetoothA2dp bluetoothA2dp = this.g;
        if (bluetoothA2dp == null) {
            ZLogger.w("A2DP not initialized");
            return false;
        }
        if (bluetoothA2dp.getConnectionState(bluetoothDevice) == 2) {
            ZLogger.w("a2dp already connected");
            return true;
        }
        bluetoothA2dp = this.e;
        if (bluetoothA2dp != null && bluetoothA2dp.isEnabled()) {
            BluetoothProfileManager bluetoothProfileManager = this;
            BluetoothProfileImpl.setPriority((BluetoothProfile)bluetoothProfileManager.g, bluetoothDevice, 100);
            return BluetoothProfileImpl.connectProfile((BluetoothProfile)bluetoothProfileManager.g, bluetoothDevice);
        }
        ZLogger.w("BT not enabled");
        return false;
    }

    public boolean disconnectA2dpSource(byte[] byArray) {
        return this.disconnectA2dpSource(BluetoothHelper.convertMac(byArray));
    }

    public boolean disconnectA2dpSource(String string) {
        BluetoothProfileManager bluetoothProfileManager = this;
        return bluetoothProfileManager.disconnectA2dpSource(bluetoothProfileManager.a(string));
    }

    public boolean disconnectA2dpSource(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("device is null");
            return false;
        }
        BluetoothA2dp bluetoothA2dp = this.g;
        if (bluetoothA2dp == null) {
            ZLogger.w("A2DP not initialized");
            return false;
        }
        if (bluetoothA2dp.getConnectionState(bluetoothDevice) != 2) {
            ZLogger.w("A2DP already disconnected");
            return false;
        }
        BluetoothProfileManager bluetoothProfileManager = this;
        ZLogger.d(bluetoothProfileManager.a, "disconnectA2dpSource" + bluetoothDevice.getAddress());
        BluetoothProfileImpl.setPriority((BluetoothProfile)bluetoothProfileManager.g, bluetoothDevice, 100);
        return BluetoothProfileImpl.disconnect((BluetoothProfile)bluetoothProfileManager.g, bluetoothDevice);
    }

    public boolean connectA2dpSink(byte[] byArray) {
        return this.connectA2dpSource(BluetoothHelper.convertMac(byArray));
    }

    public boolean connectA2dpSink(String string) {
        BluetoothProfileManager bluetoothProfileManager = this;
        return bluetoothProfileManager.connectA2dpSink(bluetoothProfileManager.a(string));
    }

    public boolean connectA2dpSink(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("can't find remote device.");
            return false;
        }
        BluetoothProfile bluetoothProfile = this.j;
        if (bluetoothProfile == null) {
            ZLogger.w("A2DP Sink not initialized");
            return false;
        }
        if (bluetoothProfile.getConnectionState(bluetoothDevice) == 2) {
            ZLogger.w("A2DP Sink already connected");
            return true;
        }
        bluetoothProfile = this.e;
        if (bluetoothProfile != null && bluetoothProfile.isEnabled()) {
            BluetoothProfileManager bluetoothProfileManager = this;
            ZLogger.v(bluetoothProfileManager.a, "connectA2dpSink: " + bluetoothDevice.getAddress());
            return BluetoothProfileImpl.connectProfile(bluetoothProfileManager.j, "android.bluetooth.BluetoothA2dpSink", bluetoothDevice);
        }
        ZLogger.w(this.a, "BT not enabled");
        return false;
    }

    public boolean disconnectA2dpSink(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("device is null");
            return false;
        }
        BluetoothProfile bluetoothProfile = this.j;
        if (bluetoothProfile == null) {
            ZLogger.w("A2DP Sink not initialized");
            return false;
        }
        if (bluetoothProfile.getConnectionState(bluetoothDevice) != 2) {
            ZLogger.w("A2DP Sink already disconnected");
            return false;
        }
        BluetoothProfileManager bluetoothProfileManager = this;
        ZLogger.d(bluetoothProfileManager.a, "disconnectA2dpSink" + bluetoothDevice.getAddress());
        return BluetoothProfileImpl.disconnect(bluetoothProfileManager.j, "android.bluetooth.BluetoothA2dpSink", bluetoothDevice);
    }

    public void setAvrcpAbsoluteVolume(int n) {
        BluetoothA2dpImpl.setAvrcpAbsoluteVolume(this.g, n);
    }

    public boolean connectHfpAg(byte[] byArray) {
        return this.connectHfpAg(BluetoothHelper.convertMac(byArray));
    }

    public boolean connectHfpAg(String string) {
        BluetoothDevice bluetoothDevice = this.e.getRemoteDevice(string);
        if (bluetoothDevice == null) {
            return false;
        }
        BluetoothHeadset bluetoothHeadset = this.f;
        if (bluetoothHeadset == null) {
            ZLogger.w(this.a, "BluetoothHeadset service is not connected");
            return false;
        }
        if (bluetoothHeadset.getConnectionState(bluetoothDevice) == 2) {
            ZLogger.w(this.a, "BluetoothHeadset profile is already connected");
            return true;
        }
        BluetoothProfileManager bluetoothProfileManager = this;
        ZLogger.v(bluetoothProfileManager.a, "HfpAgConnect" + string);
        return BluetoothProfileImpl.connectProfile((BluetoothProfile)bluetoothProfileManager.f, bluetoothDevice);
    }

    public boolean disconnectHfp(byte[] byArray) {
        return this.disconnectHfp(BluetoothHelper.convertMac(byArray));
    }

    public boolean disconnectHfp(String string) {
        if ((string = this.e.getRemoteDevice(string)) == null) {
            return false;
        }
        BluetoothHeadset bluetoothHeadset = this.f;
        if (bluetoothHeadset == null) {
            ZLogger.w(this.a, "BluetoothHeadset service is not connected");
            return false;
        }
        if (bluetoothHeadset.getConnectionState((BluetoothDevice)string) != 2) {
            ZLogger.w(this.a, "BluetoothHeadset profile is not connected");
            return false;
        }
        BluetoothProfileManager bluetoothProfileManager = this;
        ZLogger.d(bluetoothProfileManager.a, "hfpDisconnect");
        return BluetoothProfileImpl.disconnect((BluetoothProfile)bluetoothProfileManager.f, (BluetoothDevice)string);
    }

    public boolean startScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("can't find remote device.");
            return false;
        }
        BluetoothHeadset bluetoothHeadset = this.f;
        if (bluetoothHeadset == null) {
            ZLogger.w(this.a, "BluetoothHeadset service is not connected");
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothHeadsetImpl.startScoUsingVirtualVoiceCall(bluetoothHeadset);
        }
        return BluetoothHeadsetImpl.startScoUsingVirtualVoiceCall(bluetoothHeadset, bluetoothDevice);
    }

    public boolean stopScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            ZLogger.w("can't find remote device.");
            return false;
        }
        BluetoothHeadset bluetoothHeadset = this.f;
        if (bluetoothHeadset == null) {
            ZLogger.w(this.a, "BluetoothHeadset service is not connected");
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothHeadsetImpl.stopScoUsingVirtualVoiceCall(bluetoothHeadset);
        }
        return BluetoothHeadsetImpl.stopScoUsingVirtualVoiceCall(bluetoothHeadset, bluetoothDevice);
    }

    public final boolean a() {
        Context context = this.b;
        if (context == null) {
            ZLogger.w("not intialized");
            return false;
        }
        if (this.e == null) {
            if (Build.VERSION.SDK_INT >= 18) {
                context = (BluetoothManager)context.getSystemService("bluetooth");
                this.d = context;
                if (context == null) {
                    ZLogger.w("Unable to initialize BluetoothManager.");
                    return false;
                }
                this.e = context.getAdapter();
            } else {
                this.e = BluetoothAdapter.getDefaultAdapter();
            }
            if (this.e == null) {
                ZLogger.w("Unable to obtain a BluetoothAdapter.");
                return false;
            }
        }
        this.b();
        return true;
    }

    public final void b() {
        this.a(255);
    }

    public final boolean a(int n) {
        IntentFilter intentFilter;
        if (this.e == null) {
            ZLogger.w("mBluetoothAdapter == null");
            return false;
        }
        this.l = new ProfileBroadcastReceiver();
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter();
        if ((n & 1) == 1) {
            IntentFilter intentFilter3 = intentFilter2;
            this.getProfileProxy(2);
            intentFilter3.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter3.addAction("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED");
        }
        if ((n & 4) == 4) {
            IntentFilter intentFilter4 = intentFilter2;
            this.getProfileProxy(1);
            intentFilter4.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter4.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter4.addAction("android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT");
        }
        if ((n & 8) == 8) {
            this.getProfileProxy(4);
            intentFilter2.addAction("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED");
        }
        if ((n & 2) == 2) {
            IntentFilter intentFilter5 = intentFilter2;
            this.getProfileProxy(11);
            intentFilter5.addAction("android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter5.addAction("android.bluetooth.a2dp-sink.profile.action.PLAYING_STATE_CHANGED");
        }
        if ((n & 0x10) == 16) {
            this.getProfileProxy(12);
            intentFilter2.addAction("android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED");
        }
        this.b.registerReceiver((BroadcastReceiver)this.l, intentFilter2);
        return true;
    }

    public final void a(Intent objectArray) {
        BluetoothDevice bluetoothDevice = (BluetoothDevice)objectArray.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (bluetoothDevice == null) {
            ZLogger.w("onVendorSpecificHeadsetEvent() remote device is null");
            return;
        }
        String string = objectArray.getStringExtra("android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD");
        if (string == null) {
            ZLogger.w("onVendorSpecificHeadsetEvent() command is null");
            return;
        }
        int n = objectArray.getIntExtra("android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE", -1);
        if (n == 0 && n == 1 && n == 2 && n == 3 && n == 4) {
            objectArray = (Object[])objectArray.getExtras().get("android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_ARGS");
            if (string == null) {
                ZLogger.w("onVendorSpecificHeadsetEvent() args is null");
                return;
            }
            List<BluetoothProfileCallback> list = ((BluetoothProfileManager)((Object)iterator)).c;
            if (list != null && list.size() > 0) {
                Iterator<BluetoothProfileCallback> iterator = ((BluetoothProfileManager)((Object)iterator)).c.iterator();
                while (iterator.hasNext()) {
                    ((BluetoothProfileCallback)iterator.next()).onVendorSpecificHeadsetEvent(bluetoothDevice, string, n, objectArray);
                }
            } else {
                ZLogger.v("no callback registed");
            }
            return;
        }
        ZLogger.w("onVendorSpecificHeadsetEvent() unknown command");
    }

    public final BluetoothDevice a(String string) {
        BluetoothAdapter bluetoothAdapter = this.e;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            return this.e.getRemoteDevice(string);
        }
        ZLogger.w("BT not enabled");
        return null;
    }

    public class ProfileBroadcastReceiver
    extends BroadcastReceiver {
        @TargetApi(value=19)
        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            int n = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1772843706: {
                    if (!((String)object).equals("android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT")) break;
                    n = 2;
                    break;
                }
                case 1347806984: {
                    if (!((String)object).equals("android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED")) break;
                    n = 6;
                    break;
                }
                case 1244161670: {
                    if (!((String)object).equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) break;
                    n = 3;
                    break;
                }
                case 545516589: {
                    if (!((String)object).equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) break;
                    n = 0;
                    break;
                }
                case -855499628: {
                    if (!((String)object).equals("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED")) break;
                    n = 4;
                    break;
                }
                case -1021360715: {
                    if (!((String)object).equals("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED")) break;
                    n = 5;
                    break;
                }
                case -1435586571: {
                    if (!((String)object).equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) break;
                    n = 1;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent2 = intent;
                    int n2 = intent2.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n3 = intent2.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray = new Object[5];
                        object2 = objectArray;
                        object2[0] = object;
                        object2[1] = bluetoothDevice.getName();
                        object2[2] = bluetoothDevice.getAddress();
                        object2[3] = n3;
                        objectArray[4] = n2;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", (Object[])object2));
                        break;
                    }
                    Object[] objectArray = new Object[4];
                    object2 = objectArray;
                    object2[0] = object;
                    object2[1] = bluetoothDevice.getName();
                    object2[2] = n3;
                    objectArray[3] = n2;
                    ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", (Object[])object2));
                    break;
                }
                case 5: {
                    Object[] objectArray;
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent3 = intent;
                    int n4 = intent3.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n5 = intent3.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray2 = new Object[5];
                        objectArray = objectArray2;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray[3] = n5;
                        objectArray2[4] = n4;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", objectArray));
                    } else {
                        Object[] objectArray3 = new Object[4];
                        objectArray = objectArray3;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = n5;
                        objectArray3[3] = n4;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", objectArray));
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c != null && ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.size() > 0) {
                        object2 = ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.iterator();
                        while (object2.hasNext()) {
                            ((BluetoothProfileCallback)object2.next()).onHidStateChanged(bluetoothDevice, n4);
                        }
                        break;
                    }
                    ZLogger.v("no callback registed");
                    break;
                }
                case 4: {
                    Object[] objectArray;
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent4 = intent;
                    int n6 = intent4.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n7 = intent4.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray4 = new Object[5];
                        objectArray = objectArray4;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray[3] = n7;
                        objectArray4[4] = n6;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", objectArray));
                    } else {
                        Object[] objectArray5 = new Object[4];
                        objectArray = objectArray5;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = n7;
                        objectArray5[3] = n6;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", objectArray));
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c != null && ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.size() > 0) {
                        object2 = ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.iterator();
                        while (object2.hasNext()) {
                            ((BluetoothProfileCallback)object2.next()).onA2dpPlayingStateChanged(bluetoothDevice, n6);
                        }
                        break;
                    }
                    ZLogger.v("no callback registed");
                    break;
                }
                case 3: {
                    Object[] objectArray;
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent5 = intent;
                    int n8 = intent5.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n9 = intent5.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray6 = new Object[5];
                        objectArray = objectArray6;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray[3] = n9;
                        objectArray6[4] = n8;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", objectArray));
                    } else {
                        Object[] objectArray7 = new Object[4];
                        objectArray = objectArray7;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = n9;
                        objectArray7[3] = n8;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", objectArray));
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c != null && ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.size() > 0) {
                        object2 = ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.iterator();
                        while (object2.hasNext()) {
                            ((BluetoothProfileCallback)object2.next()).onA2dpStateChanged(bluetoothDevice, n8);
                        }
                        break;
                    }
                    ZLogger.v("no callback registed");
                    break;
                }
                case 2: {
                    ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a(intent);
                    break;
                }
                case 1: {
                    Object[] objectArray;
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent6 = intent;
                    int n10 = intent6.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n11 = intent6.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray8 = new Object[5];
                        objectArray = objectArray8;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray[3] = n11;
                        objectArray8[4] = n10;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", objectArray));
                    } else {
                        Object[] objectArray9 = new Object[4];
                        objectArray = objectArray9;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = n11;
                        objectArray9[3] = n10;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", objectArray));
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c != null && ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.size() > 0) {
                        object2 = ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.iterator();
                        while (object2.hasNext()) {
                            ((BluetoothProfileCallback)object2.next()).onHfpAudioStateChanged(bluetoothDevice, n10);
                        }
                        break;
                    }
                    ZLogger.v("no callback registed");
                    break;
                }
                case 0: {
                    Object[] objectArray;
                    Object object2;
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Intent intent7 = intent;
                    int n12 = intent7.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n13 = intent7.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (bluetoothDevice == null) {
                        return;
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.a) {
                        Object[] objectArray10 = new Object[5];
                        objectArray = objectArray10;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray[3] = n13;
                        objectArray10[4] = n12;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s(%s), state: %d->%d", objectArray));
                    } else {
                        Object[] objectArray11 = new Object[4];
                        objectArray = objectArray11;
                        objectArray[0] = object;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = n13;
                        objectArray11[3] = n12;
                        ZLogger.d(String.format(Locale.US, "action=%s, device:%s, state: %d->%d", objectArray));
                    }
                    if (((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c != null && ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.size() > 0) {
                        object2 = ((ProfileBroadcastReceiver)((Object)object2)).BluetoothProfileManager.this.c.iterator();
                        while (object2.hasNext()) {
                            ((BluetoothProfileCallback)object2.next()).onHfpConnectionStateChanged(bluetoothDevice, n12);
                        }
                        break;
                    }
                    ZLogger.v("no callback registed");
                }
            }
        }
    }
}

