/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth;

import android.os.ParcelUuid;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

public final class BluetoothUuid {
    public static final ParcelUuid AUDIO_SINK = ParcelUuid.fromString((String)"0000110B-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AUDIO_SOURCE = ParcelUuid.fromString((String)"0000110A-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid ADV_AUDIO_DIST = ParcelUuid.fromString((String)"0000110D-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HSP = ParcelUuid.fromString((String)"00001108-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HSP_AG = ParcelUuid.fromString((String)"00001112-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HANDSFREE = ParcelUuid.fromString((String)"0000111E-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HANDSFREE_AG = ParcelUuid.fromString((String)"0000111F-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AVRCP_CONTROLLER = ParcelUuid.fromString((String)"0000110E-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AVRCP_TARGET = ParcelUuid.fromString((String)"0000110C-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid OBEX_OBJECT_PUSH = ParcelUuid.fromString((String)"00001105-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid HID = ParcelUuid.fromString((String)"00001124-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid HOGP = ParcelUuid.fromString((String)"00001812-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid PANU = ParcelUuid.fromString((String)"00001115-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid NAP = ParcelUuid.fromString((String)"00001116-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid BNEP = ParcelUuid.fromString((String)"0000000f-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid PBAP_PCE = ParcelUuid.fromString((String)"0000112e-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid PBAP_PSE = ParcelUuid.fromString((String)"0000112f-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MAP = ParcelUuid.fromString((String)"00001134-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MNS = ParcelUuid.fromString((String)"00001133-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MAS = ParcelUuid.fromString((String)"00001132-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid BASE_UUID = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
    public static final int UUID_BYTES_16_BIT = 2;
    public static final int UUID_BYTES_32_BIT = 4;
    public static final int UUID_BYTES_128_BIT = 16;
    public static final ParcelUuid[] RESERVED_UUIDS = new ParcelUuid[]{AUDIO_SINK, AUDIO_SOURCE, ADV_AUDIO_DIST, HSP, HANDSFREE, AVRCP_CONTROLLER, AVRCP_TARGET, OBEX_OBJECT_PUSH, PANU, NAP, MAP, MNS, MAS};

    public static ParcelUuid parseUuidFrom(byte[] byArray) {
        if (byArray != null) {
            int n = byArray.length;
            if (n != 2 && n != 4 && n != 16) {
                throw new IllegalArgumentException("uuidBytes length invalid - " + n);
            }
            if (n == 16) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
                long l = byteBuffer.getLong(8);
                long l2 = byteBuffer.getLong(0);
                return new ParcelUuid(new UUID(l, l2));
            }
            long l = n == 2 ? (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) : (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) + (long)((byArray[2] & 0xFF) << 16) + (long)((byArray[3] & 0xFF) << 24);
            l = BASE_UUID.getUuid().getMostSignificantBits() + (l << 32);
            long l3 = BASE_UUID.getUuid().getLeastSignificantBits();
            return new ParcelUuid(new UUID(l, l3));
        }
        throw new IllegalArgumentException("uuidBytes cannot be null");
    }

    public static ParcelUuid parseUuidReverse(byte[] byArray) {
        if (byArray != null) {
            int n = byArray.length;
            if (n != 2 && n != 4 && n != 16) {
                throw new IllegalArgumentException("uuidBytes length invalid - " + n);
            }
            if (n == 16) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
                long l = byteBuffer.getLong(8);
                long l2 = byteBuffer.getLong(0);
                return new ParcelUuid(new UUID(l, l2));
            }
            long l = n == 2 ? (long)(byArray[1] & 0xFF) + (long)((byArray[0] & 0xFF) << 8) : (long)(byArray[3] & 0xFF) + (long)((byArray[2] & 0xFF) << 8) + (long)((byArray[1] & 0xFF) << 16) + (long)((byArray[0] & 0xFF) << 24);
            l = BASE_UUID.getUuid().getMostSignificantBits() + (l << 32);
            long l3 = BASE_UUID.getUuid().getLeastSignificantBits();
            return new ParcelUuid(new UUID(l, l3));
        }
        throw new IllegalArgumentException("uuidBytes cannot be null");
    }

    @NonNull
    public static UUID fromString(@NonNull String string) {
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UUID.fromString("0000" + string + "-0000-1000-8000-00805F9B34FB");
        }
    }

    @NonNull
    public static UUID fromShortValue(int n) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n & 0xFFFF;
        return UUID.fromString("0000" + String.format("%04X", objectArray2) + "-0000-1000-8000-00805F9B34FB");
    }

    @NonNull
    public static ParcelUuid parcelFromShortValue(int n) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n & 0xFFFF;
        return ParcelUuid.fromString((String)("0000" + String.format("%04X", objectArray2) + "-0000-1000-8000-00805F9B34FB"));
    }

    public static int toShortValue(@NonNull UUID uUID) {
        return (int)(uUID.getMostSignificantBits() >> 32 & 0xFFFFL);
    }

    public static boolean matches(@NonNull UUID uUID, @NonNull UUID uUID2) {
        if (!BluetoothUuid.a(uUID) && !BluetoothUuid.a(uUID2)) {
            return uUID.equals(uUID2);
        }
        return (uUID.getMostSignificantBits() & 0xFFFF00000000L) == (uUID2.getMostSignificantBits() & 0xFFFF00000000L);
    }

    public static boolean a(@NonNull UUID uUID) {
        return (uUID.getMostSignificantBits() & 0xFFFF0000FFFFFFFFL) == 0L && uUID.getLeastSignificantBits() == 0L;
    }

    public static boolean isAudioSource(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)AUDIO_SOURCE);
    }

    public static boolean isAudioSink(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)AUDIO_SINK);
    }

    public static boolean isAdvAudioDist(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)ADV_AUDIO_DIST);
    }

    public static boolean isHandsfree(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)HANDSFREE);
    }

    public static boolean isHeadset(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)HSP);
    }

    public static boolean isAvrcpController(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)AVRCP_CONTROLLER);
    }

    public static boolean isAvrcpTarget(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)AVRCP_TARGET);
    }

    public static boolean isInputDevice(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)HID);
    }

    public static boolean isPanu(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)PANU);
    }

    public static boolean isNap(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)NAP);
    }

    public static boolean isBnep(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)BNEP);
    }

    public static boolean isMap(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)MAP);
    }

    public static boolean isMns(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)MNS);
    }

    public static boolean isMas(ParcelUuid parcelUuid) {
        return parcelUuid.equals((Object)MAS);
    }

    public static boolean isUuidPresent(ParcelUuid[] parcelUuidArray, ParcelUuid parcelUuid) {
        if ((parcelUuidArray == null || parcelUuidArray.length == 0) && parcelUuid == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return false;
        }
        int n = parcelUuidArray.length;
        for (int i = 0; i < n; ++i) {
            if (!parcelUuidArray[i].equals((Object)parcelUuid)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyUuid(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        HashSet<ParcelUuid> hashSet;
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return parcelUuidArray2.length == 0;
        }
        if (parcelUuidArray2 == null) {
            return parcelUuidArray.length == 0;
        }
        HashSet<ParcelUuid> hashSet2 = hashSet;
        hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
        int n = parcelUuidArray2.length;
        for (int i = 0; i < n; ++i) {
            if (!hashSet2.contains(parcelUuidArray2[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllUuids(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        HashSet<ParcelUuid> hashSet;
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return parcelUuidArray2.length == 0;
        }
        if (parcelUuidArray2 == null) {
            return true;
        }
        HashSet<ParcelUuid> hashSet2 = hashSet;
        hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
        int n = parcelUuidArray2.length;
        for (int i = 0; i < n; ++i) {
            if (hashSet2.contains(parcelUuidArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static int getServiceIdentifierFromParcelUuid(ParcelUuid parcelUuid) {
        return (int)((parcelUuid.getUuid().getMostSignificantBits() & 0xFFFF00000000L) >>> 32);
    }

    public static boolean is16BitUuid(ParcelUuid object) {
        return ((UUID)(object = object.getUuid())).getLeastSignificantBits() == BASE_UUID.getUuid().getLeastSignificantBits() && (((UUID)object).getMostSignificantBits() & 0xFFFF0000FFFFFFFFL) == 4096L;
    }

    public static boolean is32BitUuid(ParcelUuid parcelUuid) {
        UUID uUID = parcelUuid.getUuid();
        if (uUID.getLeastSignificantBits() != BASE_UUID.getUuid().getLeastSignificantBits()) {
            return false;
        }
        return !BluetoothUuid.is16BitUuid(parcelUuid) && (uUID.getMostSignificantBits() & 0xFFFFFFFFL) == 4096L;
    }
}

