/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.BluetoothHelper;
import com.realsil.sdk.core.bluetooth.GattError;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.core.utility.DataConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

@TargetApi(value=18)
public class GlobalGatt {
    public static boolean DUMP_SERVICE = false;
    public static boolean CLOSE_GATT_ENABLED = true;
    public static GlobalGatt k;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final UUID CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID;
    public static final String CLIENT_CHARACTERISTIC_CONFIG = "00002902-0000-1000-8000-00805f9b34fb";
    public boolean a = false;
    public BluetoothManager b;
    public BluetoothAdapter c;
    public List<String> d;
    public HashMap<String, BluetoothGatt> e;
    public HashMap<String, List<BluetoothGattCallback>> f;
    public HashMap<String, Integer> g;
    public volatile boolean h;
    public final Object i = new Object();
    public Context j;

    public GlobalGatt(Context context) {
        this.j = context;
        this.e = new HashMap();
        this.g = new HashMap();
        this.f = new HashMap();
        this.d = new CopyOnWriteArrayList<String>();
        this.a = RtkCore.DEBUG;
        this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initial(Context context) {
        if (k != null) return;
        Class<GlobalGatt> clazz = GlobalGatt.class;
        synchronized (GlobalGatt.class) {
            if (k != null) return;
            k = new GlobalGatt(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static GlobalGatt getInstance() {
        return k;
    }

    public static /* synthetic */ boolean a(GlobalGatt globalGatt, boolean bl) {
        globalGatt.h = bl;
        return bl;
    }

    static {
        CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID = UUID.fromString(CLIENT_CHARACTERISTIC_CONFIG);
    }

    public boolean isBluetoothSupported() {
        return this.c != null || this.a();
    }

    public boolean isConnected(String string) {
        Integer n = ((GlobalGatt)((Object)n)).g.get(string);
        if (n == null) {
            return false;
        }
        return n == 2;
    }

    public boolean isHostConnected(String string) {
        Object object = this.b;
        if (object == null) {
            ZLogger.w(this.a, "addr: " + string + ", mBluetoothManager == null");
            return false;
        }
        if ((object = object.getConnectedDevices(7)) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((BluetoothDevice)object.next()).getAddress().equals(string)) continue;
                ZLogger.d(this.a, "addr: " + string + ", Connected.");
                return true;
            }
        }
        ZLogger.d(this.a, "addr: " + string + ", Disconnected.");
        return false;
    }

    public boolean connect(String string, BluetoothGattCallback bluetoothGattCallback) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.connect(string, 2, bluetoothGattCallback);
        }
        return this.connect(string, 2, bluetoothGattCallback);
    }

    public boolean connect(String string, int n, BluetoothGattCallback bluetoothGattCallback) {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.connect(string, false, n, 1, bluetoothGattCallback);
        }
        return this.connect(string, false, n, 1, bluetoothGattCallback);
    }

    public boolean connect(String string, int n, int n2, BluetoothGattCallback bluetoothGattCallback) {
        return this.connect(string, false, n, n2, bluetoothGattCallback);
    }

    public boolean connect(String string, boolean bl, int n, int n2, BluetoothGattCallback bluetoothGattCallback) {
        if (this.c != null && string != null) {
            BluetoothGatt bluetoothGatt;
            Object object;
            if (this.d.contains(string)) {
                object = this.e.get(string);
                if (this.isConnected(string)) {
                    ZLogger.v(this.a, "already connected, addr=" + string);
                    this.registerCallback(string, bluetoothGattCallback);
                    if (bluetoothGattCallback != null) {
                        bluetoothGattCallback.onConnectionStateChange((BluetoothGatt)object, 0, 2);
                    }
                    return true;
                }
                if (object != null) {
                    GlobalGatt globalGatt = this;
                    globalGatt.registerCallback(string, bluetoothGattCallback);
                    ZLogger.v(globalGatt.a, "re-connect previous device: " + string);
                    if (object.connect()) {
                        this.g.put(string, 1);
                        if (bluetoothGattCallback != null) {
                            bluetoothGattCallback.onConnectionStateChange((BluetoothGatt)object, 0, 1);
                        }
                        return true;
                    }
                    ZLogger.w("reconnect failed.");
                    this.closeGatt(string);
                    return false;
                }
            }
            if ((object = this.c.getRemoteDevice(string)) == null) {
                ZLogger.w(this.a, "Device not found.  Unable to connect.");
                return false;
            }
            GlobalGatt globalGatt = this;
            globalGatt.registerCallback(string, bluetoothGattCallback);
            ZLogger.v(globalGatt.a, "create connection to " + string);
            globalGatt.g.put(string, 1);
            int n3 = Build.VERSION.SDK_INT;
            if (n3 >= 26) {
                GattCallback gattCallback;
                BluetoothDevice bluetoothDevice = object;
                Context context = this.j;
                object = gattCallback;
                gattCallback = new GattCallback(null);
                bluetoothGatt = bluetoothDevice.connectGatt(context, bl, (BluetoothGattCallback)object, n, n2);
            } else if (n3 >= 23) {
                GattCallback gattCallback;
                Context context = this.j;
                GattCallback gattCallback2 = gattCallback;
                gattCallback = new GattCallback(null);
                bluetoothGatt = object.connectGatt(context, bl, (BluetoothGattCallback)gattCallback2, n);
            } else {
                GattCallback gattCallback;
                Context context = this.j;
                GattCallback gattCallback3 = gattCallback;
                gattCallback = new GattCallback(null);
                bluetoothGatt = object.connectGatt(context, bl, (BluetoothGattCallback)gattCallback3);
            }
            if (bluetoothGatt == null) {
                ZLogger.w("BluetoothGatt not exist.  Unable to connect.");
            } else {
                GlobalGatt globalGatt2 = this;
                globalGatt2.e.put(string, bluetoothGatt);
                globalGatt2.d.add(string);
            }
            return true;
        }
        ZLogger.w(this.a, "BluetoothAdapter not initialized or unspecified address.");
        return false;
    }

    public synchronized void closeGatt(String string) {
        this.closeGatt(string, CLOSE_GATT_ENABLED);
    }

    public synchronized void closeGatt(String string, boolean bl) {
        Object object;
        if (string == null) {
            ZLogger.d("Invalid address");
            return;
        }
        if (this.e != null) {
            ZLogger.v("closeClient =" + bl);
            BluetoothGatt bluetoothGatt = this.e.get(string);
            if (bl && bluetoothGatt != null) {
                ZLogger.v(this.a, "closeGatt\uff0c addr:=" + string);
                bluetoothGatt.close();
            }
            this.e.remove(string);
        }
        if ((object = this.f) != null) {
            ((HashMap)object).remove(string);
        }
        if ((object = this.d) != null && object.contains(string)) {
            this.d.remove(string);
        }
    }

    public boolean disconnectGatt(String string) {
        BluetoothGatt bluetoothGatt = ((GlobalGatt)((Object)iterator)).e.get(string);
        List<BluetoothGattCallback> list = ((GlobalGatt)((Object)iterator)).f.get(string);
        if (bluetoothGatt != null) {
            if (((GlobalGatt)((Object)iterator)).isConnected(string)) {
                ZLogger.v(((GlobalGatt)((Object)iterator)).a, "disconnect : " + string);
                bluetoothGatt.disconnect();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else if (list != null && list.size() > 0) {
                Iterator<BluetoothGattCallback> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((BluetoothGattCallback)iterator.next()).onConnectionStateChange(bluetoothGatt, 0, 0);
                }
            }
            return true;
        }
        return false;
    }

    public void close(String string) {
        if (string == null) {
            return;
        }
        Object object = this.e.get(string);
        if (object != null) {
            if (this.isConnected(string)) {
                ZLogger.v(this.a, "disconnect : " + string);
                object.disconnect();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (CLOSE_GATT_ENABLED) {
                ZLogger.v(this.a, "closeGatt\uff0c addr:=" + string);
                object.close();
            }
            this.e.remove(string);
        }
        if ((object = this.f) != null) {
            ((HashMap)object).remove(string);
        }
        if ((object = this.d) != null && object.contains(string)) {
            this.d.remove(string);
        }
    }

    public void closeAll() {
        List<String> list = this.d;
        if (list != null && list.size() > 0) {
            list = this.d.iterator();
            while (list.hasNext()) {
                this.close((String)list.next());
            }
        }
    }

    public boolean readCharacteristic(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (this.c != null && this.e.get(string) != null) {
            GlobalGatt globalGatt = this;
            ZLogger.d(globalGatt.a, "raddr: " + string);
            return globalGatt.e.get(string).readCharacteristic(bluetoothGattCharacteristic);
        }
        ZLogger.w(this.a, "BluetoothAdapter not initialized or gatt is null");
        return false;
    }

    public boolean writeCharacteristic(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (this.c != null && this.e.get(string) != null) {
            GlobalGatt globalGatt = this;
            ZLogger.v(globalGatt.a, "addr: " + string);
            return globalGatt.e.get(string).writeCharacteristic(bluetoothGattCharacteristic);
        }
        ZLogger.w(this.a, "BluetoothAdapter not initialized");
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean setCharacteristicNotificationSync(String object, BluetoothGattCharacteristic bluetoothGattCharacteristic, UUID uUID, boolean bl) {
        ZLogger.d(this.a, "addr:=" + (String)object + ", enabled=" + bl);
        this.h = false;
        if (!this.setCharacteristicNotification((String)object, bluetoothGattCharacteristic, uUID, bl)) {
            return false;
        }
        GlobalGatt globalGatt = this;
        object = globalGatt.i;
        synchronized (object) {
            Throwable throwable2;
            block8: {
                block7: {
                    try {
                        if (!globalGatt.h) {
                            GlobalGatt globalGatt2 = this;
                            ZLogger.d(globalGatt2.a, "wait for 3000ms");
                            globalGatt2.i.wait(3000L);
                            ZLogger.d(globalGatt2.a, "wait time reached");
                        }
                        break block7;
                        catch (Throwable throwable2) {
                            break block8;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ZLogger.e(this.a, interruptedException.toString());
                    }
                }
                return true;
            }
            throw throwable2;
        }
    }

    public boolean setCharacteristicNotification(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        return this.setCharacteristicNotification(string, bluetoothGattCharacteristic, CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID, bl);
    }

    public boolean setCharacteristicNotification(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, UUID uUID, boolean bl) {
        if (globalGatt.c == null) {
            ZLogger.w("BluetoothAdapter not initialized");
            return false;
        }
        BluetoothGatt bluetoothGatt = globalGatt.e.get(string);
        if (bluetoothGatt == null) {
            ZLogger.w("BluetoothGatt can not be null, addr=" + string);
            return false;
        }
        ZLogger.d(globalGatt.a, "addr:=" + string + ", enabled=" + bl);
        bluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl);
        GlobalGatt globalGatt = bluetoothGattCharacteristic.getDescriptor(uUID);
        if (globalGatt == null) {
            ZLogger.w("descriptor not found, uuid=" + uUID.toString());
            return false;
        }
        if (bl) {
            globalGatt.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        } else {
            globalGatt.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        }
        bluetoothGatt.writeDescriptor((BluetoothGattDescriptor)globalGatt);
        return true;
    }

    public boolean setCharacteristicIndication(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        return this.setCharacteristicIndication(string, bluetoothGattCharacteristic, CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID, bl);
    }

    public boolean setCharacteristicIndication(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, UUID uUID, boolean bl) {
        if (globalGatt.c == null) {
            ZLogger.w("BluetoothAdapter not initialized");
            return false;
        }
        BluetoothGatt bluetoothGatt = globalGatt.e.get(string);
        if (bluetoothGatt == null) {
            ZLogger.w("BluetoothGatt can not be null, addr=" + string);
            return false;
        }
        ZLogger.d(globalGatt.a, "addr:=" + string + ", enabled=" + bl);
        bluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl);
        GlobalGatt globalGatt = bluetoothGattCharacteristic.getDescriptor(uUID);
        if (globalGatt == null) {
            ZLogger.w("descriptor not found, uuid=" + uUID.toString());
            return false;
        }
        if (bl) {
            globalGatt.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        } else {
            globalGatt.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        }
        bluetoothGatt.writeDescriptor((BluetoothGattDescriptor)globalGatt);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean readCharacteristicSync(String object, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        this.h = false;
        if (!this.readCharacteristic((String)object, bluetoothGattCharacteristic)) {
            return false;
        }
        GlobalGatt globalGatt = this;
        object = globalGatt.i;
        synchronized (object) {
            Throwable throwable2;
            block8: {
                block7: {
                    try {
                        if (!globalGatt.h) {
                            GlobalGatt globalGatt2 = this;
                            ZLogger.v(globalGatt2.a, "wait for 3000ms");
                            globalGatt2.i.wait(3000L);
                            ZLogger.d(globalGatt2.a, "wait time reached");
                        }
                        break block7;
                        catch (Throwable throwable2) {
                            break block8;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ZLogger.e(this.a, interruptedException.toString());
                    }
                }
                return true;
            }
            throw throwable2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean writeCharacteristicSync(String object, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        this.h = false;
        if (!this.writeCharacteristic((String)object, bluetoothGattCharacteristic)) {
            return false;
        }
        GlobalGatt globalGatt = this;
        object = globalGatt.i;
        synchronized (object) {
            Throwable throwable2;
            block8: {
                block7: {
                    try {
                        if (!globalGatt.h) {
                            GlobalGatt globalGatt2 = this;
                            ZLogger.d(globalGatt2.a, "wait for 3000ms");
                            globalGatt2.i.wait(3000L);
                            ZLogger.d(globalGatt2.a, "wait time reached");
                        }
                        break block7;
                        catch (Throwable throwable2) {
                            break block8;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ZLogger.e(this.a, interruptedException.toString());
                    }
                }
                return true;
            }
            throw throwable2;
        }
    }

    public List<String> getBluetoothDeviceAddresss() {
        return this.d;
    }

    public List<BluetoothGattService> getSupportedGattServices(String string) {
        if (this.e.get(string) == null) {
            return null;
        }
        return this.e.get(string).getServices();
    }

    public BluetoothGatt getBluetoothGatt(String string) {
        return this.e.get(string);
    }

    public ArrayList<BluetoothDevice> getConnectDevices() {
        ArrayList<BluetoothDevice> arrayList;
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        for (String string : this.d) {
            if (!this.isConnected(string)) continue;
            arrayList2.add(this.getBluetoothGatt(string).getDevice());
        }
        return arrayList2;
    }

    public String getDeviceName(String string) {
        BluetoothGatt bluetoothGatt = this.e.get(string);
        if (bluetoothGatt == null) {
            ZLogger.w(this.a, "no bluetoothGatt exist, addr=" + string);
            return null;
        }
        return bluetoothGatt.getDevice().getName();
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.c;
    }

    public boolean isCallbackRegisted(String string, BluetoothGattCallback bluetoothGattCallback) {
        return (this = ((GlobalGatt)this).getCallback(string)) != null && this.contains(bluetoothGattCallback);
    }

    public List<BluetoothGattCallback> getCallback(String string) {
        HashMap<String, List<BluetoothGattCallback>> hashMap = ((GlobalGatt)((Object)hashMap)).f;
        return hashMap != null ? (List)hashMap.get(string) : null;
    }

    public void registerCallback(String string, BluetoothGattCallback bluetoothGattCallback) {
        CopyOnWriteArrayList<BluetoothGattCallback> copyOnWriteArrayList = this.getCallback(string);
        if (copyOnWriteArrayList == null) {
            CopyOnWriteArrayList<BluetoothGattCallback> copyOnWriteArrayList2;
            copyOnWriteArrayList = copyOnWriteArrayList2;
            copyOnWriteArrayList();
            copyOnWriteArrayList2.add(bluetoothGattCallback);
            this.f.put(string, copyOnWriteArrayList);
        } else if (!copyOnWriteArrayList.contains(bluetoothGattCallback)) {
            copyOnWriteArrayList.add(bluetoothGattCallback);
            this.f.put(string, copyOnWriteArrayList);
        }
        ZLogger.v(this.a, "addr: " + string + ", size = " + copyOnWriteArrayList.size());
    }

    public void unRegisterCallback(String string, BluetoothGattCallback bluetoothGattCallback) {
        List<BluetoothGattCallback> list = this.getCallback(string);
        if (list == null) {
            ZLogger.d(this.a, "callback not registered, addr= " + string);
            return;
        }
        if (list.contains(bluetoothGattCallback)) {
            ZLogger.v(this.a, "unregister a callback, addr= " + string);
            list.remove(bluetoothGattCallback);
            this.f.put(string, list);
        }
    }

    public void unRegisterAllCallback(String string) {
        if (this.f.get(string) == null) {
            ZLogger.w(this.a, "mCallbacks.get(addr) == null");
            return;
        }
        GlobalGatt globalGatt = this;
        ZLogger.d(globalGatt.a, "addr: " + string);
        globalGatt.f.remove(string);
    }

    public final boolean a() {
        if (this.b == null && (this.b = (BluetoothManager)this.j.getSystemService("bluetooth")) == null) {
            ZLogger.w("BLUETOOTH_SERVICE not supported.");
            return false;
        }
        if (this.c == null && (this.c = this.b.getAdapter()) == null) {
            ZLogger.w("BluetoothAdapter is not supported");
            return false;
        }
        ZLogger.d("initialize success");
        return true;
    }

    public class GattCallback
    extends BluetoothGattCallback {
        public GattCallback() {
        }

        public /* synthetic */ GattCallback(1 var2_2) {
            this();
        }

        @TargetApi(value=21)
        public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
            Object[] objectArray;
            String string = bluetoothGatt.getDevice().getAddress();
            if (((GattCallback)((Object)object)).GlobalGatt.this.a) {
                Object[] objectArray2 = new Object[3];
                objectArray = objectArray2;
                objectArray[0] = GattError.parse(n2);
                objectArray2[1] = n;
                objectArray2[2] = string;
                ZLogger.d(String.format(Locale.US, "%s << mtu= %d, addr=%s", objectArray));
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = GattError.parse(n2);
                objectArray3[1] = n;
                ZLogger.d(String.format(Locale.US, "%s << mtu= %d", objectArray));
            }
            Object object = (List)((GattCallback)((Object)object)).GlobalGatt.this.f.get(string);
            if (object != null && object.size() > 0) {
                object = object.iterator();
                while (object.hasNext()) {
                    ((BluetoothGattCallback)object.next()).onMtuChanged(bluetoothGatt, n, n2);
                }
            }
        }

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            Object[] objectArray;
            Object object = bluetoothGatt.getDevice();
            if (object == null) {
                return;
            }
            object = object.getAddress();
            if (((GattCallback)((Object)object2)).GlobalGatt.this.a) {
                Object[] objectArray2 = new Object[3];
                objectArray = objectArray2;
                objectArray[0] = object;
                objectArray[1] = GattError.parseConnectionError(n);
                objectArray2[2] = BluetoothHelper.parseProfileState(n2);
                ZLogger.v(String.format(Locale.US, "%s, status: %s , newState: %s", objectArray));
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = GattError.parseConnectionError(n);
                objectArray3[1] = BluetoothHelper.parseProfileState(n2);
                ZLogger.v(String.format(Locale.US, "status: %s , newState: %s", objectArray));
            }
            if (n == 0) {
                if (n2 == 2) {
                    GattCallback gattCallback = object2;
                    ZLogger.v(gattCallback.GlobalGatt.this.a, "Connected to GATT server.");
                    gattCallback.GlobalGatt.this.g.put(object, 2);
                    gattCallback.GlobalGatt.this.e.put(object, bluetoothGatt);
                } else {
                    GattCallback gattCallback = object2;
                    ZLogger.v(gattCallback.GlobalGatt.this.a, "Disconnected from GATT server.");
                    gattCallback.GlobalGatt.this.g.put(object, 0);
                }
            } else {
                ((GattCallback)((Object)object2)).GlobalGatt.this.g.put(object, 0);
            }
            Object object2 = (List)((GattCallback)((Object)object2)).GlobalGatt.this.f.get(object);
            if (object2 != null && object2.size() > 0) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    ((BluetoothGattCallback)object2.next()).onConnectionStateChange(bluetoothGatt, n, n2);
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            Object object;
            String string = bluetoothGatt.getDevice().getAddress();
            if (((GattCallback)((Object)object3)).GlobalGatt.this.a) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                objectArray[0] = GattError.parse(n);
                objectArray[1] = string;
                ZLogger.d(String.format(Locale.US, "%s << addr=%s", (Object[])object));
            } else {
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = GattError.parse(n);
                ZLogger.v(String.format(Locale.US, "%s", (Object[])object));
            }
            if (DUMP_SERVICE) {
                for (Object object2 : bluetoothGatt.getServices()) {
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = new Object[3];
                    BluetoothGattCharacteristic bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
                    bluetoothGattCharacteristic2[0] = object2.getType();
                    bluetoothGattCharacteristic2[1] = object2.getInstanceId();
                    bluetoothGattCharacteristic[2] = object2.getUuid().toString();
                    ZLogger.d(String.format(Locale.US, "service: type=%d, %d/%s", (Object[])bluetoothGattCharacteristic2));
                    object2 = object2.getCharacteristics().iterator();
                    while (object2.hasNext()) {
                        bluetoothGattCharacteristic2 = (BluetoothGattCharacteristic)object2.next();
                        Object[] objectArray = new Object[2];
                        Object[] objectArray2 = objectArray;
                        objectArray2[0] = bluetoothGattCharacteristic2.getInstanceId();
                        objectArray[1] = bluetoothGattCharacteristic2.getUuid().toString();
                        ZLogger.v(String.format(Locale.US, "\tcharacteristic: %d/%s", objectArray2));
                    }
                }
            }
            if ((object3 = (List)((GattCallback)((Object)object3)).GlobalGatt.this.f.get(string)) != null && object3.size() > 0) {
                Object object3 = object3.iterator();
                while (object3.hasNext()) {
                    ((BluetoothGattCallback)object3.next()).onServicesDiscovered(bluetoothGatt, n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            Object[] objectArray;
            Object object = bluetoothGattCharacteristic.getValue();
            if (((GattCallback)((Object)object3)).GlobalGatt.this.a) {
                if (object != null) {
                    Object[] objectArray2 = new Object[4];
                    objectArray = objectArray2;
                    objectArray[0] = GattError.parse(n);
                    objectArray[1] = bluetoothGattCharacteristic.getUuid();
                    objectArray[2] = ((byte[])object).length;
                    objectArray2[3] = DataConverter.bytes2Hex(object);
                    ZLogger.d(String.format(Locale.US, "%s << %s\n:\t(%d)%s", objectArray));
                } else {
                    Object[] objectArray3 = new Object[2];
                    object = objectArray3;
                    object[0] = (byte)GattError.parse(n);
                    objectArray3[1] = bluetoothGattCharacteristic.getUuid();
                    ZLogger.d(String.format(Locale.US, "%s << %s", (Object[])object));
                }
            } else if (object != null) {
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray[0] = GattError.parse(n);
                objectArray4[1] = ((byte[])object).length;
                ZLogger.d(String.format(Locale.US, "%s << (%d)", objectArray));
            } else {
                Object[] objectArray5 = new Object[1];
                object = objectArray5;
                objectArray5[0] = GattError.parse(n);
                ZLogger.d(String.format(Locale.US, "%s <<", (Object[])object));
            }
            GattCallback gattCallback = object3;
            Object object2 = ((GattCallback)((Object)object3)).GlobalGatt.this.i;
            object = object2;
            GattCallback gattCallback2 = object3;
            synchronized (object) {
                GlobalGatt.a(gattCallback2.GlobalGatt.this, true);
                gattCallback2.GlobalGatt.this.i.notifyAll();
                // ** MonitorExit[v5] (shouldn't be in output)
                Object object3 = bluetoothGatt.getDevice().getAddress();
                object3 = (List)gattCallback.GlobalGatt.this.f.get(object3);
                if (object3 != null && object3.size() > 0) {
                    object3 = object3.iterator();
                    while (object3.hasNext()) {
                        ((BluetoothGattCallback)object3.next()).onCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, n);
                    }
                }
                return;
            }
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            String string = bluetoothGatt.getDevice().getAddress();
            Object[] objectArray = bluetoothGattCharacteristic.getValue();
            if (((GattCallback)((Object)object)).GlobalGatt.this.a) {
                if (objectArray != null) {
                    Object[] objectArray2 = new Object[3];
                    Object[] objectArray3 = objectArray2;
                    objectArray3[0] = bluetoothGattCharacteristic.getUuid();
                    objectArray3[1] = objectArray.length;
                    objectArray2[2] = DataConverter.bytes2Hex(objectArray);
                    ZLogger.d(String.format(Locale.US, "<< %s\n(%d)%s", objectArray3));
                } else {
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = bluetoothGattCharacteristic.getUuid();
                    ZLogger.d(String.format(Locale.US, "<< %s", objectArray));
                }
            }
            if ((object = (List)((GattCallback)((Object)object)).GlobalGatt.this.f.get(string)) != null && object.size() > 0) {
                Object object = object.iterator();
                while (object.hasNext()) {
                    ((BluetoothGattCallback)object.next()).onCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            Object object2;
            BluetoothGattDescriptor bluetoothGattDescriptor2 = bluetoothGattDescriptor;
            String string = bluetoothGatt.getDevice().getAddress();
            Object object = bluetoothGattDescriptor2.getCharacteristic().getUuid();
            Object[] objectArray = bluetoothGattDescriptor2.getValue();
            if (((GattCallback)((Object)object2)).GlobalGatt.this.a) {
                if (objectArray != null) {
                    Object[] objectArray2 = new Object[5];
                    Object[] objectArray3 = objectArray2;
                    objectArray3[0] = GattError.parse(n);
                    objectArray3[1] = object;
                    objectArray3[2] = bluetoothGattDescriptor.getUuid();
                    objectArray3[3] = objectArray.length;
                    objectArray2[4] = DataConverter.bytes2Hex(objectArray);
                    ZLogger.d(String.format(Locale.US, "%s>> {\nCharacteristic:%s\nDescriptor:%s\nvalue:(%d)%s\n}", objectArray3));
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray = objectArray3;
                    objectArray[0] = (byte)GattError.parse(n);
                    objectArray[1] = (byte)object;
                    objectArray3[2] = bluetoothGattDescriptor.getUuid();
                    ZLogger.d(String.format(Locale.US, "%s>> {\nCharacteristic:%s\nDescriptor:%s}", objectArray));
                }
            }
            GattCallback gattCallback = object2;
            object = gattCallback.GlobalGatt.this.i;
            GattCallback gattCallback2 = object2;
            synchronized (object) {
                GlobalGatt.a(gattCallback2.GlobalGatt.this, true);
                {
                    gattCallback2.GlobalGatt.this.i.notifyAll();
                }
            }
            object2 = (List)gattCallback.GlobalGatt.this.f.get(string);
            if (object2 != null && object2.size() > 0) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    ((BluetoothGattCallback)object2.next()).onDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            String string = bluetoothGatt.getDevice().getAddress();
            Object object = bluetoothGattCharacteristic.getValue();
            if (((GattCallback)((Object)object3)).GlobalGatt.this.a) {
                if (object != null) {
                    Object[] objectArray = new Object[4];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = GattError.parse(n);
                    objectArray2[1] = bluetoothGattCharacteristic.getUuid();
                    objectArray2[2] = ((byte[])object).length;
                    objectArray[3] = DataConverter.bytes2Hex(object);
                    ZLogger.d(String.format(Locale.US, "%s << %s\n(%d)%s", objectArray2));
                } else {
                    Object[] objectArray = new Object[2];
                    object = objectArray;
                    object[0] = (byte)GattError.parse(n);
                    objectArray[1] = bluetoothGattCharacteristic.getUuid();
                    ZLogger.d(String.format(Locale.US, "%s << %s", (Object[])object));
                }
            }
            GattCallback gattCallback = object3;
            Object object2 = gattCallback.GlobalGatt.this.i;
            object = object2;
            GattCallback gattCallback2 = object3;
            synchronized (object) {
                GlobalGatt.a(gattCallback2.GlobalGatt.this, true);
                gattCallback2.GlobalGatt.this.i.notifyAll();
                // ** MonitorExit[v3] (shouldn't be in output)
                Object object3 = (List)gattCallback.GlobalGatt.this.f.get(string);
                if (object3 != null && object3.size() > 0) {
                    object3 = object3.iterator();
                    while (object3.hasNext()) {
                        ((BluetoothGattCallback)object3.next()).onCharacteristicWrite(bluetoothGatt, bluetoothGattCharacteristic, n);
                    }
                }
                return;
            }
        }
    }
}

