/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.BluetoothHelper;
import com.realsil.sdk.core.bluetooth.RtkBluetoothManagerCallback;
import com.realsil.sdk.core.bluetooth.impl.BluetoothAdapterImpl;
import com.realsil.sdk.core.bluetooth.impl.BluetoothDeviceImpl;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class RtkBluetoothManager {
    public static RtkBluetoothManager m;
    public static final int INDICATOR_FULL = 255;
    public static final int INDICATOR_BT = 1;
    public static final int INDICATOR_ACL = 2;
    public static final int INDICATOR_BOND = 4;
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public boolean a = false;
    public Context b;
    public List<RtkBluetoothManagerCallback> c;
    public BluetoothManager d;
    public BluetoothAdapter e;
    public BluetoothBroadcastReceiver f = null;
    public Object g = new Object();
    public Object h = new Object();
    public int i = 255;
    public boolean j = false;
    public Handler k;
    public Runnable l = new Runnable(){

        @Override
        public void run() {
            ZLogger.d("scan delay time reached");
            RtkBluetoothManager.this.c();
        }
    };

    public RtkBluetoothManager(Context context) {
        this.b = context.getApplicationContext();
        this.a = RtkCore.DEBUG;
        this.a();
    }

    public static RtkBluetoothManager getInstance() {
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial(Context context) {
        if (m != null) return;
        Class<RtkBluetoothManager> clazz = RtkBluetoothManager.class;
        synchronized (RtkBluetoothManager.class) {
            if (m != null) return;
            m = new RtkBluetoothManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addManagerCallback(RtkBluetoothManagerCallback rtkBluetoothManagerCallback) {
        if (this.c == null) {
            CopyOnWriteArrayList<RtkBluetoothManagerCallback> copyOnWriteArrayList;
            CopyOnWriteArrayList<RtkBluetoothManagerCallback> copyOnWriteArrayList2 = copyOnWriteArrayList;
            copyOnWriteArrayList = new CopyOnWriteArrayList<RtkBluetoothManagerCallback>();
            this.c = copyOnWriteArrayList2;
        }
        if (!this.c.contains(rtkBluetoothManagerCallback)) {
            this.c.add(rtkBluetoothManagerCallback);
        }
    }

    public void removeManagerCallback(RtkBluetoothManagerCallback rtkBluetoothManagerCallback) {
        List<RtkBluetoothManagerCallback> list = ((RtkBluetoothManager)((Object)list)).c;
        if (list != null) {
            list.remove(rtkBluetoothManagerCallback);
        }
    }

    public void setInterruptPairRequest(boolean bl) {
    }

    public void close() {
        ZLogger.v("close()");
        Context context = this.b;
        if (context != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.f);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        }
    }

    public boolean isBleSupported() {
        return this.b.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public boolean isBleEnabled() {
        RtkBluetoothManager rtkBluetoothManager = rtkBluetoothManager.d;
        rtkBluetoothManager = rtkBluetoothManager != null ? rtkBluetoothManager.getAdapter() : null;
        return rtkBluetoothManager != null && rtkBluetoothManager.isEnabled();
    }

    public boolean reset() {
        RtkBluetoothManager rtkBluetoothManager = this;
        rtkBluetoothManager.c();
        rtkBluetoothManager.unBondAllDevices();
        BluetoothAdapter bluetoothAdapter = rtkBluetoothManager.e;
        if (bluetoothAdapter == null) {
            ZLogger.w("BT is not initialized");
            return false;
        }
        if (bluetoothAdapter.isEnabled()) {
            RtkBluetoothManager rtkBluetoothManager2 = this;
            rtkBluetoothManager2.j = true;
            ZLogger.v(rtkBluetoothManager2.a, "isNeedAutoEnableBt=" + this.j);
            rtkBluetoothManager2.disableBT();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.e.isEnabled()) {
                ZLogger.d(this.a, "BT already enabled");
                return true;
            }
            boolean bl = this.enableBT();
            ZLogger.w(this.a, "enableBT: " + bl);
            return bl;
        }
        return this.enableBT();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean disableBT() {
        block11: {
            BluetoothAdapter bluetoothAdapter = this.e;
            if (bluetoothAdapter == null) {
                ZLogger.w("BT is not initialized..!");
                return false;
            }
            if (bluetoothAdapter.getState() == 10) {
                ZLogger.w("BT already OFF");
                return true;
            }
            boolean bl = this.e.disable();
            ZLogger.v(this.a, "disable BT " + bl);
            if (bl) {
                RtkBluetoothManager rtkBluetoothManager = this;
                Object object = rtkBluetoothManager.h;
                synchronized (object) {
                    Throwable throwable2;
                    block10: {
                        block9: {
                            try {
                                ZLogger.d(rtkBluetoothManager.a, "wait BT disable...");
                                rtkBluetoothManager.h.wait(10000L);
                                break block9;
                                catch (Throwable throwable2) {
                                    break block10;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                ZLogger.e(interruptedException.toString());
                            }
                        }
                        break block11;
                    }
                    throw throwable2;
                }
            }
        }
        if (this.e.isEnabled()) {
            ZLogger.w("BT disable failed");
            return false;
        }
        ZLogger.d(this.a, "BT disable success");
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean enableBT() {
        block11: {
            BluetoothAdapter bluetoothAdapter = this.e;
            if (bluetoothAdapter == null) {
                ZLogger.w("mBluetoothAdapter == null");
                return false;
            }
            if (bluetoothAdapter.getState() == 12) {
                ZLogger.w(this.a, "BT already on");
                return true;
            }
            RtkBluetoothManager rtkBluetoothManager = this;
            rtkBluetoothManager.j = false;
            ZLogger.v(rtkBluetoothManager.a, "isNeedAutoEnableBt=" + this.j);
            boolean bl = rtkBluetoothManager.e.enable();
            ZLogger.v(this.a, "enable BT " + bl);
            if (bl) {
                RtkBluetoothManager rtkBluetoothManager2 = this;
                Object object = rtkBluetoothManager2.g;
                synchronized (object) {
                    Throwable throwable2;
                    block10: {
                        block9: {
                            try {
                                ZLogger.d(rtkBluetoothManager2.a, "wait BT enable...");
                                rtkBluetoothManager2.g.wait(10000L);
                                break block9;
                                catch (Throwable throwable2) {
                                    break block10;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                ZLogger.e(interruptedException.toString());
                            }
                        }
                        break block11;
                    }
                    throw throwable2;
                }
            }
        }
        if (this.e.isEnabled()) {
            ZLogger.d(this.a, "BT enable success");
            return true;
        }
        ZLogger.w("BT enable fail");
        return false;
    }

    public boolean startDiscovery(int n) {
        return this.startDiscovery(n, null);
    }

    public boolean startDiscovery(int n, String string) {
        Handler handler = this.k;
        if (handler != null) {
            handler.removeCallbacks(this.l);
        }
        if ((handler = this.e) != null && handler.isEnabled()) {
            if (this.e.isDiscovering()) {
                this.e.cancelDiscovery();
            }
            RtkBluetoothManager rtkBluetoothManager = this;
            ZLogger.d(rtkBluetoothManager.a, "address=" + string + " , timeout=" + n);
            string = rtkBluetoothManager.k;
            if (string != null) {
                Runnable runnable = this.l;
                long l = n * 1000;
                string.postDelayed(runnable, l);
            }
            this.e.startDiscovery();
            return true;
        }
        ZLogger.w("bluetooth is not supported or disabled");
        return false;
    }

    public boolean setScanMode(int n, int n2) {
        if (n != 20 && n != 21) {
            if (n != 23) {
                return true;
            }
            ZLogger.d("SCAN_MODE_CONNECTABLE_DISCOVERABLE");
            return BluetoothAdapterImpl.setScanMode(this.e, n, n2);
        }
        ZLogger.d("SCAN_MODE_NONE or SCAN_MODE_CONNECTABLE");
        return BluetoothAdapterImpl.setScanMode(this.e, n, 0);
    }

    @TargetApi(value=19)
    public boolean pair(byte[] byArray) {
        if (this.e == null) {
            return false;
        }
        RtkBluetoothManager rtkBluetoothManager = this;
        byte[] byArray2 = new byte[6];
        byte[] byArray3 = byArray2;
        byArray3[0] = byArray[5];
        byArray3[1] = byArray[4];
        byArray3[2] = byArray[3];
        byArray3[3] = byArray[2];
        byArray3[4] = byArray[1];
        byArray2[5] = byArray[0];
        ZLogger.d(rtkBluetoothManager.a, "createBondMac=" + BluetoothHelper.convertMac(byArray));
        BluetoothDevice bluetoothDevice = rtkBluetoothManager.e.getRemoteDevice(byArray3);
        int n = bluetoothDevice.getBondState();
        ZLogger.d(this.a, "attempt to createBond, state=" + Integer.toString(n));
        return bluetoothDevice.createBond();
    }

    public boolean createBond(byte[] byArray) {
        return this.createBond(BluetoothHelper.convertMac(byArray));
    }

    public boolean createBond(String string) {
        BluetoothAdapter bluetoothAdapter = this.e;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            if (string == null) {
                ZLogger.d(this.a, "mac cannot be null");
                return false;
            }
            RtkBluetoothManager rtkBluetoothManager = this;
            ZLogger.d(rtkBluetoothManager.a, "createBondMac=" + string);
            string = rtkBluetoothManager.e.getRemoteDevice(string);
            int n = string.getBondState();
            if (n == 12) {
                ZLogger.d("device already bonded: " + n);
                return true;
            }
            ZLogger.d(this.a, "attempt to createBond, state=" + Integer.toString(n));
            return BluetoothDeviceImpl.createBond((BluetoothDevice)string);
        }
        ZLogger.d(this.a, "bluetooth is not enabled");
        return false;
    }

    public boolean unBondDevice(byte[] object) {
        Object object2 = this.e;
        if (object2 != null && object2.isEnabled()) {
            RtkBluetoothManager rtkBluetoothManager = this;
            object = BluetoothHelper.convertMac((byte[])object);
            ZLogger.d(rtkBluetoothManager.a, "unBondDevice: " + (String)object);
            object2 = rtkBluetoothManager.e.getBondedDevices();
            if (object2 != null && object2.size() > 0) {
                object2 = object2.iterator();
                block0: while (object2.hasNext()) {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)object2.next();
                    ZLogger.d(this.a, "unBondDevice(): before " + bluetoothDevice.getName() + " mac= " + bluetoothDevice.getAddress());
                    if (((String)object).compareToIgnoreCase(bluetoothDevice.getAddress()) != 0) continue;
                    while (true) {
                        int n;
                        if ((n = bluetoothDevice.getBondState()) == 10) {
                            ZLogger.d("removeBond finished");
                            break block0;
                        }
                        if (n == 11) {
                            BluetoothDeviceImpl.cancelBondProcess(bluetoothDevice);
                        }
                        BluetoothDeviceImpl.removeBond(bluetoothDevice);
                    }
                }
            }
            return true;
        }
        ZLogger.d(this.a, "bluetooth is not enabled");
        return false;
    }

    public boolean unBondAllDevices() {
        Object object = this.e;
        if (object != null && object.isEnabled()) {
            object = this.e.getBondedDevices();
            if (object != null && object.size() > 0) {
                object = object.iterator();
                block0: while (object.hasNext()) {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)object.next();
                    for (int i = 0; i < 10; ++i) {
                        Object[] objectArray;
                        int n = bluetoothDevice.getBondState();
                        if (n == 10) {
                            ZLogger.d("already unbond: " + bluetoothDevice.getName());
                            continue block0;
                        }
                        if (n == 11) {
                            boolean bl = BluetoothDeviceImpl.cancelBondProcess(bluetoothDevice);
                            n = bl ? 1 : 0;
                            Object[] objectArray2 = new Object[4];
                            objectArray = objectArray2;
                            objectArray[0] = i;
                            objectArray[1] = bluetoothDevice.getName();
                            objectArray[2] = bluetoothDevice.getAddress();
                            objectArray2[3] = n != 0;
                            ZLogger.v(this.a, String.format(Locale.US, "cancelBondProcess(%d): %s/%s, ret=%b", objectArray));
                            if (!bl) continue;
                            continue block0;
                        }
                        if (n != 12) continue;
                        boolean bl = BluetoothDeviceImpl.removeBond(bluetoothDevice);
                        n = bl ? 1 : 0;
                        Object[] objectArray3 = new Object[4];
                        objectArray = objectArray3;
                        objectArray[0] = i;
                        objectArray[1] = bluetoothDevice.getName();
                        objectArray[2] = bluetoothDevice.getAddress();
                        objectArray3[3] = n != 0;
                        ZLogger.v(this.a, String.format(Locale.US, "removeBond(%d): %s/%s, ret=%b", objectArray));
                        if (bl) continue block0;
                    }
                }
                return true;
            }
            ZLogger.d("no bond device exist");
            return true;
        }
        ZLogger.w("bluetooth is not enabled");
        return false;
    }

    public final boolean a() {
        Context context = this.b;
        if (context == null) {
            ZLogger.w("not intialized");
            return false;
        }
        if (this.e == null) {
            if (Build.VERSION.SDK_INT >= 18) {
                context = (BluetoothManager)context.getSystemService("bluetooth");
                this.d = context;
                if (context == null) {
                    ZLogger.w("Unable to initialize BluetoothManager.");
                    return false;
                }
                this.e = context.getAdapter();
            } else {
                this.e = BluetoothAdapter.getDefaultAdapter();
            }
            if (this.e == null) {
                ZLogger.w("Unable to obtain a BluetoothAdapter.");
                return false;
            }
        }
        this.b();
        return true;
    }

    public final void b() {
        IntentFilter intentFilter;
        if (this.e == null) {
            ZLogger.w("mBluetoothAdapter == null");
            return;
        }
        this.f = new BluetoothBroadcastReceiver();
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter();
        if ((this.i & 1) == 1) {
            intentFilter2.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        }
        if ((this.i & 2) == 2) {
            IntentFilter intentFilter3 = intentFilter2;
            intentFilter3.addAction("android.bluetooth.adapter.action.BLE_ACL_CONNECTED");
            intentFilter3.addAction("android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED");
        }
        if ((this.i & 4) == 4) {
            IntentFilter intentFilter4 = intentFilter2;
            intentFilter4.addAction("android.bluetooth.device.action.PAIRING_REQUEST");
            intentFilter4.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        }
        this.b.registerReceiver((BroadcastReceiver)this.f, intentFilter2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void d(Intent intent) {
        Intent intent2 = intent;
        String string = intent2.getAction();
        int n = intent2.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
        int n2 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray2[1] = n2;
        objectArray[2] = n;
        ZLogger.d(String.format(Locale.US, "action=%s, state: %d->%d", objectArray2));
        switch (n) {
            default: {
                ZLogger.d(((RtkBluetoothManager)((Object)iterator)).a, "ACTION_STATE_CHANGED: " + n);
                break;
            }
            case 13: {
                ZLogger.d(((RtkBluetoothManager)((Object)iterator)).a, "ACTION_STATE_CHANGED: STATE_TURNING_OFF");
                break;
            }
            case 12: {
                RtkBluetoothManager rtkBluetoothManager = iterator;
                ZLogger.d(rtkBluetoothManager.a, "ACTION_STATE_CHANGED: STATE_ON");
                Object object = rtkBluetoothManager.g;
                synchronized (object) {
                    ((RtkBluetoothManager)((Object)iterator)).g.notifyAll();
                    break;
                }
            }
            case 11: {
                ZLogger.d(((RtkBluetoothManager)((Object)iterator)).a, "ACTION_STATE_CHANGED: STATE_TURNING_ON");
                break;
            }
            case 10: {
                RtkBluetoothManager rtkBluetoothManager = iterator;
                ZLogger.d(rtkBluetoothManager.a, "ACTION_STATE_CHANGED: STATE_OFF");
                Object object = rtkBluetoothManager.h;
                synchronized (object) {
                    ((RtkBluetoothManager)((Object)iterator)).h.notifyAll();
                    break;
                }
            }
        }
        Iterator iterator = ((RtkBluetoothManager)((Object)iterator)).c;
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((RtkBluetoothManagerCallback)iterator.next()).onBluetoothStateChaned(null, n);
            }
        }
    }

    public final void a(Intent intent) {
        intent = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (((RtkBluetoothManager)((Object)iterator)).a) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = intent.getAddress();
            objectArray[1] = intent.getName();
            ZLogger.d(String.format(Locale.US, "[%s(%s)", objectArray2));
        }
        if ((iterator = ((RtkBluetoothManager)((Object)iterator)).c) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((RtkBluetoothManagerCallback)iterator.next()).onAclConnectionStateChanged((BluetoothDevice)intent, true);
            }
        }
    }

    public final void b(Intent intent) {
        intent = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (((RtkBluetoothManager)((Object)iterator)).a) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = intent.getAddress();
            objectArray[1] = intent.getName();
            ZLogger.d(String.format(Locale.US, "[%s(%s)", objectArray2));
        }
        if ((iterator = ((RtkBluetoothManager)((Object)iterator)).c) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((RtkBluetoothManagerCallback)iterator.next()).onAclConnectionStateChanged((BluetoothDevice)intent, false);
            }
        }
    }

    public final void e(Intent intent) {
        Object[] objectArray;
        BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (bluetoothDevice == null) {
            return;
        }
        if (objectArray.a) {
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray[0] = intent.getAction();
            objectArray[1] = bluetoothDevice.getAddress();
            objectArray2[2] = bluetoothDevice.getName();
            ZLogger.d(String.format(Locale.US, "action=%s, %s(%s)", objectArray));
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = intent.getAction();
            objectArray3[1] = bluetoothDevice.getName();
            ZLogger.d(String.format(Locale.US, "action=%s, %s", objectArray));
        }
        int n = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
        ZLogger.v("android.bluetooth.device.extra.PAIRING_VARIANT>> " + BluetoothDeviceImpl.pairingVariantToString(n) + " (" + n + ")");
        if (bluetoothDevice.getBondState() == 12) {
            ZLogger.i("device already bonded: " + bluetoothDevice.getAddress());
            return;
        }
    }

    public final void c(Intent intent) {
        Object[] objectArray;
        BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        Intent intent2 = intent;
        int n = intent2.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
        int n2 = intent2.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
        int n3 = intent2.getIntExtra(EXTRA_REASON, -1);
        if (bluetoothDevice == null) {
            return;
        }
        if (((RtkBluetoothManager)((Object)iterator)).a) {
            Object[] objectArray2 = new Object[6];
            objectArray = objectArray2;
            objectArray[0] = intent.getAction();
            objectArray[1] = bluetoothDevice.getAddress();
            objectArray[2] = bluetoothDevice.getName();
            objectArray[3] = n;
            objectArray[4] = n2;
            objectArray2[5] = n3;
            ZLogger.d(String.format(Locale.US, "action=%s, [%s(%s), state:%d->%d, reason=%d", objectArray));
        } else {
            Object[] objectArray3 = new Object[5];
            objectArray = objectArray3;
            objectArray[0] = intent.getAction();
            objectArray[1] = bluetoothDevice.getName();
            objectArray[2] = n;
            objectArray[3] = n2;
            objectArray3[4] = n3;
            ZLogger.v(String.format(Locale.US, "action=%s, [%s, state:%d->%d, reason=%d", objectArray));
        }
        Iterator iterator = ((RtkBluetoothManager)((Object)iterator)).c;
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((RtkBluetoothManagerCallback)iterator.next()).onBondStateChanged(bluetoothDevice, n2);
            }
        }
    }

    public final boolean c() {
        boolean bl;
        Handler handler = this.k;
        if (handler != null) {
            handler.removeCallbacks(this.l);
        }
        if ((handler = this.e) == null || !handler.isEnabled()) {
            ZLogger.w("bluetooth is not supported or disabled");
        }
        if (this.e.isDiscovering()) {
            RtkBluetoothManager rtkBluetoothManager = this;
            ZLogger.d(rtkBluetoothManager.a, "stopInquiry()");
            bl = rtkBluetoothManager.e.cancelDiscovery();
        } else {
            bl = true;
        }
        return bl;
    }

    public class BluetoothBroadcastReceiver
    extends BroadcastReceiver {
        @TargetApi(value=19)
        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            int n = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 2116862345: {
                    if (!((String)object).equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) break;
                    n = 4;
                    break;
                }
                case 1652078734: {
                    if (!((String)object).equals("android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED")) break;
                    n = 2;
                    break;
                }
                case 1546533238: {
                    if (!((String)object).equals("android.bluetooth.adapter.action.BLE_ACL_CONNECTED")) break;
                    n = 1;
                    break;
                }
                case -223687943: {
                    if (!((String)object).equals("android.bluetooth.device.action.PAIRING_REQUEST")) break;
                    n = 3;
                    break;
                }
                case -1530327060: {
                    if (!((String)object).equals("android.bluetooth.adapter.action.STATE_CHANGED")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    ZLogger.d("action:" + (String)object);
                    break;
                }
                case 4: {
                    RtkBluetoothManager.this.c(intent);
                    break;
                }
                case 3: {
                    RtkBluetoothManager.this.e(intent);
                    break;
                }
                case 2: {
                    RtkBluetoothManager.this.b(intent);
                    break;
                }
                case 1: {
                    RtkBluetoothManager.this.a(intent);
                    break;
                }
                case 0: {
                    RtkBluetoothManager.this.d(intent);
                }
            }
        }
    }
}

