/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.channel;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import com.realsil.sdk.core.bluetooth.channel.IChannelCallback;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.Locale;

public abstract class Channel {
    public static final int STATE_NONE = 0;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 256;
    public static final int STATE_LISTEN = 257;
    public static final int STATE_CONNECTED = 512;
    public static final int STATE_DISCONNECTING = 768;
    public IChannelCallback mCallback;
    public boolean initialized;
    public Context a;
    public BluetoothAdapter b;
    public int c = 0;
    public BluetoothDevice d = null;

    public Channel(Context context, IChannelCallback iChannelCallback) {
        this.a = context;
        this.mCallback = iChannelCallback;
    }

    public Channel(IChannelCallback iChannelCallback) {
        this.mCallback = iChannelCallback;
    }

    public void a() {
        ZLogger.v("initialize...");
        Context context = this.a;
        if (context != null && Build.VERSION.SDK_INT >= 18) {
            BluetoothManager cfr_ignored_0 = (BluetoothManager)context.getSystemService("bluetooth");
        }
        context = BluetoothAdapter.getDefaultAdapter();
        this.b = context;
        if (context == null) {
            ZLogger.d("BluetoothAdapter not initialized ");
            this.initialized = false;
            return;
        }
        if (!context.isEnabled()) {
            ZLogger.d("Bluetooth is disabled ");
            this.initialized = false;
            return;
        }
        this.initialized = true;
    }

    public BluetoothDevice getDevice() {
        return this.d;
    }

    public int getConnectionState() {
        return this.c;
    }

    public synchronized void a(int n) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = this.c;
        objectArray[1] = n;
        ZLogger.v(String.format(Locale.US, ">> ConnectionState=0x%04X > 0x%04X", (Object[])object));
        this.c = n;
        object = this.mCallback;
        if (object != null) {
            ((IChannelCallback)object).onConnectionStateChanged(this.d, true, n);
        } else {
            ZLogger.v("no callback registered");
        }
    }
}

