/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.channel;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.channel.Channel;
import com.realsil.sdk.core.bluetooth.channel.IChannelCallback;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.core.utility.DataConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;

public class SppChannel
extends Channel {
    public static final UUID l = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public static final int ROLE_CLIENT = 1;
    public static final int ROLE_SERVER = 2;
    public boolean e = false;
    public int f = 1;
    public UUID g = l;
    public ConnectThread h;
    public ConnectedThread i;
    public AcceptThread j;
    public int k = -1;

    public SppChannel(IChannelCallback iChannelCallback) {
        this(1, l, iChannelCallback);
    }

    public SppChannel(UUID uUID, IChannelCallback iChannelCallback) {
        this(1, uUID, iChannelCallback);
    }

    public SppChannel(int n, UUID uUID, IChannelCallback iChannelCallback) {
        super(iChannelCallback);
        this.f = n;
        this.g = uUID;
        this.c = 0;
        this.e = RtkCore.DEBUG;
        this.a();
    }

    public static /* synthetic */ int a(SppChannel sppChannel, int n) {
        sppChannel.k = n;
        return n;
    }

    public static /* synthetic */ ConnectThread a(SppChannel sppChannel, ConnectThread connectThread) {
        sppChannel.h = connectThread;
        return connectThread;
    }

    public synchronized void start(boolean bl) {
        ZLogger.v("start secure: " + bl);
        Thread thread = this.h;
        if (thread != null) {
            ((ConnectThread)thread).cancel();
            this.h = null;
        }
        if ((thread = this.i) != null) {
            ((ConnectedThread)thread).cancel();
            this.i = null;
        }
        if ((this.f & 2) == 2 && this.j == null) {
            AcceptThread acceptThread;
            thread = acceptThread;
            ((AcceptThread)thread)(bl);
            this.j = thread;
            acceptThread.start();
        }
    }

    public synchronized void start() {
        this.start(true);
    }

    public synchronized boolean connect(BluetoothDevice bluetoothDevice, BluetoothSocket bluetoothSocket) {
        if (!this.initialized) {
            this.a();
        }
        if (bluetoothSocket != null) {
            this.connected(bluetoothSocket, bluetoothDevice, "Secure");
            return true;
        }
        return this.connect(bluetoothDevice);
    }

    public synchronized boolean connect(BluetoothDevice bluetoothDevice) {
        ConnectThread connectThread;
        Thread thread;
        if (bluetoothDevice == null) {
            return false;
        }
        if (!this.initialized) {
            this.a();
        }
        this.d = bluetoothDevice;
        if (this.c == 256 && (thread = this.h) != null) {
            ((ConnectThread)thread).cancel();
            this.h = null;
        }
        if ((thread = this.i) != null) {
            ((ConnectedThread)thread).cancel();
            this.i = null;
        }
        thread = connectThread;
        ((ConnectThread)thread)(bluetoothDevice);
        this.h = thread;
        connectThread.start();
        return true;
    }

    public synchronized void connected(BluetoothSocket bluetoothSocket, BluetoothDevice object, String string) {
        ConnectedThread connectedThread;
        ZLogger.v("BluetoothSocket connected, Socket Type: " + string);
        this.d = object;
        object = this.h;
        if (object != null) {
            ((ConnectThread)object).cancel();
            this.h = null;
        }
        if ((object = this.i) != null) {
            ((ConnectedThread)object).cancel();
            this.i = null;
        }
        if ((object = this.j) != null) {
            ((AcceptThread)object).cancel();
            this.j = null;
        }
        object = connectedThread;
        ((ConnectedThread)object)(this, bluetoothSocket, string);
        this.i = object;
        connectedThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(byte[] byArray) {
        SppChannel sppChannel = this;
        synchronized (sppChannel) {
            ConnectedThread connectedThread;
            block5: {
                if (sppChannel.c != 512) {
                    ZLogger.d("not connected");
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                connectedThread = this.i;
                {
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (connectedThread != null) break block5;
                }
                ZLogger.d("ConnectedThread not created");
                return false;
            }
            return connectedThread.write(byArray);
        }
    }

    public synchronized void destroy() {
        this.mCallback = null;
        this.stop();
    }

    public synchronized void stop() {
        Thread thread;
        ZLogger.v("stop");
        this.d = null;
        if (this.c == 512) {
            this.a(768);
        }
        if ((thread = this.h) != null) {
            ((ConnectThread)thread).cancel();
            this.h = null;
        }
        if ((thread = this.i) != null) {
            ((ConnectedThread)thread).cancel();
            this.i = null;
        }
        if ((thread = this.j) != null) {
            ((AcceptThread)thread).cancel();
            this.j = null;
        }
    }

    public final void b() {
        SppChannel sppChannel = this;
        ZLogger.v("connectionFailed");
        sppChannel.d = null;
        sppChannel.a(0);
        sppChannel.start();
    }

    public final void c() {
        SppChannel sppChannel = this;
        ZLogger.v("connectionLost");
        sppChannel.d = null;
        sppChannel.a(0);
        sppChannel.start();
    }

    public static class ConnectedThread
    extends Thread {
        public final BluetoothSocket a;
        public BufferedInputStream b;
        public BufferedOutputStream c;
        public final /* synthetic */ SppChannel d;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ConnectedThread(SppChannel object, BluetoothSocket object2, String string) {
            Object object3;
            block7: {
                block6: {
                    BufferedOutputStream bufferedOutputStream;
                    BufferedInputStream bufferedInputStream;
                    this.d = object;
                    this.b = null;
                    this.c = null;
                    ZLogger.d("create ConnectedThread");
                    this.a = object2;
                    object = null;
                    string = null;
                    object3 = bufferedInputStream;
                    try {
                        bufferedInputStream = new BufferedInputStream(object2.getInputStream());
                    }
                    catch (IOException iOException) {
                        object3 = object;
                        break block6;
                    }
                    object = bufferedOutputStream;
                    try {
                        bufferedOutputStream = new BufferedOutputStream(object2.getOutputStream());
                        break block7;
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                    }
                }
                ZLogger.e("temp sockets not created: " + object2);
                object = string;
            }
            ConnectedThread connectedThread = this;
            connectedThread.b = object3;
            connectedThread.c = object;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ZLogger.d("BEGIN mConnectedThread");
            byte[] byArray = new byte[1024];
            this.d.a(512);
            while (this.d.c == 512) {
                int n;
                try {
                    n = this.b.read(byArray);
                    if (n <= 0) continue;
                }
                catch (IOException iOException) {
                    ZLogger.e(iOException.toString());
                    this.d.c();
                    return;
                }
                {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    if (this.d.e) {
                        ZLogger.v("[RX >>] (" + n + ") " + DataConverter.bytes2HexWithSeparate(byArray2));
                    }
                    if (this.d.mCallback == null) continue;
                    this.d.mCallback.onDataReceive(byArray2);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean write(byte[] byArray) {
            if (this.c == null) {
                return false;
            }
            try {
                if (this.d.e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = byArray.length;
                    int n = 1;
                    objectArray[n] = DataConverter.bytes2Hex(byArray);
                    ZLogger.v(String.format(Locale.US, "<< (%d) %s", objectArray));
                }
                ConnectedThread connectedThread = this;
                connectedThread.c.write(byArray);
                connectedThread.c.flush();
                return true;
            }
            catch (IOException iOException) {
                ZLogger.e("Exception during write\uff1a " + iOException);
                return false;
            }
        }

        public void cancel() {
            ConnectedThread connectedThread = connectedThread.a;
            if (connectedThread == null) {
                return;
            }
            try {
                connectedThread.close();
            }
            catch (IOException iOException) {
                ZLogger.e("close socket failed: " + iOException);
            }
        }
    }

    public class ConnectThread
    extends Thread {
        public final BluetoothSocket a;
        public final BluetoothDevice b;
        public String c;

        public ConnectThread(BluetoothDevice bluetoothDevice, boolean bl) {
            this.b = bluetoothDevice;
            this.a = this.a(bluetoothDevice, bl);
            SppChannel.this.a(256);
        }

        public ConnectThread(BluetoothDevice bluetoothDevice) {
            this(bluetoothDevice, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SppChannel sppChannel;
            ConnectThread connectThread;
            ConnectThread connectThread2 = connectThread4;
            ZLogger.d("BEGIN mConnectThread SocketType:" + connectThread4.c + ", mSocketConnectionType: " + connectThread4.SppChannel.this.k);
            connectThread2.setName("ConnectThread:SppChannel");
            if (connectThread2.a == null) {
                ZLogger.w("get BluetoothSocket fail, connect fail");
                connectThread4.SppChannel.this.a(0);
                return;
            }
            BluetoothAdapter bluetoothAdapter = connectThread4.SppChannel.this.b;
            if (bluetoothAdapter != null) {
                bluetoothAdapter.cancelDiscovery();
            }
            try {
                if (connectThread4.a.isConnected()) {
                    ZLogger.d("socket already connected");
                } else {
                    ZLogger.d("connect socket ...");
                    connectThread4.a.connect();
                }
                connectThread = connectThread4;
                sppChannel = connectThread.SppChannel.this;
            }
            catch (IOException iOException) {
                ZLogger.e(iOException.toString());
                try {
                    connectThread4.a.close();
                }
                catch (IOException iOException2) {
                    ZLogger.e("unable to close socket during connection failure: " + iOException2);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                connectThread4.SppChannel.this.b();
                return;
            }
            synchronized (sppChannel) {
                SppChannel.a(connectThread4.SppChannel.this, null);
                {
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl42 : MonitorExitStatement: MONITOREXIT : var1_2
                    ConnectThread connectThread3 = connectThread4;
                    ConnectThread connectThread4 = connectThread3.a;
                    BluetoothDevice bluetoothDevice = connectThread3.b;
                    String string = connectThread3.c;
                    connectThread.SppChannel.this.connected((BluetoothSocket)connectThread4, bluetoothDevice, string);
                    return;
                }
            }
        }

        public void cancel() {
            block3: {
                if (this.a == null) break block3;
                try {
                    this.a.close();
                }
                catch (IOException iOException) {
                    ZLogger.e("close socket failed: " + iOException);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public final BluetoothSocket a(BluetoothDevice var1_1, boolean var2_3) {
            var3_4 = null;
            var4_5 = var2_3 != false ? "Secure" : "Insecure";
            this.c = var4_5;
            if (var2_3) {
                v0 = var1_1.createRfcommSocketToServiceRecord(SppChannel.b(SppChannel.this));
lbl7:
                // 2 sources

                while (true) {
                    var1_1 = v0;
                    break;
                }
            } else {
                try {
                    v0 = var1_1.createInsecureRfcommSocketToServiceRecord(SppChannel.b(SppChannel.this));
                    ** continue;
                }
                catch (IOException var1_2) {
                    ZLogger.e("Socket Type: " + this.c + "create() failed: " + var1_2.toString());
                    var1_1 = var3_4;
                }
            }
            if (var1_1 != null && Build.VERSION.SDK_INT >= 23) {
                SppChannel.a(SppChannel.this, var1_1.getConnectionType());
            }
            return var1_1;
        }
    }

    public class AcceptThread
    extends Thread {
        public final BluetoothServerSocket a;
        public String b;

        public AcceptThread(boolean bl) {
            String string = bl ? "Secure" : "Insecure";
            this.b = string;
            this.a = this.a(bl);
            SppChannel.this.a(257);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ZLogger.v("Socket Type: " + this.b + "BEGIN mAcceptThread");
            this.setName("AcceptThread:SppChannel");
lbl3:
            // 6 sources

            while (SppChannel.this.c != 512) {
                try {
                    var1_1 = this.a.accept();
                    if (var1_1 == null) continue;
                    v0 = this;
                    var2_3 = v0.SppChannel.this;
                }
                catch (IOException var1_2) {
                    ZLogger.e("accept() failed" + var1_2);
                    SppChannel.this.a(0);
                    break;
                }
                synchronized (var2_3) {
                    block12: {
                        var3_4 = v0.SppChannel.this.c;
                        if (var3_4 == 0 || var3_4 == 512) ** GOTO lbl30
                        if (var3_4 != 256 && var3_4 != 257) ** GOTO lbl3
                        if (Build.VERSION.SDK_INT < 23) break block12;
                        SppChannel.a(SppChannel.this, var1_1.getConnectionType());
                    }
                    v2 = SppChannel.this;
                    v3 = var1_1;
                    v4 = this;
                    var1_1 = var1_1.getRemoteDevice();
                    v2.connected(v3, (BluetoothDevice)var1_1, v4.b);
                    ** GOTO lbl3
lbl30:
                    // 1 sources

                    try {
                        var1_1.close();
                    }
                    catch (IOException v5) {
                        ZLogger.e("Could not close unwanted socket\uff1a " + v5);
                    }
                }
            }
            ZLogger.d("END AcceptThread");
        }

        public void cancel() {
            block3: {
                ZLogger.v("cancel AcceptThread");
                if (this.a == null) break block3;
                try {
                    this.a.close();
                }
                catch (IOException iOException) {
                    ZLogger.e("close() of server failed\uff1a " + iOException);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final BluetoothServerSocket a(boolean bl) {
            BluetoothAdapter bluetoothAdapter;
            BluetoothServerSocket bluetoothServerSocket;
            Object var1_2 = null;
            if (bl) {
                BluetoothAdapter bluetoothAdapter2 = SppChannel.this.b;
                bluetoothServerSocket = bluetoothAdapter2.listenUsingRfcommWithServiceRecord("RealtekSppChannelSecure", SppChannel.this.g);
                return bluetoothServerSocket;
            }
            try {
                bluetoothAdapter = SppChannel.this.b;
            }
            catch (IOException iOException) {
                ZLogger.e("Socket Type: " + this.b + " listen() failed: " + iOException.toString());
                return var1_2;
            }
            bluetoothServerSocket = bluetoothAdapter.listenUsingInsecureRfcommWithServiceRecord("RealtekSppChannelInsecure", SppChannel.this.g);
            return bluetoothServerSocket;
        }
    }
}

