/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.impl;

import android.bluetooth.BluetoothClass;
import com.realsil.sdk.core.logger.ZLogger;

public class BluetoothClassImpl {
    public static boolean isHidDevice(BluetoothClass bluetoothClass) {
        boolean bl = false;
        if (bluetoothClass == null) {
            return false;
        }
        int n = bluetoothClass.getDeviceClass();
        if (n == 1344 || n == 1408 || n == 1472) {
            bl = true;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = bluetoothClass.getDeviceClass();
        objectArray[1] = bl;
        ZLogger.v(String.format("getDeviceClass: 0x%04X, isHid=%b", objectArray2));
        return bl;
    }

    public static boolean isAudioDevice(BluetoothClass bluetoothClass) {
        if (bluetoothClass == null) {
            return false;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bluetoothClass.getDeviceClass();
        ZLogger.v(String.format("getDeviceClass: 0x%04X", objectArray2));
        switch (bluetoothClass.getDeviceClass()) {
            default: {
                return false;
            }
            case 1024: 
            case 1028: 
            case 1032: 
            case 1040: 
            case 1044: 
            case 1048: 
            case 1052: 
            case 1056: 
            case 1060: 
            case 1064: 
            case 1068: 
            case 1072: 
            case 1076: 
            case 1080: 
            case 1084: 
            case 1088: 
            case 1096: 
        }
        return true;
    }

    public static class Device {
        public static final int PERIPHERAL_NON_KEYBOARD_NON_POINTING = 1280;
        public static final int PERIPHERAL_KEYBOARD = 1344;
        public static final int PERIPHERAL_POINTING = 1408;
        public static final int PERIPHERAL_KEYBOARD_POINTING = 1472;
    }
}

