/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.impl;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.realsil.sdk.core.logger.ZLogger;
import java.lang.reflect.Method;

public class BluetoothDeviceImpl {
    public static final int BATTERY_LEVEL_UNKNOWN = -1;
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_CONSENT = 3;
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    public static final int PAIRING_VARIANT_OOB_CONSENT = 6;

    @SuppressLint(value={"NewApi"})
    public static boolean createBond(BluetoothDevice bluetoothDevice) {
        block5: {
            if (Build.VERSION.SDK_INT >= 19) {
                return bluetoothDevice.createBond();
            }
            Class<?> clazz = bluetoothDevice.getClass();
            Method method = clazz.getMethod("createBond", null);
            if (method == null) break block5;
            try {
                return (Boolean)method.invoke((Object)bluetoothDevice, new Object[0]);
            }
            catch (Exception exception) {
                ZLogger.w("An exception occurred while creating bond: " + exception.toString());
            }
        }
        return false;
    }

    public static boolean createBond(BluetoothDevice bluetoothDevice, int n) {
        if (bluetoothDevice == null) {
            return false;
        }
        Class<?> clazz = bluetoothDevice.getClass();
        Class[] classArray = new Class[1];
        classArray[0] = Integer.TYPE;
        Method method = clazz.getMethod("createBond", classArray);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        Object[] objectArray = new Object[1];
        int n2 = 0;
        try {
            objectArray[n2] = n;
            method.invoke((Object)bluetoothDevice2, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean cancelBondProcess(BluetoothDevice bluetoothDevice) {
        block5: {
            Class<?> clazz = bluetoothDevice.getClass();
            Method method = clazz.getMethod("cancelBondProcess", null);
            if (method == null) break block5;
            Method method2 = method;
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            method.setAccessible(true);
            try {
                return (Boolean)method2.invoke((Object)bluetoothDevice2, null);
            }
            catch (Exception exception) {
                ZLogger.w("An exception occurred while cancelBondProcess : " + exception.getMessage());
            }
        }
        return false;
    }

    public static boolean cancelPairingUserInput(BluetoothDevice bluetoothDevice) throws Exception {
        return (Boolean)bluetoothDevice.getClass().getMethod("cancelPairingUserInput", new Class[0]).invoke((Object)bluetoothDevice, new Object[0]);
    }

    public static boolean removeBond(BluetoothDevice bluetoothDevice) {
        block5: {
            Class<?> clazz = bluetoothDevice.getClass();
            Method method = clazz.getMethod("removeBond", null);
            if (method == null) break block5;
            Method method2 = method;
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            method.setAccessible(true);
            try {
                return (Boolean)method2.invoke((Object)bluetoothDevice2, null);
            }
            catch (Exception exception) {
                ZLogger.w("An exception occurred while removing bond information: " + exception.getMessage());
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public static boolean isConnected(BluetoothDevice bluetoothDevice) {
        Class<BluetoothDevice> clazz;
        if (bluetoothDevice == null) {
            return false;
        }
        try {
            clazz = BluetoothDevice.class;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
        Method method = clazz.getDeclaredMethod("isConnected", null);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        method.setAccessible(true);
        return (Boolean)method.invoke((Object)bluetoothDevice2, null);
    }

    public static String parseDeviceType(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return "Unknown";
                }
                return "DUAL(BR/EDR/LE)";
            }
            return "LE";
        }
        return "BR/EDR";
    }

    public static String pairingVariantToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 0: 
        }
        return "PAIRING_VARIANT_PIN";
    }

    public static boolean setPassKey(BluetoothDevice bluetoothDevice, int n) {
        Class<?> clazz = bluetoothDevice.getClass();
        Class[] classArray = new Class[1];
        classArray[0] = Integer.TYPE;
        Method method = clazz.getDeclaredMethod("setPasskey", classArray);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        Object[] objectArray = new Object[1];
        int n2 = 0;
        try {
            objectArray[n2] = n;
            ZLogger.e("returnValue=" + (Boolean)method.invoke((Object)bluetoothDevice2, objectArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return true;
    }
}

