/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.impl;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.realsil.sdk.core.logger.ZLogger;

public class BluetoothHeadsetImpl {
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV = "+IPHONEACCEV";
    public static final int VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV_BATTERY_LEVEL = 1;
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT = "+XEVENT";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT_BATTERY_LEVEL = "BATTERY";

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static boolean startScoUsingVirtualVoiceCall(BluetoothHeadset bluetoothHeadset) {
        Class<?> clazz;
        if (bluetoothHeadset == null) {
            return false;
        }
        try {
            clazz = bluetoothHeadset.getClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return (Boolean)clazz.getMethod("startScoUsingVirtualVoiceCall", new Class[0]).invoke((Object)bluetoothHeadset, new Object[0]);
    }

    public static boolean startScoUsingVirtualVoiceCall(BluetoothHeadset bluetoothHeadset, BluetoothDevice bluetoothDevice) {
        Class<?> clazz;
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothHeadsetImpl.startScoUsingVirtualVoiceCall(bluetoothHeadset);
        }
        if (bluetoothHeadset == null) {
            return false;
        }
        try {
            clazz = bluetoothHeadset.getClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Class[] classArray = new Class[1];
        classArray[0] = BluetoothDevice.class;
        return (Boolean)clazz.getMethod("startScoUsingVirtualVoiceCall", classArray).invoke((Object)bluetoothHeadset, bluetoothDevice);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static boolean stopScoUsingVirtualVoiceCall(BluetoothHeadset bluetoothHeadset) {
        Class<?> clazz;
        if (bluetoothHeadset == null) {
            return false;
        }
        try {
            clazz = bluetoothHeadset.getClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return (Boolean)clazz.getMethod("stopScoUsingVirtualVoiceCall", new Class[0]).invoke((Object)bluetoothHeadset, new Object[0]);
    }

    public static boolean stopScoUsingVirtualVoiceCall(BluetoothHeadset bluetoothHeadset, BluetoothDevice bluetoothDevice) {
        Class<?> clazz;
        if (Build.VERSION.SDK_INT >= 28) {
            return BluetoothHeadsetImpl.stopScoUsingVirtualVoiceCall(bluetoothHeadset);
        }
        if (bluetoothHeadset == null) {
            return false;
        }
        try {
            clazz = bluetoothHeadset.getClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Class[] classArray = new Class[1];
        classArray[0] = BluetoothDevice.class;
        return (Boolean)clazz.getMethod("stopScoUsingVirtualVoiceCall", classArray).invoke((Object)bluetoothHeadset, bluetoothDevice);
    }

    public static int getBatteryLevel(String string, Object[] objectArray) {
        int n = -1;
        int n2 = -1;
        int n3 = string.hashCode();
        if (n3 != 1884621890) {
            if (n3 == 2093671693 && string.equals(VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT)) {
                n2 = 0;
            }
        } else if (string.equals(VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV)) {
            n2 = 1;
        }
        if (n2 != 0) {
            if (n2 == 1) {
                n = BluetoothHeadsetImpl.getBatteryLevelFromAppleBatteryVsc(objectArray);
            }
        } else {
            n = BluetoothHeadsetImpl.getBatteryLevelFromXEventVsc(objectArray);
        }
        return n;
    }

    public static int getBatteryLevelFromAppleBatteryVsc(Object[] object) {
        if (((Object[])object).length == 0) {
            ZLogger.w("getBatteryLevelFromAppleBatteryVsc() empty arguments");
            return -1;
        }
        if (object[0] instanceof Integer) {
            int n = (Integer)object[0];
            if (((Object[])object).length != n * 2 + 1) {
                ZLogger.w("getBatteryLevelFromAppleBatteryVsc() number of arguments does not match");
                return -1;
            }
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                int n3 = i * 2;
                Object object2 = object[n3 + 1];
                if (object2 instanceof Integer) {
                    if ((Integer)object2 != 1) {
                        continue;
                    }
                    if ((object = object[n3 + 2]) instanceof Integer) {
                        n2 = (Integer)object;
                        break;
                    }
                    ZLogger.w("getBatteryLevelFromAppleBatteryVsc() error parsing indicator value");
                    return -1;
                }
                ZLogger.w("getBatteryLevelFromAppleBatteryVsc() error parsing indicator type");
                return -1;
            }
            return n2 >= 0 && n2 <= 9 ? (n2 + 1) * 10 : -1;
        }
        ZLogger.w("getBatteryLevelFromAppleBatteryVsc() error parsing number of arguments");
        return -1;
    }

    public static int getBatteryLevelFromXEventVsc(Object[] objectArray) {
        if (objectArray.length == 0) {
            ZLogger.w("getBatteryLevelFromXEventVsc() empty arguments");
            return -1;
        }
        Object object = objectArray[0];
        if (!(object instanceof String)) {
            ZLogger.w("getBatteryLevelFromXEventVsc() error parsing event name");
            return -1;
        }
        if (!((String)(object = (String)object)).equals(VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT_BATTERY_LEVEL)) {
            ZLogger.w("getBatteryLevelFromXEventVsc() skip none BATTERY event: " + (String)object);
            return -1;
        }
        if (objectArray.length != 5) {
            ZLogger.w("getBatteryLevelFromXEventVsc() wrong battery level event length: " + String.valueOf(objectArray.length));
            return -1;
        }
        if (objectArray[1] instanceof Integer && objectArray[2] instanceof Integer) {
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray[2];
            if (n >= 0 && n2 > 1 && n <= n2) {
                return n * 100 / (n2 - 1);
            }
            ZLogger.w("getBatteryLevelFromXEventVsc() wrong event value, batteryLevel=" + String.valueOf(n) + ", numberOfLevels=" + String.valueOf(n2));
            return -1;
        }
        ZLogger.w("getBatteryLevelFromXEventVsc() error parsing event values");
        return -1;
    }
}

