/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.impl;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import androidx.annotation.RequiresPermission;
import com.realsil.sdk.core.logger.ZLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class BluetoothProfileImpl {
    public static final int HID_HOST = 4;
    public static final int PAN = 5;
    public static final int PBAP = 6;
    public static final int MAP = 9;
    public static final int A2DP_SINK = 11;
    public static final int AVRCP_CONTROLLER = 12;
    public static final int AVRCP = 13;
    public static final int HEADSET_CLIENT = 16;
    public static final int PBAP_CLIENT = 17;
    public static final int MAP_CLIENT = 18;

    public static boolean connectProfile(BluetoothProfile bluetoothProfile, BluetoothDevice bluetoothDevice) {
        if (bluetoothProfile != null && bluetoothDevice != null) {
            ZLogger.v("connectProfile :" + bluetoothDevice.getAddress());
            Class<?> clazz = bluetoothProfile.getClass();
            Class[] classArray = new Class[1];
            classArray[0] = BluetoothDevice.class;
            Method method = clazz.getMethod("connect", classArray);
            try {
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)bluetoothProfile, bluetoothDevice);
            }
            catch (IllegalAccessException illegalAccessException) {
                ZLogger.w("Could not execute method 'connect' in profile " + bluetoothProfile.getClass().getName() + ", ignoring request." + illegalAccessException.toString());
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                ZLogger.w("Could not execute method 'connect' in profile " + bluetoothProfile.getClass().getName() + ", ignoring request." + invocationTargetException.toString());
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.w("No connect method in the " + bluetoothProfile.getClass().getName() + " class, ignoring request.");
                return false;
            }
        }
        return false;
    }

    public static boolean connectProfile(BluetoothProfile bluetoothProfile, String string, BluetoothDevice bluetoothDevice) {
        if (bluetoothProfile != null && bluetoothDevice != null) {
            Class<?> clazz;
            block11: {
                BluetoothProfile bluetoothProfile2 = bluetoothProfile;
                ZLogger.v("connectProfile :" + bluetoothDevice.getAddress());
                clazz = bluetoothProfile2.getClass().asSubclass(Class.forName(string));
                if (clazz != null) break block11;
                ZLogger.w("no class found: " + string);
                return false;
            }
            Class[] classArray = new Class[1];
            classArray[0] = BluetoothDevice.class;
            Method method = clazz.getMethod("connect", classArray);
            try {
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)bluetoothProfile, bluetoothDevice);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ZLogger.w("Could not find clas: " + string + ", ignoring request." + classNotFoundException.toString());
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                ZLogger.w("Could not execute method 'connect' in profile " + string + ", ignoring request." + illegalAccessException.toString());
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                ZLogger.w("Could not execute method 'connect' in profile " + string + ", ignoring request." + invocationTargetException.toString());
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.w("No connect method in the " + string + " class, ignoring request.");
                return false;
            }
        }
        return false;
    }

    public static boolean disconnect(BluetoothProfile bluetoothProfile, BluetoothDevice bluetoothDevice) {
        if (bluetoothProfile != null && bluetoothDevice != null) {
            BluetoothProfile bluetoothProfile2 = bluetoothProfile;
            String string = "";
            string = bluetoothProfile2.getClass().getName();
            Object[] objectArray = new Object[2];
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            objectArray[0] = string;
            int n = 1;
            objectArray[n] = bluetoothDevice2.getAddress();
            ZLogger.v(String.format("disconnect : %s : %s", objectArray));
            Class<?> clazz = bluetoothProfile2.getClass();
            Class[] classArray = new Class[1];
            classArray[0] = BluetoothDevice.class;
            Method method = clazz.getMethod("disconnect", classArray);
            try {
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)bluetoothProfile, bluetoothDevice);
            }
            catch (IllegalAccessException illegalAccessException) {
                ZLogger.e("Could not execute method 'disconnect' in profile " + string + ", ignoring request." + illegalAccessException.toString());
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                ZLogger.e("Could not execute method 'disconnect' in profile " + string + ", ignoring request." + invocationTargetException.toString());
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.e("No disconnect method in the " + string + " class, ignoring request.");
                return false;
            }
        }
        return false;
    }

    public static boolean disconnect(BluetoothProfile bluetoothProfile, String string, BluetoothDevice bluetoothDevice) {
        if (bluetoothProfile != null && bluetoothDevice != null) {
            Object[] objectArray = new Object[2];
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            objectArray[0] = string;
            int n = 1;
            objectArray[n] = bluetoothDevice2.getAddress();
            ZLogger.v(String.format("disconnect : %s : %s", objectArray));
            Class<?> clazz = bluetoothProfile.getClass().asSubclass(Class.forName(string));
            Class[] classArray = new Class[1];
            classArray[0] = BluetoothDevice.class;
            Method method = clazz.getMethod("disconnect", classArray);
            try {
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)bluetoothProfile, bluetoothDevice);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ZLogger.w("Could not find clas: " + string + ", ignoring request." + classNotFoundException.toString());
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                ZLogger.e("Could not execute method 'disconnect' in profile " + string + ", ignoring request." + illegalAccessException.toString());
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                ZLogger.e("Could not execute method 'disconnect' in profile " + string + ", ignoring request." + invocationTargetException.toString());
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.e("No disconnect method in the " + string + " class, ignoring request.");
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=19)
    @RequiresPermission(value="android.permission.BLUETOOTH")
    public static int getConnectionState(BluetoothProfile bluetoothProfile, String string, BluetoothDevice bluetoothDevice) {
        void var0_4;
        block8: {
            Method method;
            Class[] classArray;
            String string2;
            Class<?> clazz;
            if (bluetoothProfile == null) return 0;
            if (bluetoothDevice == null) {
                return 0;
            }
            try {
                clazz = bluetoothProfile.getClass().asSubclass(Class.forName(string));
                string2 = "getConnectionState";
                classArray = new Class[1];
            }
            catch (ClassNotFoundException classNotFoundException) {
                ZLogger.w("Could not find clas: " + string + ", ignoring request." + classNotFoundException.toString());
                return 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                break block8;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
                break block8;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.w("No connect method in the CLASS_NAME class, ignoring request.");
                return 0;
            }
            {
                classArray[0] = BluetoothDevice.class;
                method = clazz.getMethod(string2, classArray);
            }
            {
                method.setAccessible(true);
                return (Integer)method.invoke((Object)bluetoothProfile, bluetoothDevice);
            }
        }
        ZLogger.w("Could not execute method 'connect' in profile CLASS_NAME, ignoring request." + var0_4.toString());
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BluetoothDevice> getConnectedDevices(BluetoothProfile bluetoothProfile, String string) {
        void var0_4;
        block7: {
            Method method;
            if (bluetoothProfile == null) {
                return null;
            }
            try {
                method = bluetoothProfile.getClass().asSubclass(Class.forName(string)).getMethod("getConnectedDevices", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ZLogger.w("Could not find clas: " + string + ", ignoring request." + classNotFoundException.toString());
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                break block7;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
                break block7;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ZLogger.w("No connect method in the CLASS_NAME class, ignoring request.");
                return null;
            }
            {
                method.setAccessible(true);
                return (List)method.invoke((Object)bluetoothProfile, null);
            }
        }
        ZLogger.w("Could not execute method 'connect' in profile CLASS_NAME, ignoring request." + var0_4.toString());
        return null;
    }

    public static void setPriority(BluetoothProfile bluetoothProfile, BluetoothDevice bluetoothDevice, int n) {
        if (bluetoothProfile == null) {
            return;
        }
        Class<?> clazz = bluetoothProfile.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = BluetoothDevice.class;
        classArray[1] = Integer.TYPE;
        Method method = clazz.getMethod("setPriority", classArray);
        BluetoothProfile bluetoothProfile2 = bluetoothProfile;
        Object[] objectArray = new Object[2];
        int n2 = n;
        objectArray[0] = bluetoothDevice;
        int n3 = 1;
        try {
            objectArray[n3] = n2;
            method.invoke((Object)bluetoothProfile2, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

