/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.profile;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.realsil.sdk.core.bluetooth.BluetoothHelper;
import com.realsil.sdk.core.bluetooth.impl.BluetoothProfileImpl;
import com.realsil.sdk.core.bluetooth.profile.ProfileManagerCallback;
import com.realsil.sdk.core.bluetooth.profile.PublicProfileManager;
import com.realsil.sdk.core.logger.ZLogger;

public class BluetoothA2dpManager
extends PublicProfileManager<BluetoothA2dp> {
    public static BluetoothA2dpManager h;
    public BtBroadcastReceiver f;
    public BluetoothProfile.ServiceListener g;

    public BluetoothA2dpManager(Context object) {
        IntentFilter intentFilter;
        BluetoothProfile.ServiceListener serviceListener;
        BluetoothA2dpManager bluetoothA2dpManager = this;
        super((Context)object);
        bluetoothA2dpManager.f = null;
        object = serviceListener;
        serviceListener = new BluetoothProfile.ServiceListener(){

            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                int n2 = n;
                String string = BluetoothHelper.parseProfile(n2);
                ZLogger.i(string + " profile");
                if (n2 == 2) {
                    BluetoothA2dpManager.this.setBluetoothProfile((BluetoothA2dp)bluetoothProfile);
                }
            }

            public void onServiceDisconnected(int n) {
                int n2 = n;
                String string = BluetoothHelper.parseProfile(n2);
                ZLogger.i(string + " profile");
                if (n2 == 2) {
                    BluetoothA2dpManager.this.setBluetoothProfile(null);
                }
            }
        };
        bluetoothA2dpManager.g = object;
        BluetoothAdapter bluetoothAdapter = bluetoothA2dpManager.b;
        if (bluetoothAdapter != null) {
            bluetoothAdapter.getProfileProxy(this.c, (BluetoothProfile.ServiceListener)object, 2);
        }
        this.f = new BtBroadcastReceiver();
        object = intentFilter;
        new IntentFilter().addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        object.addAction("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED");
        this.c.registerReceiver((BroadcastReceiver)this.f, (IntentFilter)object);
    }

    public static BluetoothA2dpManager getInstance() {
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial(Context context) {
        if (h != null) return;
        Class<BluetoothA2dpManager> clazz = BluetoothA2dpManager.class;
        synchronized (BluetoothA2dpManager.class) {
            if (h != null) return;
            h = new BluetoothA2dpManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void close() {
        ZLogger.d(true, "close()");
        Context context = this.c;
        if (context != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.f);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        }
    }

    public boolean a2dpSrcConnect(byte[] byArray) {
        return this.a2dpSrcConnect(BluetoothHelper.convertMac(byArray));
    }

    public boolean a2dpSrcConnect(String string) {
        BluetoothAdapter bluetoothAdapter = this.b;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            BluetoothA2dpManager bluetoothA2dpManager = this;
            bluetoothAdapter = bluetoothA2dpManager.b.getRemoteDevice(string);
            Object BP = bluetoothA2dpManager.e;
            if (BP == null) {
                ZLogger.w("A2DP not initialized");
                return false;
            }
            if (((BluetoothA2dp)BP).getConnectionState((BluetoothDevice)bluetoothAdapter) == 2) {
                ZLogger.w("a2dp already connected");
                return true;
            }
            BluetoothA2dpManager bluetoothA2dpManager2 = this;
            ZLogger.d(true, "a2dpSrcConnect: " + string);
            BluetoothProfileImpl.setPriority(bluetoothA2dpManager2.e, (BluetoothDevice)bluetoothAdapter, 100);
            return BluetoothProfileImpl.connectProfile(bluetoothA2dpManager2.e, (BluetoothDevice)bluetoothAdapter);
        }
        ZLogger.w(true, "BT not enabled");
        return false;
    }

    public boolean a2dpSrcDisconnect(byte[] byArray) {
        return this.a2dpSrcDisconnect(BluetoothHelper.convertMac(byArray));
    }

    public boolean a2dpSrcDisconnect(String string) {
        BluetoothAdapter bluetoothAdapter = this.b;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            bluetoothAdapter = this.b.getRemoteDevice(string);
            if (bluetoothAdapter == null) {
                ZLogger.w("device is null");
                return false;
            }
            Object BP = this.e;
            if (BP == null) {
                ZLogger.w("A2DP not initialized");
                return false;
            }
            if (((BluetoothA2dp)BP).getConnectionState((BluetoothDevice)bluetoothAdapter) != 2) {
                ZLogger.w("A2DP already disconnected");
                return false;
            }
            BluetoothA2dpManager bluetoothA2dpManager = this;
            ZLogger.d(true, "a2dpSrcDisconnect" + string);
            BluetoothProfileImpl.setPriority(bluetoothA2dpManager.e, (BluetoothDevice)bluetoothAdapter, 100);
            return BluetoothProfileImpl.disconnect(bluetoothA2dpManager.e, (BluetoothDevice)bluetoothAdapter);
        }
        ZLogger.w(true, "BT not enabled");
        return false;
    }

    public class BtBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int n = -1;
            int n2 = ((String)object).hashCode();
            if (n2 != -855499628) {
                if (n2 == 1244161670 && ((String)object).equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                    n = 0;
                }
            } else if (((String)object).equals("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED")) {
                n = 1;
            }
            if (n != 0) {
                if (n == 1) {
                    int n3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    int n4 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                    if (n3 == 10) {
                        ZLogger.d(true, "A2DP_PLAYING_STATE: STATE_PLAYING");
                    } else if (n3 == 11) {
                        ZLogger.d(true, "A2DP_PLAYING_STATE: STATE_NOT_PLAYING");
                    } else {
                        ZLogger.d(true, "A2DP_PLAYING_STATE: " + n4 + " > " + n3);
                    }
                }
            } else {
                int n5 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                int n6 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                if (n5 == 2) {
                    ZLogger.d(true, "A2DP_CONNECTION_STATE: STATE_CONNECTED");
                } else if (n5 == 0) {
                    ZLogger.d(true, "A2DP_CONNECTION_STATE: STATE_DISCONNECTED");
                } else if (n5 == 1) {
                    ZLogger.d(true, "A2DP_CONNECTION_STATE: STATE_CONNECTING");
                } else {
                    ZLogger.d(true, "A2DP_CONNECTION_STATE: " + n6 + " > " + n5);
                }
                Object object2 = ((BtBroadcastReceiver)((Object)object2)).BluetoothA2dpManager.this.d;
                if (object2 != null) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        ((ProfileManagerCallback)object2.next()).onConnectionStateChanged(bluetoothDevice, n5);
                    }
                }
            }
        }
    }
}

