/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.profile;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.realsil.sdk.core.bluetooth.impl.BluetoothClassImpl;
import com.realsil.sdk.core.bluetooth.profile.HideProfileManager;
import com.realsil.sdk.core.logger.ZLogger;
import java.lang.reflect.Method;

public class BluetoothInputDeviceManager
extends HideProfileManager {
    public static BluetoothInputDeviceManager m;
    public BluetoothDevice h;
    public boolean i;
    public RCUReconnectReceiver j;
    public HidConnectionCallback k;
    public BluetoothProfile.ServiceListener l;

    public BluetoothInputDeviceManager(Context context) {
        IntentFilter intentFilter;
        BluetoothProfile.ServiceListener serviceListener;
        BluetoothInputDeviceManager bluetoothInputDeviceManager = this;
        super(context);
        BluetoothProfile.ServiceListener serviceListener2 = serviceListener;
        serviceListener = new BluetoothProfile.ServiceListener(){

            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                if (4 == n) {
                    try {
                        BluetoothInputDeviceManager.this.f = bluetoothProfile.getClass().asSubclass(Class.forName("android.bluetooth.BluetoothInputDevice"));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    BluetoothInputDeviceManager.this.g = bluetoothProfile;
                    ZLogger.i("get Bluetooth input device proxy");
                }
            }

            public void onServiceDisconnected(int n) {
                if (4 == n) {
                    BluetoothInputDeviceManager bluetoothInputDeviceManager = BluetoothInputDeviceManager.this;
                    bluetoothInputDeviceManager.f = null;
                    bluetoothInputDeviceManager.g = null;
                    ZLogger.i("close Bluetooth input device proxy");
                }
            }
        };
        bluetoothInputDeviceManager.l = serviceListener2;
        BluetoothAdapter bluetoothAdapter = bluetoothInputDeviceManager.b;
        if (bluetoothAdapter != null) {
            bluetoothAdapter.getProfileProxy(context, serviceListener2, 4);
        }
        this.j = new RCUReconnectReceiver(null);
        context = intentFilter;
        new IntentFilter().addAction("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED");
        context.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.c.registerReceiver((BroadcastReceiver)this.j, (IntentFilter)context);
    }

    public static void initial(Context context) {
        ZLogger.v("initial");
        m = new BluetoothInputDeviceManager(context);
    }

    public static BluetoothInputDeviceManager getInstance() {
        return m;
    }

    public static boolean isHidDevice(BluetoothDevice bluetoothDevice) {
        return BluetoothClassImpl.isHidDevice(bluetoothDevice.getBluetoothClass());
    }

    public static /* synthetic */ HidConnectionCallback a(BluetoothInputDeviceManager bluetoothInputDeviceManager, HidConnectionCallback hidConnectionCallback) {
        bluetoothInputDeviceManager.k = hidConnectionCallback;
        return hidConnectionCallback;
    }

    public static /* synthetic */ BluetoothDevice a(BluetoothInputDeviceManager bluetoothInputDeviceManager, BluetoothDevice bluetoothDevice) {
        bluetoothInputDeviceManager.h = bluetoothDevice;
        return bluetoothDevice;
    }

    public static /* synthetic */ boolean a(BluetoothInputDeviceManager bluetoothInputDeviceManager, boolean bl) {
        bluetoothInputDeviceManager.i = bl;
        return bl;
    }

    public boolean isHidDevice(String string) {
        return BluetoothInputDeviceManager.isHidDevice(this.b.getRemoteDevice(string));
    }

    public boolean checkProfileConnect() {
        if (this.f != null) {
            return true;
        }
        ZLogger.d("checkProfileConnect(): profile not connect");
        return false;
    }

    public boolean connect(String string, HidConnectionCallback hidConnectionCallback) {
        BluetoothInputDeviceManager bluetoothInputDeviceManager = this;
        return bluetoothInputDeviceManager.a(bluetoothInputDeviceManager.b.getRemoteDevice(string), hidConnectionCallback);
    }

    public int getConnectionState(String string) {
        BluetoothInputDeviceManager bluetoothInputDeviceManager = this;
        return bluetoothInputDeviceManager.getConnectionState(bluetoothInputDeviceManager.b.getRemoteDevice(string));
    }

    public boolean isHogpConnect(String string) {
        return this.getConnectionState(string) == 2;
    }

    public boolean isHogpConnect(BluetoothDevice bluetoothDevice) {
        return this.getConnectionState(bluetoothDevice) == 2;
    }

    public void close() {
        if (this.f != null) {
            this.b.closeProfileProxy(4, this.g);
        }
        if (this.c != null && this.j != null) {
            try {
                ZLogger.d("unregisterReceiver");
                this.c.unregisterReceiver((BroadcastReceiver)this.j);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        }
        this.k = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean a(BluetoothDevice bluetoothDevice, HidConnectionCallback object) {
        ZLogger.d("connect()");
        this.k = object;
        this.h = bluetoothDevice;
        this.i = false;
        if (!this.checkProfileConnect()) {
            return false;
        }
        if (bluetoothDevice.getBondState() != 12) {
            ZLogger.i("connect with not bond device, bond first, current state: " + bluetoothDevice.getBondState());
            bluetoothDevice.createBond();
            return false;
        }
        ZLogger.d("connect with bonded device, remove bond first.");
        Class<?> clazz = bluetoothDevice.getClass();
        object = clazz.getMethod("removeBond", new Class[0]);
        if (object == null) return this.a(bluetoothDevice);
        boolean bl = (Boolean)((Method)object).invoke((Object)bluetoothDevice, new Object[0]);
        if (!bl) return this.a(bluetoothDevice);
        try {
            this.i = bl;
            ZLogger.d("removeBond(): result: " + bl);
            return bl;
        }
        catch (Exception exception) {
            ZLogger.e("removeBond(): An exception occured, e = " + exception);
        }
        return this.a(bluetoothDevice);
    }

    public final boolean a(BluetoothDevice bluetoothDevice) {
        block6: {
            Class clazz = this.f;
            Class[] classArray = new Class[1];
            classArray[0] = BluetoothDevice.class;
            Method method = clazz.getMethod("connect", classArray);
            if (method == null) break block6;
            boolean bl = (Boolean)method.invoke((Object)this.g, bluetoothDevice);
            try {
                ZLogger.d("connect(): connect result: " + bl);
                return bl;
            }
            catch (Exception exception) {
                ZLogger.e("connect(): An exception occured while connect device, e = " + exception);
            }
        }
        return false;
    }

    public static abstract class HidConnectionCallback {
        public void onConnectionStateChange(boolean bl) {
        }
    }

    public class RCUReconnectReceiver
    extends BroadcastReceiver {
        public RCUReconnectReceiver() {
        }

        public /* synthetic */ RCUReconnectReceiver(1 var2_2) {
            this();
        }

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            ZLogger.i("RCUReconnectReceiver " + (String)object);
            if ("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED".equals(object)) {
                switch (intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1)) {
                    default: {
                        break;
                    }
                    case 3: {
                        ZLogger.i(" Braodcast: RCU Disconnecting!");
                        break;
                    }
                    case 2: {
                        ZLogger.i(" Braodcast: RCU Connected!");
                        if (BluetoothInputDeviceManager.this.k != null) {
                            BluetoothInputDeviceManager.this.k.onConnectionStateChange(true);
                        }
                        RCUReconnectReceiver rCUReconnectReceiver = this;
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                        break;
                    }
                    case 1: {
                        ZLogger.i(" Braodcast: RCU Connecting!");
                        break;
                    }
                    case 0: {
                        ZLogger.i(" Braodcast: RCU Disconnected!");
                        if (BluetoothInputDeviceManager.this.k != null) {
                            BluetoothInputDeviceManager.this.k.onConnectionStateChange(false);
                        }
                        RCUReconnectReceiver rCUReconnectReceiver = this;
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                        break;
                    }
                }
            } else if ("android.bluetooth.device.action.BOND_STATE_CHANGED" == object) {
                switch (intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE)) {
                    default: {
                        break;
                    }
                    case 12: {
                        ZLogger.i(" Braodcast: RCU BONDED!");
                        if (BluetoothInputDeviceManager.this.h == null) break;
                        BluetoothInputDeviceManager bluetoothInputDeviceManager = BluetoothInputDeviceManager.this;
                        bluetoothInputDeviceManager.a(bluetoothInputDeviceManager.h);
                        break;
                    }
                    case 11: {
                        ZLogger.i(" Braodcast: RCU BONDING!");
                        break;
                    }
                    case 10: {
                        ZLogger.i(" Braodcast: RCU unpaired!");
                        if (BluetoothInputDeviceManager.this.i) {
                            RCUReconnectReceiver rCUReconnectReceiver = this;
                            BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, false);
                            rCUReconnectReceiver.BluetoothInputDeviceManager.this.h.createBond();
                            break;
                        }
                        if (BluetoothInputDeviceManager.this.k != null) {
                            BluetoothInputDeviceManager.this.k.onConnectionStateChange(false);
                        }
                        RCUReconnectReceiver rCUReconnectReceiver = this;
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                        BluetoothInputDeviceManager.a(rCUReconnectReceiver.BluetoothInputDeviceManager.this, null);
                    }
                }
            }
        }
    }
}

