/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.profile;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import com.realsil.sdk.core.bluetooth.profile.ProfileManagerCallback;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class PublicProfileManager<BP extends BluetoothProfile> {
    public BluetoothManager a;
    public BluetoothAdapter b;
    public Context c;
    public List<ProfileManagerCallback> d;
    public BP e;

    public PublicProfileManager(Context context) {
        this.c = context.getApplicationContext();
        this.initialize();
    }

    public boolean initialize() {
        if (this.a == null && (this.a = (BluetoothManager)this.c.getSystemService("bluetooth")) == null) {
            ZLogger.w("Unable to initialize BluetoothManager.");
            return false;
        }
        if (this.b == null && (this.b = this.a.getAdapter()) == null) {
            ZLogger.w("Unable to obtain a BluetoothAdapter.");
            return false;
        }
        return true;
    }

    public BP getBluetoothProfile() {
        return this.e;
    }

    public void setBluetoothProfile(BP BP) {
        this.e = BP;
    }

    public boolean isProfileSupported() {
        return this.getBluetoothProfile() != null;
    }

    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        BluetoothAdapter bluetoothAdapter = this.b;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            if (this.getBluetoothProfile() == null) {
                ZLogger.w("not supported > " + this.e.getClass().getName());
                return -1;
            }
            return this.e.getConnectionState(bluetoothDevice);
        }
        ZLogger.w("BT not enabled");
        return -1;
    }

    public void addProfileManagerCallback(ProfileManagerCallback profileManagerCallback) {
        if (this.d == null) {
            CopyOnWriteArrayList<ProfileManagerCallback> copyOnWriteArrayList;
            CopyOnWriteArrayList<ProfileManagerCallback> copyOnWriteArrayList2 = copyOnWriteArrayList;
            copyOnWriteArrayList = new CopyOnWriteArrayList<ProfileManagerCallback>();
            this.d = copyOnWriteArrayList2;
        }
        if (!this.d.contains(profileManagerCallback)) {
            this.d.add(profileManagerCallback);
        }
    }

    public void removeProfileManagerCallback(ProfileManagerCallback profileManagerCallback) {
        List<ProfileManagerCallback> list = ((PublicProfileManager)((Object)list)).d;
        if (list != null) {
            list.remove(profileManagerCallback);
        }
    }
}

