/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.scanner.ScannerParams;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.UUID;

public abstract class BaseLeScanner {
    public boolean a = RtkCore.DEBUG;
    public BluetoothAdapter b;
    public boolean c;
    public ScannerParams d;
    public RetkBleScannerListener e;

    public BaseLeScanner(Context object) {
        object = (BluetoothManager)object.getSystemService("bluetooth");
        object = object != null ? object.getAdapter() : null;
        this.b = object;
    }

    public void setBleScannerListener(RetkBleScannerListener retkBleScannerListener) {
        this.e = retkBleScannerListener;
    }

    public boolean startScan(ScannerParams scannerParams) {
        BluetoothAdapter bluetoothAdapter = this.b;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            ZLogger.v("LeScanner--startScan");
            this.notifyScanStart();
            this.c = true;
            this.d = scannerParams;
            return true;
        }
        ZLogger.w("BT Adapter is not turned ON");
        return false;
    }

    public boolean stopScan() {
        this.notifyScanStop();
        this.c = false;
        return true;
    }

    public void notifyScanStart() {
        RetkBleScannerListener retkBleScannerListener = ((BaseLeScanner)((Object)retkBleScannerListener)).e;
        if (retkBleScannerListener != null) {
            retkBleScannerListener.onLeScanStart();
        } else {
            ZLogger.v("no listeners register");
        }
    }

    public void notifyLeScan(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        RetkBleScannerListener retkBleScannerListener = ((BaseLeScanner)((Object)retkBleScannerListener)).e;
        if (retkBleScannerListener != null) {
            retkBleScannerListener.onLeScan(bluetoothDevice, n, byArray);
        } else {
            ZLogger.v("no listeners register");
        }
    }

    public void notifyScanStop() {
        RetkBleScannerListener retkBleScannerListener = ((BaseLeScanner)((Object)retkBleScannerListener)).e;
        if (retkBleScannerListener != null) {
            retkBleScannerListener.onLeScanStop();
        } else {
            ZLogger.v("no listeners register");
        }
    }

    public boolean isScanning() {
        return this.c;
    }

    public void config(UUID[] uUIDArray) {
    }

    public boolean scanLeDevice(boolean bl) {
        return this.scanLeDevice(null, bl);
    }

    public boolean scanLeDevice(ScannerParams scannerParams, boolean bl) {
        if (bl) {
            if (!this.b.isEnabled()) {
                ZLogger.d("BT Adapter is not enable");
                return false;
            }
            return this.startScan(scannerParams);
        }
        return this.stopScan();
    }

    public static interface RetkBleScannerListener {
        public void onLeScanStart();

        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);

        public void onLeScanStop();
    }
}

