/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import com.realsil.sdk.core.bluetooth.scanner.BaseLeScanner;
import com.realsil.sdk.core.bluetooth.scanner.ScannerParams;
import com.realsil.sdk.core.bluetooth.scanner.compat.CompatScanFilter;
import com.realsil.sdk.core.logger.ZLogger;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=21)
public class LeScannerV21
extends BaseLeScanner {
    public BluetoothLeScanner f;
    public ScanCallback g;

    public LeScannerV21(Context object) {
        ScanCallback scanCallback;
        LeScannerV21 leScannerV21 = this;
        super((Context)object);
        object = scanCallback;
        scanCallback = new ScanCallback(){

            public void onScanResult(int n, ScanResult scanResult) {
                1 v0 = leScannerV21;
                super.onScanResult(n, scanResult);
                Object object = v0.LeScannerV21.this.d;
                if (object != null && ((ScannerParams)object).isConnectable() && Build.VERSION.SDK_INT >= 26 && !scanResult.isConnectable()) {
                    if (leScannerV21.LeScannerV21.this.a) {
                        ZLogger.v("ignore noconnectable device >> " + scanResult.toString());
                    }
                    return;
                }
                if (leScannerV21.LeScannerV21.this.a) {
                    ZLogger.v("onScanResult 2 >> " + scanResult.toString());
                }
                object = scanResult.getScanRecord();
                ScanResult scanResult2 = scanResult;
                LeScannerV21 leScannerV21 = leScannerV21.LeScannerV21.this;
                scanResult = scanResult2.getDevice();
                int n2 = scanResult2.getRssi();
                object = object != null ? (Object)object.getBytes() : (Object)new byte[0];
                leScannerV21.notifyLeScan((BluetoothDevice)scanResult, n2, (byte[])object);
            }

            public void onBatchScanResults(List<ScanResult> list) {
                super.onBatchScanResults(list);
            }

            public void onScanFailed(int n) {
                super.onScanFailed(n);
            }
        };
        leScannerV21.g = object;
        ZLogger.v("LeScannerV21 init");
        object = leScannerV21.b;
        if (object != null) {
            this.f = object.getBluetoothLeScanner();
        }
        if (this.f == null) {
            ZLogger.w("mBluetoothLeScanner == null");
        }
    }

    @Override
    public boolean startScan(ScannerParams scannerParams) {
        ArrayList<ScanFilter> arrayList;
        if (!super.startScan(scannerParams)) {
            ZLogger.w("startScan failed");
            return false;
        }
        if (this.f == null) {
            ZLogger.d("getBluetoothLeScanner...");
            this.f = this.b.getBluetoothLeScanner();
        }
        if (this.f == null) {
            ZLogger.w("mBluetoothLeScanner is null");
            this.stopScan();
            return false;
        }
        ArrayList<ScanFilter> arrayList2 = arrayList;
        arrayList = new ArrayList<ScanFilter>();
        Object object = scannerParams.getScanFilters();
        if (object != null && object.size() > 0) {
            ZLogger.v("contains " + object.size() + " filters");
            object = object.iterator();
            while (object.hasNext()) {
                CompatScanFilter compatScanFilter;
                CompatScanFilter compatScanFilter2 = compatScanFilter = (CompatScanFilter)object.next();
                int n = compatScanFilter2.getManufacturerId();
                arrayList2.add(new ScanFilter.Builder().setServiceUuid(compatScanFilter.getServiceUuid()).setDeviceAddress(compatScanFilter.getDeviceAddress()).setDeviceName(compatScanFilter.getDeviceName()).setManufacturerData(n, compatScanFilter2.getManufacturerData()).build());
                ZLogger.v(compatScanFilter.toString());
            }
        }
        object = new ScanSettings.Builder().setScanMode(2);
        if (Build.VERSION.SDK_INT >= 26) {
            object.setPhy(scannerParams.getPhy()).setLegacy(false);
        }
        scannerParams = object.build();
        try {
            this.f.startScan(arrayList2, (ScanSettings)scannerParams, this.g);
            return true;
        }
        catch (Exception exception) {
            ZLogger.e(exception.toString());
            return false;
        }
    }

    @Override
    public boolean stopScan() {
        LeScannerV21 leScannerV21 = this;
        super.stopScan();
        BluetoothAdapter bluetoothAdapter = leScannerV21.b;
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled() && (bluetoothAdapter = this.f) != null) {
            bluetoothAdapter.stopScan(this.g);
        }
        return true;
    }
}

