/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.core.bluetooth.scanner.BaseLeScanner;
import com.realsil.sdk.core.bluetooth.scanner.ExtendedBluetoothDevice;
import com.realsil.sdk.core.bluetooth.scanner.LeScannerCompat;
import com.realsil.sdk.core.bluetooth.scanner.ScannerCallback;
import com.realsil.sdk.core.bluetooth.scanner.ScannerParams;
import com.realsil.sdk.core.logger.ZLogger;
import com.realsil.sdk.core.utility.DataConverter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class ScannerPresenter {
    public static final int STATE_IDLE = 0;
    public static final int STATE_DISCOVERY_START_PROCESS = 1;
    public static final int STATE_DISCOVERY_STARTED = 2;
    public static final int STATE_DISCOVERY_FINISHED = 3;
    public boolean a = false;
    public Context b;
    public BluetoothAdapter c;
    public LeScannerCompat d;
    public ScannerCallback e;
    public ScannerParams f;
    public int g = 0;
    public Handler h;
    public long i = 0L;
    public BaseLeScanner.RetkBleScannerListener j = new BaseLeScanner.RetkBleScannerListener(){

        @Override
        public void onLeScanStart() {
        }

        @Override
        public void onLeScan(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
            ScannerPresenter.this.a(bluetoothDevice, n, byArray);
        }

        @Override
        public void onLeScanStop() {
            ZLogger.v("onLeScanStop");
            ScannerPresenter.this.a(3);
        }
    };
    public Runnable k = new Runnable(){

        @Override
        public void run() {
            long l = Calendar.getInstance().getTimeInMillis();
            if (l < objectArray3.ScannerPresenter.this.i) {
                ScannerPresenter.a(objectArray3.ScannerPresenter.this, 0L);
            }
            if (objectArray3.ScannerPresenter.this.g == 1) {
                ZLogger.d("not receive scan response after start scan for 15000 ms, stop scan");
                objectArray3.ScannerPresenter.this.scanDevice(false);
            } else if (objectArray3.ScannerPresenter.this.g == 2) {
                if (l - objectArray3.ScannerPresenter.this.i > 15000L) {
                    Object[] objectArray = objectArray3;
                    Object[] objectArray2 = new Object[1];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = 15000L;
                    ZLogger.d(String.format(Locale.US, "exceed %d ms , no scan response received since last time", objectArray3));
                    objectArray.ScannerPresenter.this.scanDevice(false);
                } else if (objectArray3.ScannerPresenter.this.h != null) {
                    objectArray3.ScannerPresenter.this.h.removeCallbacksAndMessages((Object)objectArray3.ScannerPresenter.this.l);
                    objectArray3.ScannerPresenter.this.h.postDelayed(objectArray3.ScannerPresenter.this.l, objectArray3.ScannerPresenter.this.f.getScanPeriod());
                } else {
                    ZLogger.w("mHandler == null");
                }
            } else {
                ZLogger.v("ignore state:" + objectArray3.ScannerPresenter.this.g);
                if (objectArray3.ScannerPresenter.this.h != null) {
                    objectArray3.ScannerPresenter.this.h.removeCallbacksAndMessages((Object)objectArray3.ScannerPresenter.this.l);
                    objectArray3.ScannerPresenter.this.h.postDelayed(objectArray3.ScannerPresenter.this.l, objectArray3.ScannerPresenter.this.f.getScanPeriod());
                } else {
                    ZLogger.w("mHandler == null");
                }
            }
        }
    };
    public Runnable l = new Runnable(){

        @Override
        public void run() {
            ZLogger.v("le delay time reached");
            ScannerPresenter.this.scanDevice(false);
        }
    };
    public final BroadcastReceiver m = new BroadcastReceiver(){

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            if (!("android.bluetooth.device.action.FOUND".equals(object) || "android.bluetooth.device.action.CLASS_CHANGED".equals(object) || "android.bluetooth.device.action.NAME_CHANGED".equals(object))) {
                if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(object)) {
                    ScannerPresenter.this.a(2);
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(object)) {
                    ScannerPresenter.this.a(3);
                } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(object)) {
                    int n = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                    int n2 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = object;
                    objectArray2[1] = n2;
                    objectArray[2] = n;
                    ZLogger.d(String.format(Locale.US, "[%s] %d -> %d", objectArray2));
                    if (n == 10 && ScannerPresenter.this.isScanning()) {
                        Runnable runnable;
                        object = runnable;
                        runnable = new Runnable(){

                            @Override
                            public void run() {
                                ScannerPresenter.this.scanDevice(false);
                            }
                        };
                        new Thread((Runnable)object).start();
                    }
                }
            } else {
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                short s = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)0);
                if (bluetoothDevice != null) {
                    Object[] objectArray = new Object[3];
                    Object[] objectArray3 = objectArray;
                    objectArray3[0] = object;
                    objectArray3[1] = bluetoothDevice.getName();
                    objectArray[2] = bluetoothDevice.toString();
                    ZLogger.d(String.format("%s %s/%s", objectArray3));
                } else {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray4 = objectArray;
                    objectArray[0] = object;
                    ZLogger.d(String.format("%s", objectArray4));
                }
                ScannerPresenter.this.a(bluetoothDevice, s, null);
            }
        }
    };
    public Runnable n = new Runnable(){

        @Override
        public void run() {
            if (ScannerPresenter.this.e != null) {
                ScannerPresenter.this.e.onAutoScanTrigger();
            } else {
                ZLogger.w("no callback registed");
            }
            ScannerPresenter.this.scanDevice(true);
        }
    };

    public ScannerPresenter(Context context, ScannerParams scannerParams, ScannerCallback scannerCallback) {
        this(context, null, scannerParams, scannerCallback);
    }

    public ScannerPresenter(Context object, Handler handler, ScannerParams scannerParams, ScannerCallback scannerCallback) {
        this.a = RtkCore.DEBUG;
        this.b = object.getApplicationContext();
        if (handler == null) {
            HandlerThread handlerThread;
            object = handlerThread;
            new HandlerThread("ScannerPresenter").start();
            this.h = new Handler(object.getLooper());
        } else {
            this.h = handler;
        }
        ScannerPresenter scannerPresenter = this;
        scannerPresenter.f = scannerParams;
        scannerPresenter.e = scannerCallback;
        if (scannerCallback == null) {
            ZLogger.w("callback is null");
        }
        if (this.f == null) {
            ScannerParams scannerParams2;
            ZLogger.d("create new ScannerParams");
            object = scannerParams2;
            scannerParams2 = new ScannerParams();
            this.f = object;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            object = (BluetoothManager)this.b.getSystemService("bluetooth");
            if (object != null) {
                this.c = object.getAdapter();
            }
        } else {
            this.c = BluetoothAdapter.getDefaultAdapter();
        }
        this.d = new LeScannerCompat(this.b);
    }

    public ScannerPresenter(Context context) {
        this(context, null, null);
    }

    public static /* synthetic */ long a(ScannerPresenter scannerPresenter, long l) {
        scannerPresenter.i = l;
        return l;
    }

    public void init() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2;
        if (this.c == null) {
            if (Build.VERSION.SDK_INT >= 18) {
                intentFilter2 = (BluetoothManager)this.b.getSystemService("bluetooth");
                if (intentFilter2 != null) {
                    this.c = intentFilter2.getAdapter();
                }
            } else {
                this.c = BluetoothAdapter.getDefaultAdapter();
            }
        }
        intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        if (this.f.getScanMode() == 0 || this.f.getScanMode() == 32 || this.f.getScanMode() == 33) {
            IntentFilter intentFilter3 = intentFilter2;
            intentFilter3.addAction("android.bluetooth.device.action.FOUND");
            intentFilter3.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            intentFilter3.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            intentFilter3.addAction("android.bluetooth.device.action.NAME_CHANGED");
        }
        ScannerPresenter scannerPresenter = this;
        scannerPresenter.b.registerReceiver(this.m, intentFilter2);
        if (scannerPresenter.e == null) {
            ZLogger.w("callback is null");
        }
    }

    public void onDestroy() {
        Context context = this.b;
        if (context != null) {
            try {
                context.unregisterReceiver(this.m);
            }
            catch (Exception exception) {
                ZLogger.e(exception.toString());
            }
        }
        if ((context = this.h) != null) {
            ScannerPresenter scannerPresenter = this;
            context.removeCallbacks(this.l);
            scannerPresenter.h.removeCallbacks(this.n);
            scannerPresenter.h.removeCallbacks(this.k);
        }
        this.scanDevice(false);
    }

    public void setScannerCallback(ScannerCallback scannerCallback) {
        this.e = scannerCallback;
        if (scannerCallback == null) {
            ZLogger.w("callback is null");
        }
    }

    public void setScannerParams(ScannerParams scannerParams) {
        this.f = scannerParams;
    }

    public void setScanMode(int n) {
        this.f.setScanMode(n);
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.c;
    }

    public boolean isBluetoothSupported() {
        return this.c != null;
    }

    public boolean isBluetoothEnabled() {
        ScannerPresenter scannerPresenter = scannerPresenter.c;
        return scannerPresenter != null && scannerPresenter.isEnabled();
    }

    public int getState() {
        return this.g;
    }

    public boolean isScanning() {
        int n = this.g;
        return n == 2 || n == 1;
    }

    public boolean isAutoDiscovery() {
        return this.f.isAutoDiscovery();
    }

    public List<ExtendedBluetoothDevice> getPairedDevices() {
        ArrayList<ExtendedBluetoothDevice> arrayList;
        if (this.c == null) {
            return null;
        }
        if (!this.f.isReusePaiedDeviceEnabled()) {
            ZLogger.w("don't reuse paired device");
            return null;
        }
        ArrayList<ExtendedBluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<ExtendedBluetoothDevice>();
        for (BluetoothDevice bluetoothDevice : this.c.getBondedDevices()) {
            if (!this.a(bluetoothDevice)) continue;
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            String string = bluetoothDevice2.getName();
            int n = -1000;
            boolean bl = bluetoothDevice2.getBondState() == 12;
            ExtendedBluetoothDevice extendedBluetoothDevice = new ExtendedBluetoothDevice(bluetoothDevice, string, n, bl, false);
            arrayList2.add(extendedBluetoothDevice);
        }
        return arrayList2;
    }

    public synchronized boolean scanDevice(boolean bl) {
        return this.scanDevice(bl, false);
    }

    public synchronized boolean scanDevice(boolean n, boolean bl) {
        block26: {
            block23: {
                block25: {
                    block21: {
                        block22: {
                            block24: {
                                if (n == 0) break block21;
                                n = objectArray3.g;
                                if (n == 1 || n == 2) break block22;
                                objectArray3.a(1);
                                objectArray3.h.removeCallbacks(objectArray3.l);
                                objectArray3.h.removeCallbacks(objectArray3.k);
                                objectArray3.i = 0L;
                                if (objectArray3.f.getScanMode() == 0 || objectArray3.f.getScanMode() == 32 || objectArray3.f.getScanMode() == 33) {
                                    if (objectArray3.c.isDiscovering()) {
                                        objectArray3.c.cancelDiscovery();
                                    }
                                    ZLogger.v("startDiscovery for " + objectArray3.f.getScanPeriod() + "ms");
                                    if (!objectArray3.c.startDiscovery()) {
                                        objectArray3.scanDevice(false);
                                        return false;
                                    }
                                    Handler handler = objectArray3.h;
                                    if (handler != null) {
                                        handler.postDelayed(objectArray3.k, 15000L);
                                    } else {
                                        ZLogger.w("mHandler == null");
                                    }
                                }
                                if (objectArray3.f.getScanMode() != 0 && objectArray3.f.getScanMode() != 17 && objectArray3.f.getScanMode() != 18) break block23;
                                if (objectArray3.d == null) break block24;
                                ZLogger.v("start le scan for " + objectArray3.f.getScanPeriod() + "ms");
                                objectArray3.d.setBleScannerListener(objectArray3.j);
                                if (!objectArray3.d.scanLeDevice(objectArray3.f, true)) {
                                    objectArray3.scanDevice(false);
                                    return false;
                                }
                                Handler handler = objectArray3.h;
                                if (handler != null) {
                                    handler.postDelayed(objectArray3.k, 15000L);
                                } else {
                                    ZLogger.w("mHandler == null");
                                }
                                break block23;
                            }
                            ZLogger.w("mRetkLeScannerCompat is null");
                            objectArray3.scanDevice(false);
                            return false;
                        }
                        long l = Calendar.getInstance().getTimeInMillis();
                        if (l < objectArray3.i) {
                            objectArray3.i = 0L;
                        }
                        if (l - objectArray3.i > 15000L) {
                            Object[] objectArray = objectArray3;
                            Object[] objectArray2 = new Object[1];
                            Object[] objectArray3 = objectArray2;
                            objectArray2[0] = 15000L;
                            ZLogger.d(String.format(Locale.US, "exceed %d ms , no scan response received since last time", objectArray3));
                            objectArray.scanDevice(false);
                        } else if (objectArray3.h != null) {
                            ZLogger.d("wait to check state:" + objectArray3.g);
                            objectArray3.h.removeCallbacks(objectArray3.k);
                            objectArray3.h.postDelayed(objectArray3.k, 15000L);
                        } else {
                            ZLogger.w("mHandler == null");
                        }
                        return true;
                    }
                    n = objectArray3.g;
                    if (n != 0 && n != 3) break block25;
                    ZLogger.d("mState == STATE_DISCOVERY_FINISHED | STATE_IDLE");
                    if (!bl) break block26;
                    ZLogger.v("force to stop scan");
                }
                if ((objectArray3.f.getScanMode() == 0 || objectArray3.f.getScanMode() == 32 || objectArray3.f.getScanMode() == 33) && objectArray3.c.isDiscovering()) {
                    ZLogger.v("cancelDiscovery");
                    objectArray3.c.cancelDiscovery();
                }
                if (objectArray3.f.getScanMode() == 0 || objectArray3.f.getScanMode() == 17 || objectArray3.f.getScanMode() == 18) {
                    objectArray3.h.removeCallbacks(objectArray3.l);
                    if (objectArray3.d != null) {
                        ZLogger.v("stop the le scan");
                        objectArray3.d.setBleScannerListener(null);
                        if (!objectArray3.d.scanLeDevice(false)) {
                            ZLogger.w("scanLeDevice failed");
                            return false;
                        }
                    } else {
                        ZLogger.w("mRetkLeScannerCompat is null");
                    }
                }
                objectArray3.a(0);
            }
            return true;
        }
        return true;
    }

    public final boolean a(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return false;
        }
        if (this.f.getScanMode() == 18 ? Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 2 : this.f.getScanMode() == 33 && Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 1) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.f.getNameFilter())) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (!Objects.equals(this.f.getNameFilter(), bluetoothDevice.getName())) {
                    ZLogger.v("name not match:" + bluetoothDevice.getName());
                    return false;
                }
            } else if (!DataConverter.equals(this.f.getNameFilter(), bluetoothDevice.getName())) {
                ZLogger.v("name not match:" + bluetoothDevice.getName());
                return false;
            }
        } else if (TextUtils.isEmpty((CharSequence)bluetoothDevice.getName()) && !this.f.isNameNullable()) {
            if (this.a) {
                ZLogger.v("name is null, ignore");
            }
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.f.getAddressFilter())) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (!Objects.equals(this.f.getAddressFilter(), bluetoothDevice.getAddress())) {
                    ZLogger.v(this.a, "address not match:" + bluetoothDevice.getAddress());
                    return false;
                }
            } else if (!DataConverter.equals(this.f.getAddressFilter(), bluetoothDevice.getAddress())) {
                ZLogger.v(this.a, "address not match:" + bluetoothDevice.getAddress());
                return false;
            }
        }
        return true;
    }

    public final boolean a(BluetoothDevice bluetoothDevice, int n) {
        Object[] objectArray;
        if (bluetoothDevice == null) {
            ZLogger.w("filter, device is null");
            return false;
        }
        if (objectArray.f.getRssiFilter() > -1000 && objectArray.f.getRssiFilter() > n) {
            ZLogger.w("filter, low rssi:" + n);
            return false;
        }
        if (objectArray.f.getScanMode() == 18) {
            if (Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 2) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray2[0] = bluetoothDevice.getType();
                objectArray2[1] = 2;
                ZLogger.d(String.format(Locale.US, "filter, invalid type: %d, expect type is %d", objectArray));
                return false;
            }
        } else if (objectArray.f.getScanMode() == 17) {
            if (Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 2 && bluetoothDevice.getType() != 3 && bluetoothDevice.getType() != 0) {
                Object[] objectArray3 = new Object[4];
                objectArray = objectArray3;
                objectArray3[0] = bluetoothDevice.getType();
                objectArray3[1] = 0;
                objectArray3[2] = 2;
                objectArray3[3] = 3;
                ZLogger.d(String.format(Locale.US, "filter, invalid type: %d, expect type is %d/%d/%d", objectArray));
                return false;
            }
        } else if (objectArray.f.getScanMode() == 33) {
            if (Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 1) {
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray4[0] = bluetoothDevice.getType();
                objectArray4[1] = 1;
                ZLogger.d(String.format(Locale.US, "filter, invalid type: %d, expect type is %d", objectArray));
                return false;
            }
        } else if (objectArray.f.getScanMode() == 32 && Build.VERSION.SDK_INT >= 18 && bluetoothDevice.getType() != 1 && bluetoothDevice.getType() != 3 && bluetoothDevice.getType() != 0) {
            Object[] objectArray5 = new Object[4];
            objectArray = objectArray5;
            objectArray5[0] = bluetoothDevice.getType();
            objectArray5[1] = 0;
            objectArray5[2] = 1;
            objectArray5[3] = 3;
            ZLogger.d(String.format(Locale.US, "filter, invalid type: %d, expect type is %d/%d/%d", objectArray));
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)bluetoothDevice.getName())) {
            if (!objectArray.f.isNameNullable()) {
                if (objectArray.a) {
                    ZLogger.v("name is null, ignore");
                }
                return false;
            }
        } else if (!TextUtils.isEmpty((CharSequence)objectArray.f.getNameFilter()) && !DataConverter.equals(objectArray.f.getNameFilter(), bluetoothDevice.getName())) {
            ZLogger.v(objectArray.a, "name not match:" + bluetoothDevice.getName());
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)objectArray.f.getAddressFilter()) && !DataConverter.equals(objectArray.f.getAddressFilter(), bluetoothDevice.getAddress())) {
            ZLogger.v(objectArray.a, "address not match:" + bluetoothDevice.getAddress());
            return false;
        }
        return true;
    }

    public final void a(BluetoothDevice object, int n, byte[] byArray) {
        block10: {
            block9: {
                int n2;
                block8: {
                    this.i = Calendar.getInstance().getTimeInMillis();
                    n2 = this.g;
                    if (n2 != 1) break block8;
                    this.a(2);
                    break block9;
                }
                if (n2 != 2) break block10;
            }
            if (object == null) {
                ZLogger.w("ignore, device is null");
                return;
            }
            if (!this.a((BluetoothDevice)object, n)) {
                return;
            }
            BluetoothDevice bluetoothDevice = object;
            String string = bluetoothDevice.getName();
            boolean bl = bluetoothDevice.getBondState() == 12;
            ExtendedBluetoothDevice extendedBluetoothDevice = new ExtendedBluetoothDevice((BluetoothDevice)object, string, n, bl, false, byArray);
            object = this.e;
            if (object != null) {
                ((ScannerCallback)object).onNewDevice(extendedBluetoothDevice);
            } else {
                ZLogger.w("no callback registed");
            }
            if (this.f.getScanMechanism() == 1) {
                ZLogger.d("SCAN_MECHANISM_FILTER_ONE > scanDevice(false)");
                this.scanDevice(false);
            }
            return;
        }
        ZLogger.w("ignore, mState =" + this.g);
        this.scanDevice(false);
    }

    public final void a(int n) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = this.g;
        objectArray[1] = n;
        ZLogger.v(String.format(Locale.US, "ScanState 0x%02X >> 0x%02X", (Object[])object));
        this.g = n;
        object = this.e;
        if (object != null) {
            ((ScannerCallback)object).onScanStateChanged(n);
        } else {
            ZLogger.w("no callback registed");
        }
        n = this.g;
        if (n == 0 || n == 3) {
            ScannerPresenter scannerPresenter = this;
            scannerPresenter.h.removeCallbacks(this.l);
            scannerPresenter.h.removeCallbacks(this.k);
            scannerPresenter.h.removeCallbacks(this.n);
            if (scannerPresenter.isAutoDiscovery()) {
                ZLogger.d("wait to start auto scan");
                this.h.postDelayed(this.n, this.f.getAutoScanDelay());
            }
        }
    }
}

