/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner;

import android.bluetooth.BluetoothAdapter;
import android.util.SparseArray;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SpecBluetoothLeUtils {
    public static String toString(SparseArray<byte[]> sparseArray) {
        StringBuilder stringBuilder;
        if (sparseArray == null) {
            return "null";
        }
        if (sparseArray.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append('{');
        for (int i = 0; i < sparseArray.size(); ++i) {
            stringBuilder2.append(sparseArray.keyAt(i)).append("=").append(Arrays.toString((byte[])sparseArray.valueAt(i)));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append('}');
        return stringBuilder3.toString();
    }

    public static <T> String toString(Map<T, byte[]> map) {
        StringBuilder stringBuilder;
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append('{');
        Iterator<Map.Entry<T, byte[]>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            T t = iterator.next().getKey();
            stringBuilder2.append(t).append("=").append(Arrays.toString(map.get(t)));
            if (!iterator.hasNext()) continue;
            stringBuilder2.append(", ");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append('}');
        return stringBuilder3.toString();
    }

    public static boolean equals(SparseArray<byte[]> sparseArray, SparseArray<byte[]> sparseArray2) {
        if (sparseArray == sparseArray2) {
            return true;
        }
        if (sparseArray != null && sparseArray2 != null) {
            if (sparseArray.size() != sparseArray2.size()) {
                return false;
            }
            for (int i = 0; i < sparseArray.size(); ++i) {
                if (sparseArray.keyAt(i) == sparseArray2.keyAt(i) && Arrays.equals((byte[])sparseArray.valueAt(i), (byte[])sparseArray2.valueAt(i))) {
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> boolean equals(Map<T, byte[]> map, Map<T, byte[]> map2) {
        if (map == map2) {
            return true;
        }
        if (map != null && map2 != null) {
            if (map.size() != map2.size()) {
                return false;
            }
            Set<T> set = map.keySet();
            if (!set.equals(map2.keySet())) {
                return false;
            }
            for (Object e : set) {
                if (Objects.deepEquals(map.get(e), map2.get(e))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void checkAdapterStateOn(BluetoothAdapter bluetoothAdapter) {
        if (bluetoothAdapter != null && bluetoothAdapter.getState() == 12) {
            return;
        }
        throw new IllegalStateException("BT Adapter is not turned ON");
    }
}

