/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner.compat;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.IntFunction;

public final class BitUtils {
    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkArgument(boolean bl, @NonNull Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static boolean maskedEquals(long l, long l2, long l3) {
        return (l & l3) == (l2 & l3);
    }

    public static boolean maskedEquals(byte by, byte by2, byte by3) {
        return (by & by3) == (by2 & by3);
    }

    public static boolean maskedEquals(byte[] byArray, byte[] byArray2, @Nullable byte[] byArray3) {
        if (byArray != null && byArray2 != null) {
            BitUtils.checkArgument(byArray.length == byArray2.length, "Inputs must be of same size");
            if (byArray3 == null) {
                return Arrays.equals(byArray, byArray2);
            }
            BitUtils.checkArgument(byArray.length == byArray3.length, "Mask must be of same size as inputs");
            for (int i = 0; i < byArray3.length; ++i) {
                byte by = byArray2[i];
                if (BitUtils.maskedEquals(byArray[i], by, byArray3[i])) continue;
                return false;
            }
            return true;
        }
        return byArray == byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean maskedEquals(UUID uUID, UUID uUID2, @Nullable UUID uUID3) {
        if (uUID3 == null) {
            return Objects.equals(uUID, uUID2);
        }
        long l = uUID2.getLeastSignificantBits();
        long l2 = uUID3.getLeastSignificantBits();
        if (!BitUtils.maskedEquals(uUID.getLeastSignificantBits(), l, l2)) return false;
        long l3 = uUID2.getMostSignificantBits();
        l = uUID3.getMostSignificantBits();
        if (!BitUtils.maskedEquals(uUID.getMostSignificantBits(), l3, l)) return false;
        return true;
    }

    public static int[] unpackBits(long l) {
        int[] nArray = new int[Long.bitCount(l)];
        int n = 0;
        int n2 = 0;
        while (l > 0L) {
            int n3;
            if ((l & 1L) == 1L) {
                n3 = n + 1;
                nArray[n] = n2;
            } else {
                n3 = n;
            }
            l >>= 1;
            ++n2;
            n = n3;
        }
        return nArray;
    }

    public static long packBits(int[] nArray) {
        long l = 0L;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            l |= (long)(1 << nArray[i]);
        }
        return l;
    }

    public static int uint8(byte by) {
        return by & 0xFF;
    }

    public static int uint16(short s) {
        return s & 0xFFFF;
    }

    public static int uint16(byte by, byte by2) {
        return (by & 0xFF) << 8 | by2 & 0xFF;
    }

    public static long uint32(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int bytesToBEInt(byte[] byArray) {
        return (BitUtils.uint8(byArray[0]) << 24) + (BitUtils.uint8(byArray[1]) << 16) + (BitUtils.uint8(byArray[2]) << 8) + BitUtils.uint8(byArray[3]);
    }

    public static int bytesToLEInt(byte[] byArray) {
        return Integer.reverseBytes(BitUtils.bytesToBEInt(byArray));
    }

    public static int getUint8(ByteBuffer byteBuffer, int n) {
        return BitUtils.uint8(byteBuffer.get(n));
    }

    public static int getUint16(ByteBuffer byteBuffer, int n) {
        return BitUtils.uint16(byteBuffer.getShort(n));
    }

    public static long getUint32(ByteBuffer byteBuffer, int n) {
        return BitUtils.uint32(byteBuffer.getInt(n));
    }

    public static void put(ByteBuffer byteBuffer, int n, byte[] byArray) {
        ByteBuffer byteBuffer2 = byteBuffer;
        int n2 = byteBuffer2.position();
        byteBuffer2.position(n);
        byteBuffer2.put(byArray);
        byteBuffer2.position(n2);
    }

    public static boolean isBitSet(long l, int n) {
        return (l & BitUtils.bitAt(n)) != 0L;
    }

    public static long bitAt(int n) {
        return 1L << n;
    }

    public static String flagsToString(int n, IntFunction<String> intFunction) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n != 0) {
            int n3 = n;
            n = 1 << Integer.numberOfTrailingZeros(n3);
            int n4 = n3 & ~n;
            if (n2 > 0) {
                stringBuilder2.append(", ");
            }
            if (Build.VERSION.SDK_INT >= 24) {
                stringBuilder2.append(intFunction.apply(n));
            }
            ++n2;
            n = n4;
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        BitUtils.wrap(stringBuilder3, "[", "]");
        return stringBuilder3.toString();
    }

    public static void wrap(StringBuilder stringBuilder, String string, String string2) {
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(0, string);
        stringBuilder2.append(string2);
    }
}

