/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.bluetooth.scanner.compat;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanResult;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.realsil.sdk.core.bluetooth.scanner.compat.BitUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class CompatScanFilter
implements Parcelable {
    public static final CompatScanFilter EMPTY = new Builder().build();
    public static final Parcelable.Creator<CompatScanFilter> CREATOR = new Parcelable.Creator<CompatScanFilter>(){

        public CompatScanFilter[] newArray(int n) {
            return new CompatScanFilter[n];
        }

        public CompatScanFilter createFromParcel(Parcel object) {
            byte[] byArray;
            Object object2;
            Builder builder;
            Builder builder2 = builder;
            builder = new Builder();
            if (object.readInt() == 1) {
                builder2.setDeviceName(object.readString());
            }
            if (object.readInt() == 1) {
                builder2.setDeviceAddress(object.readString());
            }
            if (object.readInt() == 1) {
                object2 = (ParcelUuid)object.readParcelable(ParcelUuid.class.getClassLoader());
                builder2.setServiceUuid((ParcelUuid)object2);
                if (object.readInt() == 1) {
                    builder2.setServiceUuid((ParcelUuid)object2, (ParcelUuid)object.readParcelable(ParcelUuid.class.getClassLoader()));
                }
            }
            if (object.readInt() == 1) {
                Parcel parcel = object;
                object2 = (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader());
                if (parcel.readInt() == 1) {
                    Parcel parcel2 = object;
                    byArray = new byte[parcel2.readInt()];
                    parcel2.readByteArray(byArray);
                    if (parcel2.readInt() == 0) {
                        builder2.setServiceData((ParcelUuid)object2, byArray);
                    } else {
                        ParcelUuid parcelUuid = object2;
                        Parcel parcel3 = object;
                        byte[] byArray2 = new byte[parcel3.readInt()];
                        object2 = byArray2;
                        parcel3.readByteArray(byArray2);
                        builder2.setServiceData(parcelUuid, byArray, (byte[])object2);
                    }
                }
            }
            Parcel parcel = object;
            int n = parcel.readInt();
            if (parcel.readInt() == 1) {
                Parcel parcel4 = object;
                byArray = new byte[parcel4.readInt()];
                parcel4.readByteArray(byArray);
                if (parcel4.readInt() == 0) {
                    builder2.setManufacturerData(n, byArray);
                } else {
                    Parcel parcel5 = object;
                    byte[] byArray3 = new byte[parcel5.readInt()];
                    object = byArray3;
                    parcel5.readByteArray(byArray3);
                    builder2.setManufacturerData(n, byArray, (byte[])object);
                }
            }
            return builder2.build();
        }
    };
    @Nullable
    public final String a;
    @Nullable
    public final String b;
    @Nullable
    public final ParcelUuid c;
    @Nullable
    public final ParcelUuid d;
    @Nullable
    public final ParcelUuid e;
    @Nullable
    public final byte[] f;
    @Nullable
    public final byte[] g;
    public final int h;
    @Nullable
    public final byte[] i;
    @Nullable
    public final byte[] j;

    public CompatScanFilter(String string, String string2, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        this.a = string;
        this.c = parcelUuid;
        this.d = parcelUuid2;
        this.b = string2;
        this.e = parcelUuid3;
        this.f = byArray;
        this.g = byArray2;
        this.h = n;
        this.i = byArray3;
        this.j = byArray4;
    }

    public static boolean matchesServiceUuids(ParcelUuid parcelUuid, ParcelUuid parcelUuid2, List<ParcelUuid> object) {
        if (parcelUuid == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ParcelUuid parcelUuid3 = (ParcelUuid)object.next();
            UUID uUID = parcelUuid2 == null ? null : parcelUuid2.getUuid();
            if (!CompatScanFilter.a(parcelUuid.getUuid(), uUID, parcelUuid3.getUuid())) continue;
            return true;
        }
        return false;
    }

    public static boolean a(UUID uUID, UUID uUID2, UUID uUID3) {
        return BitUtils.maskedEquals(uUID3, uUID, uUID2);
    }

    public static boolean matchesPartialData(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray3 != null && byArray3.length >= byArray.length) {
            if (byArray2 == null) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray3[i] == byArray[i]) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray2[i] & byArray3[i]) == (byArray2[i] & byArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public /* synthetic */ CompatScanFilter(String string, String string2, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, 1 var11_11) {
        this(string, string2, parcelUuid, parcelUuid2, parcelUuid3, byArray, byArray2, n, byArray3, byArray4);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.a == null ? 0 : 1;
        parcel.writeInt(n2);
        String string = this.a;
        if (string != null) {
            parcel.writeString(string);
        }
        int n3 = this.b == null ? 0 : 1;
        parcel.writeInt(n3);
        String string2 = this.b;
        if (string2 != null) {
            parcel.writeString(string2);
        }
        int n4 = this.c == null ? 0 : 1;
        parcel.writeInt(n4);
        ParcelUuid parcelUuid = this.c;
        if (parcelUuid != null) {
            parcel.writeParcelable((Parcelable)parcelUuid, n);
            int n5 = this.d == null ? 0 : 1;
            parcel.writeInt(n5);
            parcelUuid = this.d;
            if (parcelUuid != null) {
                parcel.writeParcelable((Parcelable)parcelUuid, n);
            }
        }
        int n6 = this.e == null ? 0 : 1;
        parcel.writeInt(n6);
        ParcelUuid parcelUuid2 = this.e;
        if (parcelUuid2 != null) {
            parcel.writeParcelable((Parcelable)parcelUuid2, n);
            n = this.f == null ? 0 : 1;
            parcel.writeInt(n);
            byte[] byArray = this.f;
            if (this.f != null) {
                parcel.writeInt(byArray.length);
                parcel.writeByteArray(this.f);
                int n7 = this.g == null ? 0 : 1;
                parcel.writeInt(n7);
                byte[] byArray2 = this.g;
                if (this.g != null) {
                    parcel.writeInt(byArray2.length);
                    parcel.writeByteArray(this.g);
                }
            }
        }
        parcel.writeInt(this.h);
        n = this.i == null ? 0 : 1;
        parcel.writeInt(n);
        byte[] byArray = this.i;
        if (this.i != null) {
            parcel.writeInt(byArray.length);
            parcel.writeByteArray(this.i);
            int n8 = this.j == null ? 0 : 1;
            parcel.writeInt(n8);
            byte[] byArray3 = this.j;
            if (this.j != null) {
                parcel.writeInt(byArray3.length);
                parcel.writeByteArray(this.j);
            }
        }
    }

    @Nullable
    public String getDeviceName() {
        return this.a;
    }

    @Nullable
    public ParcelUuid getServiceUuid() {
        return this.c;
    }

    @Nullable
    public ParcelUuid getServiceUuidMask() {
        return this.d;
    }

    @Nullable
    public String getDeviceAddress() {
        return this.b;
    }

    @Nullable
    public byte[] getServiceData() {
        return this.f;
    }

    @Nullable
    public byte[] getServiceDataMask() {
        return this.g;
    }

    @Nullable
    public ParcelUuid getServiceDataUuid() {
        return this.e;
    }

    public int getManufacturerId() {
        return this.h;
    }

    @Nullable
    public byte[] getManufacturerData() {
        return this.i;
    }

    @Nullable
    public byte[] getManufacturerDataMask() {
        return this.j;
    }

    @RequiresApi(api=21)
    public boolean matches(ScanResult scanResult) {
        if (scanResult == null) {
            return false;
        }
        Object object = scanResult.getDevice();
        String string = ((CompatScanFilter)this).b;
        if (!(string == null || object != null && string.equals(object.getAddress()))) {
            return false;
        }
        if ((scanResult = scanResult.getScanRecord()) == null && (((CompatScanFilter)this).a != null || ((CompatScanFilter)this).c != null || ((CompatScanFilter)this).i != null || ((CompatScanFilter)this).f != null)) {
            return false;
        }
        object = ((CompatScanFilter)this).a;
        if (object != null && !object.equals(scanResult.getDeviceName())) {
            return false;
        }
        object = ((CompatScanFilter)this).c;
        if (object != null && !CompatScanFilter.matchesServiceUuids((ParcelUuid)object, (ParcelUuid)(object = ((CompatScanFilter)this).d), scanResult.getServiceUuids())) {
            return false;
        }
        object = ((CompatScanFilter)this).e;
        if (object != null && !CompatScanFilter.matchesPartialData(((CompatScanFilter)this).f, (byte[])(object = (Object)((CompatScanFilter)this).g), scanResult.getServiceData((ParcelUuid)object))) {
            return false;
        }
        int n = ((CompatScanFilter)this).h;
        return n < 0 || CompatScanFilter.matchesPartialData(((CompatScanFilter)this).i, (byte[])(this = (Object)((CompatScanFilter)this).j), scanResult.getManufacturerSpecificData(n));
    }

    public String toString() {
        return "BluetoothLeScanFilter [mDeviceName=" + this.a + ", mDeviceAddress=" + this.b + ", mUuid=" + this.c + ", mUuidMask=" + this.d + ", mServiceDataUuid=" + Objects.toString(this.e) + ", mServiceData=" + Arrays.toString(this.f) + ", mServiceDataMask=" + Arrays.toString(this.g) + ", mManufacturerId=" + this.h + ", mManufacturerData=" + Arrays.toString(this.i) + ", mManufacturerDataMask=" + Arrays.toString(this.j) + "]";
    }

    public int hashCode() {
        Object[] objectArray = new Object[10];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.a;
        objectArray2[1] = this.b;
        objectArray2[2] = this.h;
        objectArray2[3] = Arrays.hashCode(this.i);
        objectArray2[4] = Arrays.hashCode(this.j);
        objectArray2[5] = this.e;
        objectArray2[6] = Arrays.hashCode(this.f);
        objectArray2[7] = Arrays.hashCode(this.g);
        objectArray2[8] = this.c;
        objectArray[9] = this.d;
        return Objects.hash(objectArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && CompatScanFilter.class == object.getClass()) {
            object = (CompatScanFilter)object;
            return Objects.equals(this.a, ((CompatScanFilter)object).a) && Objects.equals(this.b, ((CompatScanFilter)object).b) && this.h == ((CompatScanFilter)object).h && Objects.deepEquals(this.i, ((CompatScanFilter)object).i) && Objects.deepEquals(this.j, ((CompatScanFilter)object).j) && Objects.equals(this.e, ((CompatScanFilter)object).e) && Objects.deepEquals(this.f, ((CompatScanFilter)object).f) && Objects.deepEquals(this.g, ((CompatScanFilter)object).g) && Objects.equals(this.c, ((CompatScanFilter)object).c) && Objects.equals(this.d, ((CompatScanFilter)object).d);
        }
        return false;
    }

    public boolean isAllFieldsEmpty() {
        return EMPTY.equals(this);
    }

    public static final class Builder {
        public String a;
        public String b;
        public ParcelUuid c;
        public ParcelUuid d;
        public ParcelUuid e;
        public byte[] f;
        public byte[] g;
        public int h = -1;
        public byte[] i;
        public byte[] j;

        public Builder setDeviceName(String string) {
            this.a = string;
            return this;
        }

        public Builder setDeviceAddress(String string) {
            if (string != null && !BluetoothAdapter.checkBluetoothAddress((String)string)) {
                throw new IllegalArgumentException("invalid device address " + string);
            }
            this.b = string;
            return this;
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid) {
            this.c = parcelUuid;
            this.d = null;
            return this;
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid, ParcelUuid parcelUuid2) {
            if (this.d != null && this.c == null) {
                throw new IllegalArgumentException("uuid is null while uuidMask is not null!");
            }
            this.c = parcelUuid;
            this.d = parcelUuid2;
            return this;
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray) {
            if (parcelUuid != null) {
                this.e = parcelUuid;
                this.f = byArray;
                this.g = null;
                return this;
            }
            throw new IllegalArgumentException("serviceDataUuid is null");
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray, byte[] byArray2) {
            if (parcelUuid != null) {
                byte[] byArray3 = this.g;
                if (this.g != null) {
                    byte[] byArray4 = this.f;
                    if (this.f != null) {
                        if (byArray4.length != byArray3.length) {
                            throw new IllegalArgumentException("size mismatch for service data and service data mask");
                        }
                    } else {
                        throw new IllegalArgumentException("serviceData is null while serviceDataMask is not null");
                    }
                }
                this.e = parcelUuid;
                this.f = byArray;
                this.g = byArray2;
                return this;
            }
            throw new IllegalArgumentException("serviceDataUuid is null");
        }

        public Builder setManufacturerData(int n, byte[] byArray) {
            if (byArray != null && n < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            this.h = n;
            this.i = byArray;
            this.j = null;
            return this;
        }

        public Builder setManufacturerData(int n, byte[] byArray, byte[] byArray2) {
            if (byArray != null && n < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            byte[] byArray3 = this.j;
            if (this.j != null) {
                byte[] byArray4 = this.i;
                if (this.i != null) {
                    if (byArray4.length != byArray3.length) {
                        throw new IllegalArgumentException("size mismatch for manufacturerData and manufacturerDataMask");
                    }
                } else {
                    throw new IllegalArgumentException("manufacturerData is null while manufacturerDataMask is not null");
                }
            }
            this.h = n;
            this.i = byArray;
            this.j = byArray2;
            return this;
        }

        public CompatScanFilter build() {
            Builder builder = string;
            String string = builder.a;
            String string2 = builder.b;
            ParcelUuid parcelUuid = builder.c;
            ParcelUuid parcelUuid2 = builder.d;
            ParcelUuid parcelUuid3 = builder.e;
            byte[] byArray = builder.f;
            byte[] byArray2 = builder.g;
            int n = builder.h;
            byte[] byArray3 = builder.i;
            byte[] byArray4 = builder.j;
            return new CompatScanFilter(string, string2, parcelUuid, parcelUuid2, parcelUuid3, byArray, byArray2, n, byArray3, byArray4, null);
        }
    }
}

