/*
 * Decompiled with CFR 0.152.
 */
package com.realsil.sdk.core.utility;

import android.os.Build;
import android.text.TextUtils;
import com.realsil.sdk.core.logger.ZLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

public class DataConverter {
    public static String str2Hex(String object) {
        StringBuilder stringBuilder;
        String string = object;
        object = "0123456789ABCDEF".toCharArray();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder3 = stringBuilder2;
            byte by = byArray[i];
            stringBuilder2.append((char)object[(by & 0xF0) >> 4]);
            stringBuilder3.append((char)object[by & 0xF]);
            stringBuilder3.append(' ');
        }
        return stringBuilder2.toString().trim();
    }

    public static String hex2Str(String string) {
        int n;
        string = string.toUpperCase();
        char[] cArray = string.toCharArray();
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        if (string.length() % 2 == 1) {
            return "";
        }
        for (n = 0; n < string.length(); ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] >= 'A' && cArray[n] <= 'F') {
                continue;
            }
            return "";
        }
        for (int i = 0; i < n2; ++i) {
            n = i * 2;
            byArray[i] = (byte)("0123456789ABCDEF".indexOf(cArray[n]) * 16 + "0123456789ABCDEF".indexOf(cArray[n + 1]) & 0xFF);
        }
        return new String(byArray);
    }

    public static String str2Unicode(String string) throws Exception {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = Integer.toHexString(c);
            if (c > '\u0080') {
                stringBuilder2.append("\\u" + string2);
                continue;
            }
            stringBuilder2.append("\\u00" + string2);
        }
        return stringBuilder2.toString();
    }

    public static String unicode2Str(String string) {
        StringBuilder stringBuilder;
        int n = string.length() / 6;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            Object object = string.substring(n2 * 6, ++n2 * 6);
            String string2 = ((String)object).substring(2, 4) + "00";
            object = ((String)object).substring(4);
            object = Character.toChars(Integer.valueOf(string2, 16) + Integer.valueOf((String)object, 16));
            stringBuilder2.append(new String((char[])object));
        }
        return stringBuilder2.toString();
    }

    public static byte[] str2Bytes(String object) {
        if (object != null) {
            String string = object;
            object = new byte[string.length() / 2];
            try {
                object = string.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return object;
        }
        throw new IllegalArgumentException("Argument str ( String ) is null! ");
    }

    public static String bytes2Str(byte[] byArray) {
        String string = "";
        int cfr_ignored_0 = byArray.length;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            string = string + (char)byArray[i];
        }
        return string;
    }

    public static String bytes2HexWithSeparate(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(string);
                stringBuilder3.append(" ");
            }
        }
        return stringBuilder2.toString().toUpperCase().trim();
    }

    public static String bytes2Hex(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder2.append(string);
            }
        }
        return stringBuilder2.toString().toUpperCase().trim();
    }

    public static byte[] hex2Bytes(String object) {
        int n;
        char[] cArray;
        String string;
        int n2;
        block18: {
            block17: {
                if (!TextUtils.isEmpty((CharSequence)object)) break block17;
                return null;
            }
            n2 = ((String)object).length();
            String string2 = object;
            object = new byte[n2 / 2];
            string = string2.toUpperCase();
            cArray = string.toCharArray();
            try {
                if (n2 % 2 != 1) break block18;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        for (n = 0; n < n2; ++n) {
            block20: {
                block19: {
                    if (cArray[n] < '0') break block19;
                    if (cArray[n] <= '9') continue;
                }
                if (cArray[n] < 'A') break block20;
                if (cArray[n] > 'F') break block20;
                continue;
            }
            return null;
        }
        for (int i = 0; i < n2; i += 2) {
            Object object2 = object;
            String string3 = string;
            int n3 = i;
            int n4 = n3;
            n = n3 / 2;
            int n5 = Character.digit(string3.charAt(n4), 16);
            byte by = (byte)((n5 << 4) + Character.digit(string.charAt(i + 1), 16));
            object2[n] = by;
            continue;
        }
        return object;
    }

    public static byte[] hex2BigBytes(String string) {
        int n;
        int n2 = string.length();
        int n3 = n2 / 2;
        byte[] byArray = new byte[n3];
        String string2 = string.toUpperCase();
        char[] cArray = string2.toCharArray();
        if (n2 % 2 == 1) {
            return null;
        }
        for (n = 0; n < n2; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] >= 'A' && cArray[n] <= 'F') {
                continue;
            }
            return null;
        }
        for (int i = 0; i < n2; i += 2) {
            n = n3 - i / 2 - 1;
            byArray[n] = (byte)((Character.digit(string2.charAt(i), 16) << 4) + Character.digit(string2.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String ellipsize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 3) {
            return string;
        }
        String string2 = string;
        return string.charAt(0) + "\u22ef" + string2.charAt(string2.length() - 1);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        if (inputStream != null && outputStream != null) {
            int n2;
            byte[] byArray = new byte[n];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
        }
    }

    public static void safeCloseStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                ZLogger.d("Error closing stream: " + throwable.toString());
            }
        }
    }

    public static void safeCloseStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                ZLogger.d("Error closing stream: " + throwable.toString());
            }
        }
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static int littleEndianByteArrayToInt(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return 0;
        }
        int n2 = n;
        n = 0;
        for (int i = (v27891) - 1; i >= 0; --i) {
            n += DataConverter.unsignedByteToInt(byArray[i]) << i * 8;
        }
        return n;
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray2[n] = byArray[i];
            ++n;
        }
        return byArray2;
    }

    public static boolean equals(Object object, Object object2) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.equals(object, object2);
        }
        return object == object2 || object != null && object.equals(object2);
    }
}

