/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.healthring;

import com.elinkthings.bleotalibrary.dialog.DialogOtaManager;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.elinkthings.healthring.bean.ElinkCheckupRealtimeData;
import com.elinkthings.healthring.bean.ElinkRingDeviceStatus;
import com.elinkthings.healthring.bean.ElinkRingHistoryData;
import com.elinkthings.healthring.config.ElinkCheckupType;
import com.elinkthings.healthring.config.ElinkRingHistoryState;
import com.elinkthings.healthring.config.ElinkWearingStatus;
import com.elinkthings.healthring.impl.ImplHealthRingResult;
import com.elinkthings.healthring.impl.ImplSensorOTA;
import com.elinkthings.healthring.utils.ExtensionsKt;
import com.elinkthings.healthring.utils.SensorOTAUtils;
import com.pingwang.bluetoothlib.device.BaseBleDeviceData;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.device.SendBleBean;
import com.pingwang.bluetoothlib.device.SendDataBean;
import com.pingwang.bluetoothlib.device.SendMcuBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 C2\u00020\u0001:\u0001CB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ$\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u001c\u0010\u001c\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u001d\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0012\u0010$\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0010J\u000e\u00101\u001a\u00020\b2\u0006\u0010\u001b\u001a\u000202J\u0010\u00103\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u00104\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u000106J\u0016\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020\bJ\u000e\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\u0012J\u0006\u0010>\u001a\u00020\bJ\u0017\u0010?\u001a\u00020\b2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A\u00a2\u0006\u0002\u0010BR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/elinkthings/healthring/ElinkHealthRingBleData;", "Lcom/pingwang/bluetoothlib/device/BaseBleDeviceData;", "bleDevice", "Lcom/pingwang/bluetoothlib/device/BleDevice;", "(Lcom/pingwang/bluetoothlib/device/BleDevice;)V", "implHealthRingResult", "Lcom/elinkthings/healthring/impl/ImplHealthRingResult;", "closeAutoCheck", "", "deleteHistory", "endSensorOTA", "getAutoCheckState", "getCheckupDuration", "getCheckupType", "getDeviceState", "getDurationFromBytes", "", "bytes", "", "getHistory", "getHistoryOver", "getNextHistory", "getSensorVersion", "onNotifyData", "uuid", "", "hex", "type", "onNotifyDataA6", "openAutoCheck", "parseAutoCheckState", "payload", "parseCheckupDuration", "parseCheckupPackets", "parseCheckupState", "parseCheckupType", "parseData", "parseDeviceStatus", "parseHistory", "parseHistoryData", "Lcom/elinkthings/healthring/bean/ElinkRingHistoryData;", "parseNotifyHistory", "parseRealTimePackets", "parseSensorVersion", "parseSetUnixTimeResult", "sendBleData", "sendMcuData", "setCheckupDuration", "duration", "setCheckupType", "Lcom/elinkthings/healthring/config/ElinkCheckupType;", "setImplHealthRingResult", "setImplSensorOTA", "implSensorOTA", "Lcom/elinkthings/healthring/impl/ImplSensorOTA;", "startBleOTA", "filePath", "callback", "Lcom/elinkthings/bleotalibrary/listener/OnBleOTAListener;", "startCheckup", "startSensorOTA", "fileData", "stopCheckup", "syncUnixTime", "time", "", "(Ljava/lang/Long;)V", "Companion", "moduleHealthRing_release"})
@SourceDebugExtension(value={"SMAP\nElinkHealthRingBleData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElinkHealthRingBleData.kt\ncom/elinkthings/healthring/ElinkHealthRingBleData\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n11345#2:363\n11680#2,3:364\n3801#2:367\n4317#2,2:368\n11345#2:374\n11680#2,3:375\n1549#3:370\n1620#3,3:371\n*S KotlinDebug\n*F\n+ 1 ElinkHealthRingBleData.kt\ncom/elinkthings/healthring/ElinkHealthRingBleData\n*L\n97#1:363\n97#1:364,3\n99#1:367\n99#1:368,2\n162#1:374\n162#1:375,3\n99#1:370\n99#1:371,3\n*E\n"})
public final class ElinkHealthRingBleData
extends BaseBleDeviceData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BleDevice bleDevice;
    @Nullable
    private ImplHealthRingResult implHealthRingResult;
    public static final int ELINK_HEALTH_RING_CID = 93;
    private static final int HISTORY_PAYLOAD_LENGTH = 91;

    public ElinkHealthRingBleData(@NotNull BleDevice bleDevice) {
        Intrinsics.checkNotNullParameter((Object)bleDevice, (String)"bleDevice");
        super(bleDevice);
        this.bleDevice = bleDevice;
    }

    public void onNotifyData(@Nullable String uuid, @Nullable byte[] hex, int type) {
        if (type == 93) {
            this.parseData(hex);
        }
    }

    public void onNotifyDataA6(@Nullable String uuid, @Nullable byte[] hex) {
        this.parseData(hex);
    }

    public final void setImplSensorOTA(@Nullable ImplSensorOTA implSensorOTA) {
        SensorOTAUtils.INSTANCE.setImplSensorOTA(implSensorOTA);
    }

    public final void setImplHealthRingResult(@Nullable ImplHealthRingResult implHealthRingResult) {
        this.implHealthRingResult = implHealthRingResult;
    }

    private final void parseData(byte[] payload) {
        boolean bl = payload != null ? !(payload.length == 0) : false;
        if (bl) {
            switch (payload[0]) {
                case 2: {
                    this.parseCheckupState(payload);
                    break;
                }
                case 3: {
                    byte type = payload[3];
                    byte[] byArray = payload;
                    int n = 4;
                    int n2 = payload.length;
                    byte[] realData = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
                    switch (type) {
                        case 1: {
                            this.parseRealTimePackets(realData);
                            break;
                        }
                        case 2: {
                            this.parseCheckupPackets(realData);
                        }
                    }
                    break;
                }
                case 4: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n3 = payload.length;
                    this.parseCheckupDuration(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n3));
                    break;
                }
                case 5: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n4 = payload.length;
                    this.parseHistory(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n4));
                    break;
                }
                case 6: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n5 = payload.length;
                    this.parseDeviceStatus(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n5));
                    break;
                }
                case 7: {
                    SensorOTAUtils.INSTANCE.parseData(payload);
                    break;
                }
                case 8: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n6 = payload.length;
                    this.parseSensorVersion(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n6));
                    break;
                }
                case 9: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n7 = payload.length;
                    this.parseAutoCheckState(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n7));
                    break;
                }
                case 11: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n8 = payload.length;
                    this.parseCheckupType(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n8));
                    break;
                }
                case 12: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n9 = payload.length;
                    this.parseNotifyHistory(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n9));
                    break;
                }
                case 69: {
                    byte[] byArray = payload;
                    int n = 1;
                    int n10 = payload.length;
                    this.parseSetUnixTimeResult(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n10));
                }
            }
        }
    }

    private final void parseCheckupState(byte[] payload) {
        block1: {
            boolean status;
            block0: {
                byte state = payload[1];
                boolean bl = status = payload[2] == 0;
                if (state != 1) break block0;
                ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
                if (implHealthRingResult == null) break block1;
                implHealthRingResult.startCheckup(status);
                break block1;
            }
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult == null) break block1;
            implHealthRingResult.stopCheckup(status);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseRealTimePackets(byte[] payload) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection;
            byte[] $this$mapTo$iv$iv2;
            void $this$map$iv2;
            if (payload.length != 88 || (payload[0] & 0xFF) != 255) break block4;
            int heartRate = payload[65] & 0xFF;
            int bloodOxygen = payload[66] & 0xFF;
            byte[] byArray = payload;
            int n = 1;
            int n2 = 65;
            byArray = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv2;
            Collection destination$iv$iv22 = new ArrayList(((void)$this$map$iv2).length);
            int $i$f$mapTo22 = 0;
            int n3 = $this$mapTo$iv$iv2.length;
            for (int i = 0; i < n3; ++i) {
                int it;
                void item$iv$iv;
                void var13_19 = item$iv$iv = $this$mapTo$iv$iv2[i];
                collection = destination$iv$iv22;
                boolean bl = false;
                collection.add((int)(it >= 128 ? it - 128 : it + 128));
            }
            List heartList = (List)destination$iv$iv22;
            int rr = payload[75] * 10;
            $this$mapTo$iv$iv2 = payload;
            int destination$iv$iv22 = 80;
            $i$f$mapTo22 = 86;
            $this$mapTo$iv$iv2 = ArraysKt.copyOfRange((byte[])$this$mapTo$iv$iv2, (int)destination$iv$iv22, (int)$i$f$mapTo22);
            boolean $i$f$filter = false;
            void $i$f$mapTo22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (byte element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!(it != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                byte element$iv$iv;
                element$iv$iv = ((Number)item$iv$iv).byteValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(10 * it);
            }
            List rri = (List)destination$iv$iv;
            ElinkCheckupRealtimeData realtimeData = new ElinkCheckupRealtimeData(heartRate, bloodOxygen, heartList, rr, rri);
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetRealtimeData(realtimeData);
            }
        }
    }

    private final void parseCheckupPackets(byte[] payload) {
        block1: {
            if (payload.length != 168) break block1;
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetCheckupPackets(payload);
            }
        }
    }

    private final void parseCheckupDuration(byte[] payload) {
        block1: {
            boolean result;
            boolean bl = result = payload[0] == 2;
            if (!result) break block1;
            byte[] byArray = payload;
            int n = 1;
            int n2 = payload.length;
            int duration = this.getDurationFromBytes(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetCheckupDuration(duration);
            }
        }
    }

    private final void parseHistory(byte[] payload) {
        block3: {
            if (payload.length < 10) {
                return;
            }
            int index = 0;
            int count = payload[index++] & 0xFF;
            int currentIndex = payload[index++] & 0xFF;
            int total = ExtensionsKt.toInt32(ArraysKt.sliceArray((byte[])payload, (IntRange)RangesKt.until((int)index, (int)(index + 4))));
            int sentCount = ExtensionsKt.toInt32(ArraysKt.sliceArray((byte[])payload, (IntRange)RangesKt.until((int)(index += 4), (int)(index + 4))));
            index += 4;
            if (total <= 0) {
                return;
            }
            byte[] byArray = payload;
            int n = payload.length;
            byte[] historyPayload = ArraysKt.copyOfRange((byte[])byArray, (int)index, (int)n);
            int historySize = historyPayload.length / 91;
            ArrayList<byte[]> histories = new ArrayList<byte[]>();
            for (int i = 0; i < historySize; ++i) {
                ElinkRingHistoryData historyData;
                Object object = historyPayload;
                int n2 = i * 91;
                int n3 = (i + 1) * 91;
                ElinkRingHistoryData elinkRingHistoryData = historyData = this.parseHistoryData(ArraysKt.copyOfRange((byte[])object, (int)n2, (int)n3));
                if (elinkRingHistoryData == null) continue;
                Object $this$parseHistory_u24lambda_u243 = object = (Object)elinkRingHistoryData;
                boolean bl = false;
                histories.add((byte[])$this$parseHistory_u24lambda_u243);
            }
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult == null) break block3;
            implHealthRingResult.onGetHistory((List<ElinkRingHistoryData>)histories, total, sentCount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ElinkRingHistoryData parseHistoryData(byte[] payload) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (payload.length != 91) {
            return null;
        }
        byte[] byArray = payload;
        int n = 0;
        int n2 = 4;
        int historyTime = ExtensionsKt.toInt32(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byte[] byArray2 = payload;
        n2 = 4;
        int n3 = payload.length;
        byte[] dataPayload = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        int heartRate = dataPayload[0] & 0xFF;
        int bloodOxygen = dataPayload[1] & 0xFF;
        int bk = dataPayload[2] & 0xFF;
        int sbp = dataPayload[6] & 0xFF;
        int dbp = dataPayload[7] & 0xFF;
        int rr = (dataPayload[10] & 0xFF) * 10;
        int sdann = dataPayload[11] & 0xFF;
        int rmssd = dataPayload[12] & 0xFF;
        int nn50 = dataPayload[13] & 0xFF;
        int pnn50 = dataPayload[14] & 0xFF;
        byte[] byArray3 = dataPayload;
        int n4 = 19;
        int n5 = dataPayload.length;
        byArray3 = ArraysKt.copyOfRange((byte[])byArray3, (int)n4, (int)n5);
        boolean $i$f$map = false;
        void var17_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n6 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n6; ++i) {
            void it;
            void item$iv$iv;
            void var23_25 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(10 * it);
        }
        List rri = (List)destination$iv$iv;
        return new ElinkRingHistoryData(heartRate, bloodOxygen, bk, sbp, dbp, rr, sdann, rmssd, nn50, pnn50, (long)historyTime * 1000L, rri);
    }

    private final void parseDeviceStatus(byte[] payload) {
        block9: {
            ElinkWearingStatus elinkWearingStatus;
            ElinkRingHistoryState elinkRingHistoryState;
            if (payload.length != 13) break block9;
            switch (payload[0]) {
                case 1: {
                    elinkRingHistoryState = ElinkRingHistoryState.PROCESSING;
                    break;
                }
                case 2: {
                    elinkRingHistoryState = ElinkRingHistoryState.READY;
                    break;
                }
                default: {
                    elinkRingHistoryState = ElinkRingHistoryState.NOT_READY;
                }
            }
            ElinkRingHistoryState timeState = elinkRingHistoryState;
            byte batteryValue = payload[1];
            int batteryLevel = batteryValue & 0x7F;
            boolean isCharging = (batteryValue & 0x80) != 0;
            boolean isResting = payload[2] == 1;
            switch (payload[2]) {
                case 0: {
                    elinkWearingStatus = ElinkWearingStatus.UNSUPPORTED;
                    break;
                }
                case 2: {
                    elinkWearingStatus = ElinkWearingStatus.WEARING;
                    break;
                }
                default: {
                    elinkWearingStatus = ElinkWearingStatus.NOT_WEARING;
                }
            }
            ElinkWearingStatus wearingStatus = elinkWearingStatus;
            ElinkRingDeviceStatus deviceStatus = new ElinkRingDeviceStatus(timeState, batteryLevel, isCharging, wearingStatus);
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetDeviceStatus(deviceStatus);
            }
        }
    }

    private final void parseSensorVersion(byte[] payload) {
        block1: {
            if (payload.length < 5 || payload[0] != 106 || payload[1] != 102 || payload[2] != 104) break block1;
            String sensorVersion = ExtensionsKt.toIntStr(payload[3]) + ExtensionsKt.toIntStr(payload[4]);
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetSensorVersion(sensorVersion);
            }
        }
    }

    private final void parseAutoCheckState(byte[] payload) {
        block1: {
            boolean open;
            block2: {
                if (payload.length != 2) break block1;
                boolean bl = open = payload[1] == 0;
                if (payload[0] != 0) break block2;
                ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
                if (implHealthRingResult == null) break block1;
                implHealthRingResult.onGetAutoCheckupStatus(open);
                break block1;
            }
            if (payload[0] != 1) break block1;
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetAutoCheckupStatus(open);
            }
        }
    }

    private final void parseCheckupType(byte[] payload) {
        block1: {
            ElinkCheckupType type;
            block2: {
                if (payload.length != 2) break block1;
                ElinkCheckupType elinkCheckupType = type = payload[1] == 30 ? ElinkCheckupType.FAST : ElinkCheckupType.COMPLEX;
                if (payload[0] != 0) break block2;
                ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
                if (implHealthRingResult == null) break block1;
                implHealthRingResult.onGetCheckupType(type);
                break block1;
            }
            if (payload[0] != 1) break block1;
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onGetCheckupType(type);
            }
        }
    }

    private final void parseNotifyHistory(byte[] payload) {
        block1: {
            if (payload[0] != 0) break block1;
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onNotifyHistoryGenerated();
            }
        }
    }

    private final void parseSetUnixTimeResult(byte[] payload) {
        block1: {
            if (payload.length != 1) break block1;
            boolean result = payload[0] == 0;
            ImplHealthRingResult implHealthRingResult = this.implHealthRingResult;
            if (implHealthRingResult != null) {
                implHealthRingResult.onSetUnixTimeResult(result);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendBleData(byte[] payload) {
        void $this$sendBleData_u24lambda_u245;
        SendBleBean sendBleBean;
        SendBleBean sendBleBean2 = sendBleBean = new SendBleBean();
        ElinkHealthRingBleData elinkHealthRingBleData = this;
        boolean bl = false;
        $this$sendBleData_u24lambda_u245.setHex(payload);
        elinkHealthRingBleData.sendData((SendDataBean)sendBleBean);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendMcuData(byte[] payload) {
        void $this$sendMcuData_u24lambda_u246;
        SendMcuBean sendMcuBean;
        SendMcuBean sendMcuBean2 = sendMcuBean = new SendMcuBean();
        ElinkHealthRingBleData elinkHealthRingBleData = this;
        boolean bl = false;
        $this$sendMcuData_u24lambda_u246.setHex(93, payload);
        elinkHealthRingBleData.sendData((SendDataBean)sendMcuBean);
    }

    public final void startCheckup() {
        byte[] byArray = new byte[]{2, 1};
        this.sendMcuData(byArray);
    }

    public final void stopCheckup() {
        byte[] byArray = new byte[]{2, 0};
        this.sendMcuData(byArray);
    }

    public final void getCheckupDuration() {
        byte[] byArray = new byte[]{4, 0};
        this.sendMcuData(byArray);
    }

    public final void setCheckupDuration(int duration) {
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(3);
        byteSpreadBuilder.add((byte)4);
        byteSpreadBuilder.add((byte)1);
        byteSpreadBuilder.addSpread((Object)ExtensionsKt.toBigEndian2Bytes(duration));
        this.sendMcuData(byteSpreadBuilder.toArray());
    }

    public final void getHistory() {
        int n = 0;
        byte[] byArray = new byte[6];
        while (n < 6) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] payload = byArray;
        payload[0] = 5;
        this.sendMcuData(payload);
    }

    public final void getNextHistory() {
        int n = 0;
        byte[] byArray = new byte[6];
        while (n < 6) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] payload = byArray;
        payload[0] = 5;
        payload[1] = 1;
        this.sendMcuData(payload);
    }

    public final void getHistoryOver() {
        int n = 0;
        byte[] byArray = new byte[6];
        while (n < 6) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] payload = byArray;
        payload[0] = 5;
        payload[1] = 2;
        this.sendMcuData(payload);
    }

    public final void deleteHistory() {
        int n = 0;
        byte[] byArray = new byte[6];
        while (n < 6) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] payload = byArray;
        payload[0] = 5;
        payload[1] = 3;
        this.sendMcuData(payload);
    }

    public final void getAutoCheckState() {
        byte[] byArray = new byte[]{9, 0, 0};
        this.sendMcuData(byArray);
    }

    public final void openAutoCheck() {
        byte[] byArray = new byte[]{9, 1, 0};
        this.sendMcuData(byArray);
    }

    public final void closeAutoCheck() {
        byte[] byArray = new byte[]{9, 1, 1};
        this.sendMcuData(byArray);
    }

    public final void getSensorVersion() {
        byte[] byArray = new byte[]{8, 1};
        this.sendMcuData(byArray);
    }

    public final void getCheckupType() {
        byte[] byArray = new byte[]{11, 0, 0};
        this.sendMcuData(byArray);
    }

    public final void setCheckupType(@NotNull ElinkCheckupType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        byte[] byArray = new byte[]{11, 1, type.getSize()};
        this.sendMcuData(byArray);
    }

    public final void syncUnixTime(@Nullable Long time) {
        Long l = time;
        long timestamp = (l != null ? l : System.currentTimeMillis()) / (long)1000;
        byte[] timeBytes = new byte[]{(byte)(timestamp & 0xFFL), (byte)(timestamp >> 8 & 0xFFL), (byte)(timestamp >> 16 & 0xFFL), (byte)(timestamp >> 24 & 0xFFL)};
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(2);
        byteSpreadBuilder.add((byte)69);
        byteSpreadBuilder.addSpread((Object)timeBytes);
        this.sendBleData(byteSpreadBuilder.toArray());
    }

    public static /* synthetic */ void syncUnixTime$default(ElinkHealthRingBleData elinkHealthRingBleData, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        elinkHealthRingBleData.syncUnixTime(l);
    }

    public final void getDeviceState() {
        int n = 0;
        byte[] byArray = new byte[5];
        while (n < 5) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] payload = byArray;
        payload[0] = 6;
        payload[1] = 1;
        this.sendMcuData(payload);
    }

    public final void startSensorOTA(@NotNull byte[] fileData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        SensorOTAUtils.INSTANCE.startOTA(fileData, this);
    }

    public final void endSensorOTA() {
        SensorOTAUtils.INSTANCE.endOTA();
    }

    public final void startBleOTA(@NotNull String filePath, @NotNull OnBleOTAListener callback) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DialogOtaManager otaManager = DialogOtaManager.newBuilder().setOnBleOTAListener(callback).setFilePath(filePath).setIcType(1).build(this.bleDevice);
        otaManager.startOta();
    }

    private final int getDurationFromBytes(byte[] bytes) {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("The input list must contain exactly 2 bytes.");
        }
        return bytes[0] << 8 | bytes[1];
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/elinkthings/healthring/ElinkHealthRingBleData$Companion;", "", "()V", "ELINK_HEALTH_RING_CID", "", "HISTORY_PAYLOAD_LENGTH", "moduleHealthRing_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

