/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.healthring.utils;

import com.elinkthings.healthring.ElinkHealthRingBleData;
import com.elinkthings.healthring.config.ElinkSensorOTAErrorType;
import com.elinkthings.healthring.impl.ImplSensorOTA;
import com.pingwang.bluetoothlib.device.SendDataBean;
import com.pingwang.bluetoothlib.device.SendMcuBean;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\rJ\u0010\u0010$\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010'\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010(\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/elinkthings/healthring/utils/SensorOTAUtils;", "", "()V", "CMD_ACK_CMD_DONE_A4", "", "CMD_ACK_PAGES_CS_FAIL_A6", "CMD_ACK_PAGES_CS_TRUE_A5", "CMD_CODE_ALL_ERASE_98", "CMD_CODE_PAGES_READ_CHECK_SUM_81", "CMD_CODE_PAGE_WRITE_ONLY_97", "address", "", "fileData", "", "implSensorOTA", "Lcom/elinkthings/healthring/impl/ImplSensorOTA;", "ringBleData", "Lcom/elinkthings/healthring/ElinkHealthRingBleData;", "startOtaCount", "totalSize", "getTotalSize", "()I", "checksum", "bytes", "endOTA", "", "eraseAll", "size", "otaPageReadChecksum", "otaWritePage", "pageReadChecksum", "pageChecksum", "pageWrite", "data", "parseData", "payload", "parseOTAResult", "reverseFileData", "sendMcuData", "setImplSensorOTA", "startOTA", "moduleHealthRing_release"})
public final class SensorOTAUtils {
    @NotNull
    public static final SensorOTAUtils INSTANCE = new SensorOTAUtils();
    private static final byte CMD_CODE_PAGE_WRITE_ONLY_97 = -105;
    private static final byte CMD_CODE_ALL_ERASE_98 = -104;
    private static final byte CMD_CODE_PAGES_READ_CHECK_SUM_81 = -127;
    private static final byte CMD_ACK_CMD_DONE_A4 = -92;
    private static final byte CMD_ACK_PAGES_CS_TRUE_A5 = -91;
    private static final byte CMD_ACK_PAGES_CS_FAIL_A6 = -90;
    @Nullable
    private static byte[] fileData;
    private static int address;
    private static int startOtaCount;
    @Nullable
    private static ElinkHealthRingBleData ringBleData;
    @Nullable
    private static ImplSensorOTA implSensorOTA;

    private SensorOTAUtils() {
    }

    public final void setImplSensorOTA(@Nullable ImplSensorOTA implSensorOTA) {
        SensorOTAUtils.implSensorOTA = implSensorOTA;
    }

    /*
     * WARNING - void declaration
     */
    private final void sendMcuData(byte[] payload) {
        block0: {
            void $this$sendMcuData_u24lambda_u240;
            SendMcuBean sendMcuBean;
            ElinkHealthRingBleData elinkHealthRingBleData = ringBleData;
            if (elinkHealthRingBleData == null) break block0;
            SendMcuBean sendMcuBean2 = sendMcuBean = new SendMcuBean();
            ElinkHealthRingBleData elinkHealthRingBleData2 = elinkHealthRingBleData;
            boolean bl = false;
            $this$sendMcuData_u24lambda_u240.setHex(93, payload);
            elinkHealthRingBleData2.sendData((SendDataBean)sendMcuBean);
        }
    }

    public final void startOTA(@NotNull byte[] fileData, @NotNull ElinkHealthRingBleData ringBleData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)((Object)ringBleData), (String)"ringBleData");
        address = 0;
        SensorOTAUtils.ringBleData = ringBleData;
        SensorOTAUtils.fileData = this.reverseFileData(fileData);
        byte[] byArray = new byte[]{7, 1};
        this.sendMcuData(byArray);
    }

    public final void endOTA() {
        byte[] byArray = new byte[]{7, 2};
        this.sendMcuData(byArray);
    }

    private final void eraseAll(int size) {
        byte[] payload;
        byte[] byArray = new byte[]{7, 3, 85, -86, -104, 4, 0, 0, (byte)(size >> 8), (byte)size};
        byte[] byArray2 = payload = byArray;
        int n = 4;
        int n2 = payload.length;
        byte crc = this.checksum(ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2));
        byArray2 = new byte[]{crc};
        this.sendMcuData(ArraysKt.plus((byte[])payload, (byte[])byArray2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void parseData(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload[0] != 7) {
            return;
        }
        switch (payload[1]) {
            case 1: {
                if (payload[2] == 0) {
                    boolean bl;
                    startOtaCount = 0;
                    if (fileData == null) return;
                    if (fileData != null) {
                        if (fileData.length == 0) {
                            return;
                        }
                        boolean bl2 = false;
                        if (bl2) {
                            return;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                    Intrinsics.checkNotNull((Object)fileData);
                    this.eraseAll(fileData.length);
                    return;
                }
                if (startOtaCount < 3) {
                    int n = startOtaCount;
                    startOtaCount = n + 1;
                    Intrinsics.checkNotNull((Object)fileData);
                    ElinkHealthRingBleData elinkHealthRingBleData = ringBleData;
                    Intrinsics.checkNotNull((Object)((Object)elinkHealthRingBleData));
                    this.startOTA(fileData, elinkHealthRingBleData);
                    return;
                }
                startOtaCount = 0;
                ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                if (implSensorOTA == null) return;
                implSensorOTA.onFailure(ElinkSensorOTAErrorType.START_OTA_FAIL);
                return;
            }
            case 2: {
                if (payload[2] == 0) {
                    startOtaCount = 0;
                    return;
                }
                this.endOTA();
                return;
            }
            case 3: {
                this.parseOTAResult(payload);
            }
        }
    }

    private final void otaWritePage() {
        if (fileData == null) {
            return;
        }
        int endAddress = address + 128;
        if (endAddress > this.getTotalSize()) {
            endAddress = this.getTotalSize();
        }
        int n = 0;
        byte[] byArray = new byte[128];
        while (n < 128) {
            int n2 = n++;
            byArray[n2] = -1;
        }
        byte[] payload = byArray;
        Intrinsics.checkNotNull((Object)fileData);
        byte[] packet = ArraysKt.sliceArray((byte[])fileData, (IntRange)RangesKt.until((int)address, (int)endAddress));
        ArraysKt.copyInto$default((byte[])packet, (byte[])payload, (int)0, (int)0, (int)0, (int)14, null);
        this.pageWrite(payload, address);
    }

    private final void pageWrite(byte[] data, int address) {
        byte[] payload;
        if (data.length != 128) {
            return;
        }
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(9);
        byteSpreadBuilder.add((byte)7);
        byteSpreadBuilder.add((byte)3);
        byteSpreadBuilder.add((byte)85);
        byteSpreadBuilder.add((byte)-86);
        byteSpreadBuilder.add((byte)-105);
        byteSpreadBuilder.add((byte)-126);
        byteSpreadBuilder.add((byte)(address >> 8));
        byteSpreadBuilder.add((byte)address);
        byteSpreadBuilder.addSpread((Object)data);
        byte[] byArray = payload = byteSpreadBuilder.toArray();
        int n = 4;
        int n2 = payload.length;
        byte crc = this.checksum(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byArray = new byte[]{crc};
        this.sendMcuData(ArraysKt.plus((byte[])payload, (byte[])byArray));
    }

    private final void otaPageReadChecksum() {
        if (fileData == null) {
            return;
        }
        int endAddress = address + 128;
        if (endAddress > this.getTotalSize()) {
            endAddress = this.getTotalSize();
        }
        int n = 0;
        byte[] byArray = new byte[128];
        while (n < 128) {
            int n2 = n++;
            byArray[n2] = -1;
        }
        byte[] payload = byArray;
        Intrinsics.checkNotNull((Object)fileData);
        byte[] packet = ArraysKt.sliceArray((byte[])fileData, (IntRange)RangesKt.until((int)address, (int)endAddress));
        ArraysKt.copyInto$default((byte[])packet, (byte[])payload, (int)0, (int)0, (int)0, (int)14, null);
        byte sum = this.checksum(payload);
        this.pageReadChecksum(sum, address);
    }

    private final void pageReadChecksum(byte pageChecksum, int address) {
        byte[] payload;
        byte[] byArray = new byte[]{7, 3, 85, -86, -127, 4, (byte)(address >> 8), (byte)address, 1, pageChecksum};
        byte[] byArray2 = payload = byArray;
        int n = 4;
        int n2 = payload.length;
        byte crc = this.checksum(ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2));
        byArray2 = new byte[]{crc};
        this.sendMcuData(ArraysKt.plus((byte[])payload, (byte[])byArray2));
    }

    private final void parseOTAResult(byte[] payload) {
        block4: {
            block9: {
                block7: {
                    block8: {
                        byte by;
                        block5: {
                            block6: {
                                block2: {
                                    block3: {
                                        by = payload[4];
                                        if (by != -104) break block2;
                                        if (payload[6] != -92 || payload[5] != 1) break block3;
                                        this.otaWritePage();
                                        break block4;
                                    }
                                    ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                                    if (implSensorOTA == null) break block4;
                                    implSensorOTA.onFailure(ElinkSensorOTAErrorType.ERASE_ERROR);
                                    break block4;
                                }
                                if (by != -105) break block5;
                                if (payload[6] != -92 || payload[5] != 1) break block6;
                                double progress = (address > this.getTotalSize() ? 1.0 : (double)address / (double)this.getTotalSize()) * (double)100;
                                ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                                if (implSensorOTA != null) {
                                    implSensorOTA.onProgress((int)progress);
                                }
                                this.otaPageReadChecksum();
                                break block4;
                            }
                            ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                            if (implSensorOTA == null) break block4;
                            implSensorOTA.onFailure(ElinkSensorOTAErrorType.WRITE_ERROR);
                            break block4;
                        }
                        if (by != -127) break block4;
                        if (payload[6] != -91 || payload[5] != 1) break block7;
                        if (fileData == null) {
                            return;
                        }
                        if ((address += 128) >= this.getTotalSize()) break block8;
                        this.otaWritePage();
                        break block4;
                    }
                    address = 0;
                    this.endOTA();
                    ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                    if (implSensorOTA == null) break block4;
                    implSensorOTA.onSuccess();
                    break block4;
                }
                if (payload[6] != -90 || payload[5] != 1) break block9;
                ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
                if (implSensorOTA == null) break block4;
                implSensorOTA.onFailure(ElinkSensorOTAErrorType.CHECK_FAIL);
                break block4;
            }
            ImplSensorOTA implSensorOTA = SensorOTAUtils.implSensorOTA;
            if (implSensorOTA == null) break block4;
            implSensorOTA.onFailure(ElinkSensorOTAErrorType.CHECK_FAIL);
        }
    }

    private final int getTotalSize() {
        return fileData != null ? fileData.length : 0;
    }

    private final byte[] reverseFileData(byte[] fileData) {
        ByteBuffer buffer = ByteBuffer.wrap(fileData, 28, fileData.length - 28);
        buffer.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer mutableBuffer = ByteBuffer.allocate(fileData.length - 28);
        mutableBuffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            int value = buffer.getInt();
            mutableBuffer.putInt(value);
        }
        byte[] byArray = mutableBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mutableBuffer.array()");
        return byArray;
    }

    private final byte checksum(byte[] bytes) {
        int crc = 255;
        for (byte by : bytes) {
            crc = (crc ^ by) & 0xFF;
        }
        return (byte)crc;
    }
}

